/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.container.jd.wi.perf;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.uima.ducc.common.jd.files.JobPerformanceSummary;
import org.apache.uima.ducc.common.jd.files.JobPerformanceSummaryData;
import org.apache.uima.ducc.common.jd.files.JobPerformanceSummaryJsonGz;
import org.apache.uima.ducc.common.jd.files.perf.PerformanceMetricsSummaryItem;
import org.apache.uima.ducc.common.utils.FormatHelper;
import org.apache.uima.ducc.container.common.MessageBuffer;
import org.apache.uima.ducc.container.common.Standardize;
import org.apache.uima.ducc.container.common.SynchronizedStats;
import org.apache.uima.ducc.container.common.logger.IComponent;
import org.apache.uima.ducc.container.common.logger.ILogger;
import org.apache.uima.ducc.container.common.logger.Logger;
import org.apache.uima.ducc.container.jd.wi.perf.IWorkItemPerformanceSummaryInfo;
import org.apache.uima.ducc.container.jd.wi.perf.IWorkItemPerformanceSummaryKeeper;
import org.apache.uima.ducc.container.jd.wi.perf.PerfKey;
import org.apache.uima.ducc.container.jd.wi.perf.WorkItemPerformanceSummaryInfo;

public class WorkItemPerformanceSummaryKeeper
implements IWorkItemPerformanceSummaryKeeper {
    private static Logger logger = Logger.getLogger(WorkItemPerformanceSummaryKeeper.class, IComponent.Id.JD.name());
    private String logDir = null;
    private AtomicLong count = new AtomicLong(0L);
    private AtomicLong total = new AtomicLong(0L);
    private ConcurrentHashMap<PerfKey, SynchronizedStats> map = new ConcurrentHashMap();

    public WorkItemPerformanceSummaryKeeper(String logDir) {
        this.setLogDir(logDir);
    }

    private void setLogDir(String value) {
        this.logDir = value;
    }

    @Override
    public List<IWorkItemPerformanceSummaryInfo> dataGet() {
        ArrayList<IWorkItemPerformanceSummaryInfo> list = new ArrayList<IWorkItemPerformanceSummaryInfo>();
        for (Map.Entry<PerfKey, SynchronizedStats> entry : this.map.entrySet()) {
            String name = entry.getKey().getName();
            String uniqueName = entry.getKey().getUniqueName();
            SynchronizedStats stats = entry.getValue();
            double count = stats.getNum();
            double time = stats.getSum();
            double pctOfTime = 0.0;
            if (this.total.get() > 0L) {
                pctOfTime = time * (double)(100L / this.total.get());
            }
            double avg = stats.getMean();
            double min = stats.getMin();
            double max = stats.getMax();
            WorkItemPerformanceSummaryInfo item = new WorkItemPerformanceSummaryInfo(name, uniqueName, count, time, pctOfTime, avg, min, max);
            list.add(item);
        }
        return list;
    }

    @Override
    public void count() {
        this.count.addAndGet(1L);
    }

    @Override
    public void dataAdd(String name, String uniqueName, long time) {
        String location = "dataAdd";
        try {
            PerfKey perfKey = new PerfKey(name, uniqueName);
            if (!this.map.containsKey(perfKey)) {
                this.map.putIfAbsent(perfKey, new SynchronizedStats());
            }
            SynchronizedStats stats = this.map.get(perfKey);
            stats.addValue(time);
            this.total.addAndGet(time);
            long lTimeSum = (long)stats.getSum();
            String timeSum = FormatHelper.duration((long)lTimeSum, (FormatHelper.Precision)FormatHelper.Precision.Tenths);
            long lTimeAvg = (long)stats.getMean();
            String timeAvg = FormatHelper.duration((long)lTimeAvg, (FormatHelper.Precision)FormatHelper.Precision.Tenths);
            long lTimeMin = (long)stats.getMin();
            String timeMin = FormatHelper.duration((long)lTimeMin, (FormatHelper.Precision)FormatHelper.Precision.Tenths);
            long lTimeMax = (long)stats.getMax();
            String timeMax = FormatHelper.duration((long)lTimeMax, (FormatHelper.Precision)FormatHelper.Precision.Tenths);
            MessageBuffer mb = new MessageBuffer();
            mb.append(Standardize.Label.name.get() + name);
            mb.append(Standardize.Label.sum.get() + timeSum);
            mb.append(Standardize.Label.avg.get() + timeAvg);
            mb.append(Standardize.Label.min.get() + timeMin);
            mb.append(Standardize.Label.max.get() + timeMax);
            mb.append(Standardize.Label.count.get() + this.count.get());
            mb.append(Standardize.Label.total.get() + this.total.get());
            if (lTimeSum < 0L || lTimeAvg < 0L || lTimeMin < 0L || lTimeMax < 0L) {
                logger.warn(location, ILogger.null_id, mb.toString());
            } else {
                logger.debug(location, ILogger.null_id, mb.toString());
            }
        }
        catch (Exception e) {
            logger.error(location, ILogger.null_id, e, new Object[0]);
        }
    }

    private PerformanceMetricsSummaryItem create(IWorkItemPerformanceSummaryInfo wipsi) {
        PerformanceMetricsSummaryItem retVal = new PerformanceMetricsSummaryItem(wipsi.getName(), wipsi.getUniqueName(), (long)wipsi.getTime(), (long)wipsi.getCount(), (long)wipsi.getMin(), (long)wipsi.getMax());
        return retVal;
    }

    @Override
    public void publish() {
        String location = "publish";
        try {
            List<IWorkItemPerformanceSummaryInfo> list = this.dataGet();
            ConcurrentSkipListMap<String, JobPerformanceSummary> map = new ConcurrentSkipListMap<String, JobPerformanceSummary>();
            for (IWorkItemPerformanceSummaryInfo wipsi : list) {
                PerformanceMetricsSummaryItem item = this.create(wipsi);
                JobPerformanceSummary jps = new JobPerformanceSummary();
                jps.setAnalysisTime(item.getAnalysisTime());
                jps.setAnalysisTimeMax(item.getAnalysisTimeMax());
                jps.setAnalysisTimeMin(item.getAnalysisTimeMin());
                jps.setNumProcessed(item.getNumProcessed());
                jps.setName(item.getName());
                jps.setUniqueName(item.getUniqueName());
                map.put(jps.getUniqueName(), jps);
            }
            Integer casCount = new Integer((int)this.count.get());
            JobPerformanceSummaryData data = new JobPerformanceSummaryData(map, casCount);
            JobPerformanceSummaryJsonGz jsonGz = new JobPerformanceSummaryJsonGz(this.logDir);
            jsonGz.exportData(data);
        }
        catch (Exception e) {
            logger.error(location, ILogger.null_id, e, new Object[0]);
        }
    }
}

