/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.container.jd.fsm.wi;

import org.apache.uima.ducc.container.common.MessageBuffer;
import org.apache.uima.ducc.container.common.fsm.iface.IAction;
import org.apache.uima.ducc.container.common.logger.IComponent;
import org.apache.uima.ducc.container.common.logger.ILogger;
import org.apache.uima.ducc.container.common.logger.Logger;
import org.apache.uima.ducc.container.jd.blacklist.JobProcessBlacklist;
import org.apache.uima.ducc.container.jd.fsm.wi.Action;
import org.apache.uima.ducc.container.jd.fsm.wi.IActionData;
import org.apache.uima.ducc.container.jd.log.LoggerHelper;
import org.apache.uima.ducc.container.jd.mh.RemoteWorkerProcess;
import org.apache.uima.ducc.container.jd.mh.iface.remote.IRemoteWorkerThread;

public class ActionProcessBlacklist
extends Action
implements IAction {
    private static Logger logger = Logger.getLogger(ActionProcessBlacklist.class, IComponent.Id.JD.name());

    @Override
    public String getName() {
        return ActionProcessBlacklist.class.getName();
    }

    @Override
    public void engage(Object objectData) {
        String location = "engage";
        logger.trace(location, ILogger.null_id, "");
        IActionData actionData = (IActionData)objectData;
        try {
            if (actionData != null) {
                IRemoteWorkerThread rwt = actionData.getRemoteWorkerThread();
                if (rwt != null) {
                    RemoteWorkerProcess rwp = new RemoteWorkerProcess(rwt);
                    JobProcessBlacklist jobProcessBlacklist = JobProcessBlacklist.getInstance();
                    jobProcessBlacklist.add(rwp);
                } else {
                    MessageBuffer mb = LoggerHelper.getMessageBuffer(actionData);
                    mb.append("No remote worker process entry found for processing");
                    logger.info(location, ILogger.null_id, mb.toString());
                }
            } else {
                MessageBuffer mb = LoggerHelper.getMessageBuffer(actionData);
                mb.append("No action data found for processing");
                logger.warn(location, ILogger.null_id, mb.toString());
            }
        }
        catch (Exception e) {
            logger.error(location, ILogger.null_id, e, new Object[0]);
        }
    }
}

