/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.container.jd.user.error.classload;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.Utils;
import org.apache.uima.ducc.container.common.FlagsExtendedHelper;
import org.apache.uima.ducc.container.common.MessageBuffer;
import org.apache.uima.ducc.container.common.Standardize;
import org.apache.uima.ducc.container.common.classloader.ContextSwitch;
import org.apache.uima.ducc.container.common.classloader.PrivateClassLoader;
import org.apache.uima.ducc.container.common.logger.IComponent;
import org.apache.uima.ducc.container.common.logger.ILogger;
import org.apache.uima.ducc.container.common.logger.Logger;
import org.apache.uima.ducc.container.jd.user.error.classload.ProxyUserErrorException;

public class ProxyUserErrorStringify {
    private static Logger logger = Logger.getLogger(ProxyUserErrorStringify.class, IComponent.Id.JD.name());
    private URLClassLoader urlClassLoader = null;
    private String[] requiredClasses = new String[]{"org.apache.uima.ducc.user.error.iface.IStringify", "org.apache.uima.ducc.user.error.iface.Stringify", "org.apache.uima.ducc.user.error.iface.StringifyUserError"};

    public ProxyUserErrorStringify() throws ProxyUserErrorException {
        this.initialize();
    }

    public String convert(Object userException) throws ProxyUserErrorException {
        String location = "convert";
        String retVal = null;
        try {
            Class<?> clazz = this.urlClassLoader.loadClass("org.apache.uima.ducc.user.error.iface.Stringify");
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            Object[] c_args = new Object[]{};
            Object instance = ContextSwitch.construct(this.urlClassLoader, constructor, c_args);
            Class[] parameterTypes = new Class[]{Object.class};
            Method method = clazz.getMethod("convert", parameterTypes);
            Object[] args = new Object[]{userException};
            Object printableString = ContextSwitch.call(this.urlClassLoader, method, instance, args);
            retVal = (String)printableString;
        }
        catch (Exception e) {
            logger.trace(location, ILogger.null_id, e, new Object[0]);
            throw new ProxyUserErrorException(e);
        }
        return retVal;
    }

    private String getUimaAsDirectory() throws Exception {
        String location = "getUimaAsDirectory";
        try {
            StringBuffer sb = new StringBuffer();
            String duccHome = Utils.findDuccHome();
            sb.append(duccHome);
            if (!duccHome.endsWith(File.separator)) {
                sb.append(File.separator);
            }
            sb.append("apache-uima");
            sb.append(File.separator);
            sb.append("lib");
            sb.append(File.separator);
            sb.append("*");
            String retVal = sb.toString();
            logger.debug(location, ILogger.null_id, retVal);
            return retVal;
        }
        catch (Exception e) {
            logger.error(location, ILogger.null_id, e, new Object[0]);
            throw e;
        }
    }

    private String augmentUserClasspath() throws ProxyUserErrorException {
        String location = "augmentUserClasspath";
        try {
            StringBuffer sb = new StringBuffer();
            FlagsExtendedHelper feh = FlagsExtendedHelper.getInstance();
            String userClasspath = feh.getUserClasspath();
            sb.append(userClasspath);
            if (!userClasspath.endsWith(File.pathSeparator)) {
                sb.append(File.pathSeparator);
            }
            sb.append(this.getUimaAsDirectory());
            String retVal = sb.toString();
            logger.debug(location, ILogger.null_id, retVal);
            return retVal;
        }
        catch (Exception e) {
            logger.error(location, ILogger.null_id, e, new Object[0]);
            throw new ProxyUserErrorException(e);
        }
    }

    private void initialize() throws ProxyUserErrorException {
        String userClasspath = this.augmentUserClasspath();
        this.urlClassLoader = this.createClassLoader(userClasspath);
        this.validate();
    }

    private URLClassLoader createClassLoader(String userClasspath) {
        String location = "createClassLoader";
        URLClassLoader retVal = null;
        try {
            retVal = PrivateClassLoader.create(userClasspath);
        }
        catch (Exception e) {
            logger.error(location, ILogger.null_id, e, new Object[0]);
        }
        return retVal;
    }

    private void validate() throws ProxyUserErrorException {
        for (String className : this.requiredClasses) {
            this.loadClass(className);
        }
    }

    private void loadClass(String className) throws ProxyUserErrorException {
        String location = "loadClass";
        try {
            URL[] urls;
            MessageBuffer mb1 = new MessageBuffer();
            mb1.append(Standardize.Label.loading.get() + className);
            logger.debug(location, ILogger.null_id, mb1.toString());
            for (URL url : urls = this.urlClassLoader.getURLs()) {
                logger.trace(location, ILogger.null_id, url);
            }
            Class<?> loadedClass = this.urlClassLoader.loadClass(className);
            MessageBuffer mb2 = new MessageBuffer();
            mb2.append(Standardize.Label.loaded.get() + loadedClass.getName());
            logger.trace(location, ILogger.null_id, mb2.toString());
        }
        catch (Exception e) {
            DuccLogger duccLogger = DuccLogger.getLogger(ProxyUserErrorStringify.class, (String)"JD");
            duccLogger.error(location, null, (Throwable)e, new Object[0]);
            logger.error(location, ILogger.null_id, e, new Object[0]);
            throw new ProxyUserErrorException(e);
        }
    }
}

