/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.container.common.classloader;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;

public class PrivateClassLoader {
    public static URLClassLoader create(String classPath) throws IOException {
        return PrivateClassLoader.create(classPath.split(":"));
    }

    public static URLClassLoader create(String[] classPathElements) throws IOException {
        ArrayList<URL> urlList = new ArrayList<URL>(classPathElements.length);
        for (String element : classPathElements) {
            if (element.endsWith("*")) {
                File dir = new File(element.substring(0, element.length() - 1));
                File[] files = dir.listFiles();
                if (files == null) continue;
                for (File f : files) {
                    if (!f.getName().endsWith(".jar")) continue;
                    urlList.add(f.getCanonicalFile().toURI().toURL());
                }
                continue;
            }
            File f = new File(element);
            if (!f.exists()) continue;
            urlList.add(f.getCanonicalFile().toURI().toURL());
        }
        URL[] urls = new URL[urlList.size()];
        return new URLClassLoader(urlList.toArray(urls), ClassLoader.getSystemClassLoader().getParent());
    }

    public static void dump(ClassLoader cl, int numLevels) {
        int n = 0;
        for (URLClassLoader ucl = (URLClassLoader)cl; ucl != null && ++n <= numLevels; ucl = (URLClassLoader)ucl.getParent()) {
            System.out.println("Class-loader " + n + " has " + ucl.getURLs().length + " urls:");
            for (URL u : ucl.getURLs()) {
                System.out.println("  " + u);
            }
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            System.out.println("args:  classpath class-to-load");
            return;
        }
        URLClassLoader pcl = PrivateClassLoader.create(args[0]);
        try {
            pcl.loadClass(args[1]);
            System.out.println("loadClass OK");
        }
        catch (ClassNotFoundException e) {
            System.out.println("loadClass failed");
        }
        try {
            Class.forName(args[1], false, pcl);
            System.out.println("forName OK");
        }
        catch (ClassNotFoundException e) {
            System.out.println("forName failed");
        }
        URL res = pcl.findResource(args[1]);
        if (res != null) {
            System.out.println("findResource: " + res);
        } else {
            System.out.println("findResource failed");
        }
        if (args.length > 2) {
            PrivateClassLoader.dump(pcl, 1);
        }
    }
}

