/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.container.jd.wi;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.uima.ducc.container.jd.JobDriver;
import org.apache.uima.ducc.container.jd.mh.iface.remote.IRemoteWorkerThread;
import org.apache.uima.ducc.container.jd.wi.IRunningWorkItemStatistics;
import org.apache.uima.ducc.container.jd.wi.IWorkItem;

public class RunningWorkItemStatistics
implements IRunningWorkItemStatistics {
    private long millisMin = 0L;
    private long millisMax = 0L;
    private long todMostRecentStart = 0L;

    public static RunningWorkItemStatistics getCurrent() {
        long min = Long.MAX_VALUE;
        long max = 0L;
        long todMrs = 0L;
        ConcurrentHashMap<IRemoteWorkerThread, IWorkItem> map = JobDriver.getInstance().getRemoteWorkerThreadMap();
        for (Map.Entry<IRemoteWorkerThread, IWorkItem> entry : map.entrySet()) {
            long tod;
            IWorkItem wi = entry.getValue();
            long time = wi.getMillisOperating();
            if (time > 0L) {
                if (time > max) {
                    max = time;
                }
                if (time < min) {
                    min = time;
                }
            }
            if ((tod = wi.getTodAck()) <= todMrs) continue;
            todMrs = tod;
        }
        if (min > max) {
            min = max;
        }
        RunningWorkItemStatistics retVal = new RunningWorkItemStatistics(min, max, todMrs);
        return retVal;
    }

    public RunningWorkItemStatistics(long min, long max, long todMRS) {
        this.setMillisMin(min);
        this.setMillisMax(max);
        this.setTodMostRecentStart(todMRS);
    }

    @Override
    public void setMillisMin(long value) {
        this.millisMin = value;
    }

    @Override
    public long getMillisMin() {
        return this.millisMin;
    }

    @Override
    public void setMillisMax(long value) {
        this.millisMax = value;
    }

    @Override
    public long getMillisMax() {
        return this.millisMax;
    }

    @Override
    public void setTodMostRecentStart(long value) {
        this.todMostRecentStart = value;
    }

    @Override
    public long getTodMostRecentStart() {
        return this.todMostRecentStart;
    }
}

