/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.container.jd.mh;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.uima.ducc.container.common.MessageBuffer;
import org.apache.uima.ducc.container.common.Standardize;
import org.apache.uima.ducc.container.common.fsm.iface.IEvent;
import org.apache.uima.ducc.container.common.fsm.iface.IFsm;
import org.apache.uima.ducc.container.common.logger.IComponent;
import org.apache.uima.ducc.container.common.logger.ILogger;
import org.apache.uima.ducc.container.common.logger.Logger;
import org.apache.uima.ducc.container.common.logger.id.Id;
import org.apache.uima.ducc.container.common.logger.id.Transform;
import org.apache.uima.ducc.container.dgen.DgenManager;
import org.apache.uima.ducc.container.jd.JobDriver;
import org.apache.uima.ducc.container.jd.JobDriverHelper;
import org.apache.uima.ducc.container.jd.blacklist.JobProcessBlacklist;
import org.apache.uima.ducc.container.jd.cas.CasManager;
import org.apache.uima.ducc.container.jd.cas.CasManagerStats;
import org.apache.uima.ducc.container.jd.fsm.wi.ActionData;
import org.apache.uima.ducc.container.jd.fsm.wi.WiFsm;
import org.apache.uima.ducc.container.jd.mh.IMessageHandler;
import org.apache.uima.ducc.container.jd.mh.RemoteWorkerProcess;
import org.apache.uima.ducc.container.jd.mh.RemoteWorkerThread;
import org.apache.uima.ducc.container.jd.mh.iface.INodeInfo;
import org.apache.uima.ducc.container.jd.mh.iface.IOperatingInfo;
import org.apache.uima.ducc.container.jd.mh.iface.IProcessInfo;
import org.apache.uima.ducc.container.jd.mh.iface.remote.IRemoteWorkerProcess;
import org.apache.uima.ducc.container.jd.mh.iface.remote.IRemoteWorkerThread;
import org.apache.uima.ducc.container.jd.mh.impl.OperatingInfo;
import org.apache.uima.ducc.container.jd.wi.IWorkItem;
import org.apache.uima.ducc.container.jd.wi.IWorkItemStatistics;
import org.apache.uima.ducc.container.jd.wi.RunningWorkItemStatistics;
import org.apache.uima.ducc.container.jd.wi.WiTracker;
import org.apache.uima.ducc.container.jd.wi.perf.IWorkItemPerformanceSummaryKeeper;
import org.apache.uima.ducc.container.net.iface.IMetaCas;
import org.apache.uima.ducc.container.net.iface.IMetaCasTransaction;
import org.apache.uima.ducc.container.net.impl.MetaCas;
import org.apache.uima.ducc.container.net.impl.TransactionHelper;

public class MessageHandler
implements IMessageHandler {
    private static ILogger logger = Logger.getLogger(MessageHandler.class, IComponent.Id.JD.name());
    private static final boolean reportTimes = logger.isDebug();
    private AtomicInteger gets = new AtomicInteger(0);
    private AtomicInteger acks = new AtomicInteger(0);
    private AtomicInteger investmentResets = new AtomicInteger(0);
    private ConcurrentHashMap<String, String> failedInitializationMap = new ConcurrentHashMap();
    private ConcurrentHashMap<IRemoteWorkerThread, IRemoteWorkerThread> wipMap = new ConcurrentHashMap();
    private JobProcessBlacklist jobProcessBlacklist = JobProcessBlacklist.getInstance();
    private static AtomicBoolean piggybacking = new AtomicBoolean(true);
    private static int totalWorkItems = -1;
    private static HashMap<String, long[]> timeMap = new HashMap();

    @Override
    public void incGets() {
        this.gets.incrementAndGet();
    }

    @Override
    public void incAcks() {
        this.acks.incrementAndGet();
    }

    @Override
    public void incInvestmentResets() {
        this.investmentResets.incrementAndGet();
    }

    public static void piggybackingDisable() {
        piggybacking.set(false);
    }

    public static void piggybackingEnable() {
        piggybacking.set(false);
    }

    private void piggyback() {
        String location = "piggyback";
        if (piggybacking.get()) {
            try {
                JobDriver jd = JobDriver.getInstance();
                IWorkItemPerformanceSummaryKeeper wipsk = jd.getWorkItemPerformanceSummaryKeeper();
                wipsk.publish();
            }
            catch (Exception e) {
                logger.error(location, ILogger.null_id, e, new Object[0]);
            }
        }
    }

    @Override
    public IOperatingInfo handleGetOperatingInfo() {
        String location = "handleGetOperatingInfo";
        this.piggyback();
        OperatingInfo retVal = null;
        JobDriver jd = JobDriver.getInstance();
        Id jobid = Transform.toId(jd.getJobId());
        try {
            OperatingInfo oi = new OperatingInfo();
            JobDriverHelper jdh = JobDriverHelper.getInstance();
            CasManager cm = jd.getCasManager();
            CasManagerStats cms = cm.getCasManagerStats();
            IWorkItemStatistics wis = jd.getWorkItemStatistics();
            RunningWorkItemStatistics rwis = RunningWorkItemStatistics.getCurrent();
            DgenManager dgenManager = jd.getDdManager();
            oi.setJobId(jd.getJobId());
            oi.setJpDeployable(dgenManager.getDeployable());
            oi.setWorkItemCrTotal(cms.getCrTotal());
            oi.setWorkItemCrFetches(cms.getCrGets());
            oi.setWorkItemJpGets(this.gets.get());
            oi.setWorkItemJpAcks(this.acks.get());
            oi.setWorkItemJpInvestmentResets(this.investmentResets.get());
            oi.setWorkItemEndSuccesses(cms.getEndSuccess());
            oi.setWorkItemEndFailures(cms.getEndFailure());
            oi.setWorkItemEndRetrys(cms.getEndRetry());
            if (cms.isKillJob()) {
                oi.setKillJob();
            }
            if (jd.isKillJob()) {
                oi.setKillJob();
                oi.setCompletionType(jd.getCompletionType());
                oi.setCompletionText(jd.getCompletionText());
            }
            oi.setWorkItemDispatcheds(cms.getDispatched());
            oi.setWorkItemRetrys(cms.getNumberOfRetrys());
            oi.setWorkItemPreemptions(cms.getNumberOfPreemptions());
            oi.setWorkItemFinishedMillisMin(wis.getMillisMin());
            oi.setWorkItemFinishedMillisMax(wis.getMillisMax());
            oi.setWorkItemFinishedMillisAvg(wis.getMillisAvg());
            oi.setWorkItemRunningMillisMin(rwis.getMillisMin());
            oi.setWorkItemRunningMillisMax(rwis.getMillisMax());
            oi.setWorkItemTodMostRecentStart(rwis.getTodMostRecentStart());
            oi.setActiveWorkItemInfo(jdh.getActiveWorkItemInfo());
            oi.setProcessInfo(jdh.getProcessInfo());
            oi.setJdState(jd.getJdState().name());
            oi.setProcessKillMap(jd.getkillProcessMap());
            MessageBuffer mb = new MessageBuffer();
            mb.append(Standardize.Label.jdState.get() + oi.getJdState());
            mb.append(Standardize.Label.crTotal.get() + oi.getWorkItemCrTotal());
            mb.append(Standardize.Label.crFetches.get() + oi.getWorkItemCrFetches());
            mb.append(Standardize.Label.endSuccess.get() + oi.getWorkItemEndSuccesses());
            mb.append(Standardize.Label.endFailure.get() + oi.getWorkItemEndFailures());
            mb.append(Standardize.Label.killJob.get() + oi.isKillJob());
            mb.append(Standardize.Label.dispatched.get() + oi.getWorkItemDispatcheds());
            mb.append(Standardize.Label.retrys.get() + oi.getWorkItemRetrys());
            mb.append(Standardize.Label.preemptions.get() + oi.getWorkItemPreemptions());
            mb.append(Standardize.Label.finishedMillisMin.get() + oi.getWorkItemFinishedMillisMin());
            mb.append(Standardize.Label.finishedMillisMax.get() + oi.getWorkItemFinishedMillisMax());
            mb.append(Standardize.Label.finishedMillisAvg.get() + oi.getWorkItemFinishedMillisAvg());
            mb.append(Standardize.Label.runningMillisMin.get() + oi.getWorkItemRunningMillisMin());
            mb.append(Standardize.Label.runningMillisMax.get() + oi.getWorkItemRunningMillisMax());
            mb.append(Standardize.Label.todMostRecentStart.get() + oi.getWorkItemTodMostRecentStart());
            logger.debug(location, jobid, mb.toString());
            retVal = oi;
            totalWorkItems = cms.getCrTotal();
        }
        catch (Exception e) {
            logger.error(location, jobid, e, new Object[0]);
        }
        return retVal;
    }

    @Override
    public void handleNodeDown(INodeInfo nodeInfo) {
    }

    private void processBlacklist(IProcessInfo processInfo, IRemoteWorkerProcess rwp) {
        String location = "processBlacklist";
        JobDriver jd = JobDriver.getInstance();
        if (!jd.isFinito()) {
            if (this.jobProcessBlacklist.includes(rwp)) {
                MessageBuffer mb1 = new MessageBuffer();
                mb1.append(Standardize.Label.remote.get() + rwp.toString());
                mb1.append(Standardize.Label.status.get() + "already kaput");
                logger.trace(location, ILogger.null_id, mb1.toString());
            } else {
                this.jobProcessBlacklist.add(rwp);
                MessageBuffer mb1 = new MessageBuffer();
                mb1.append(Standardize.Label.remote.get() + rwp.toString());
                mb1.append(Standardize.Label.status.get() + "transition to down");
                String reasonDeallocated = processInfo.getReasonDeallocated();
                if (reasonDeallocated != null) {
                    mb1.append(Standardize.Label.deallocate.get() + reasonDeallocated);
                }
                logger.warn(location, ILogger.null_id, mb1.toString());
            }
        }
    }

    @Override
    public void handleProcessDown(IProcessInfo processInfo) {
        String location = "handleProcessDown";
        try {
            MessageBuffer mb = new MessageBuffer();
            mb.append(Standardize.Label.node.get() + processInfo.getNodeName());
            mb.append(Standardize.Label.ip.get() + processInfo.getNodeAddress());
            mb.append(Standardize.Label.pid.get() + processInfo.getPid());
            logger.trace(location, ILogger.null_id, mb.toString());
            ConcurrentHashMap<IRemoteWorkerThread, IWorkItem> map = WiTracker.getInstance().find(processInfo);
            for (Map.Entry<IRemoteWorkerThread, IWorkItem> entry : map.entrySet()) {
                IRemoteWorkerThread rwt = entry.getKey();
                if (rwt.comprises(processInfo)) {
                    RemoteWorkerProcess rwp = new RemoteWorkerProcess(rwt);
                    this.processBlacklist(processInfo, rwp);
                    IWorkItem wi = entry.getValue();
                    IFsm fsm = wi.getFsm();
                    IEvent event = WiFsm.Process_Failure;
                    ActionData actionData = new ActionData(wi, rwt, null);
                    fsm.transition(event, actionData);
                    continue;
                }
                MessageBuffer mb1 = new MessageBuffer();
                mb1.append(Standardize.Label.remote.get() + rwt.toString());
                mb1.append(Standardize.Label.status.get() + "unaffected");
                logger.trace(location, ILogger.null_id, mb1.toString());
            }
        }
        catch (Exception e) {
            logger.error(location, ILogger.null_id, e, new Object[0]);
        }
    }

    @Override
    public void handleProcessPreempt(IProcessInfo processInfo) {
        String location = "handleProcessPreempt";
        try {
            MessageBuffer mb = new MessageBuffer();
            mb.append(Standardize.Label.node.get() + processInfo.getNodeName());
            mb.append(Standardize.Label.ip.get() + processInfo.getNodeAddress());
            mb.append(Standardize.Label.pid.get() + processInfo.getPid());
            logger.trace(location, ILogger.null_id, mb.toString());
            ConcurrentHashMap<IRemoteWorkerThread, IWorkItem> map = WiTracker.getInstance().find(processInfo);
            for (Map.Entry<IRemoteWorkerThread, IWorkItem> entry : map.entrySet()) {
                IRemoteWorkerThread rwt = entry.getKey();
                if (rwt.comprises(processInfo)) {
                    RemoteWorkerProcess rwp = new RemoteWorkerProcess(rwt);
                    this.processBlacklist(processInfo, rwp);
                    IWorkItem wi = entry.getValue();
                    IFsm fsm = wi.getFsm();
                    IEvent event = WiFsm.Process_Preempt;
                    ActionData actionData = new ActionData(wi, rwt, null);
                    fsm.transition(event, actionData);
                    continue;
                }
                MessageBuffer mb1 = new MessageBuffer();
                mb1.append(Standardize.Label.remote.get() + rwt.toString());
                mb1.append(Standardize.Label.status.get() + "unaffected");
                logger.trace(location, ILogger.null_id, mb1.toString());
            }
        }
        catch (Exception e) {
            logger.error(location, ILogger.null_id, e, new Object[0]);
        }
    }

    @Override
    public void handleProcessVolunteered(IProcessInfo processInfo) {
        String location = "handleProcessVolunteered";
        try {
            MessageBuffer mb = new MessageBuffer();
            mb.append(Standardize.Label.node.get() + processInfo.getNodeName());
            mb.append(Standardize.Label.ip.get() + processInfo.getNodeAddress());
            mb.append(Standardize.Label.pid.get() + processInfo.getPid());
            logger.trace(location, ILogger.null_id, mb.toString());
            ConcurrentHashMap<IRemoteWorkerThread, IWorkItem> map = WiTracker.getInstance().find(processInfo);
            for (Map.Entry<IRemoteWorkerThread, IWorkItem> entry : map.entrySet()) {
                IRemoteWorkerThread rwt = entry.getKey();
                if (rwt.comprises(processInfo)) {
                    RemoteWorkerProcess rwp = new RemoteWorkerProcess(rwt);
                    this.processBlacklist(processInfo, rwp);
                    IWorkItem wi = entry.getValue();
                    IFsm fsm = wi.getFsm();
                    IEvent event = WiFsm.Process_Volunteered;
                    ActionData actionData = new ActionData(wi, rwt, null);
                    fsm.transition(event, actionData);
                    continue;
                }
                MessageBuffer mb1 = new MessageBuffer();
                mb1.append(Standardize.Label.remote.get() + rwt.toString());
                mb1.append(Standardize.Label.status.get() + "unaffected");
                logger.trace(location, ILogger.null_id, mb1.toString());
            }
        }
        catch (Exception e) {
            logger.error(location, ILogger.null_id, e, new Object[0]);
        }
    }

    private void block(IRemoteWorkerThread rwt) {
        IRemoteWorkerThread result;
        String location = "block";
        if (rwt != null && (result = this.wipMap.putIfAbsent(rwt, rwt)) != null) {
            MessageBuffer mb = new MessageBuffer();
            mb.append(Standardize.Label.remote.get() + rwt.toString());
            mb.append(Standardize.Label.status.get() + "delayed");
            logger.warn(location, ILogger.null_id, mb.toString());
            while (result != null) {
                try {
                    Thread.sleep(200L);
                }
                catch (Exception e) {
                    // empty catch block
                }
                result = this.wipMap.putIfAbsent(rwt, rwt);
            }
            mb = new MessageBuffer();
            mb.append(Standardize.Label.remote.get() + rwt.toString());
            mb.append(Standardize.Label.status.get() + "in-force");
            logger.warn(location, ILogger.null_id, mb.toString());
        }
    }

    private void unblock(IRemoteWorkerThread rwt) {
        if (rwt != null) {
            this.wipMap.remove(rwt);
        }
    }

    @Override
    public void handleProcessFailedInitialization(IProcessInfo processInfo) {
        String location = "handleProcessFailedInitialization";
        try {
            MessageBuffer mb = new MessageBuffer();
            mb.append(Standardize.Label.node.get() + processInfo.getNodeName());
            mb.append(Standardize.Label.ip.get() + processInfo.getNodeAddress());
            mb.append(Standardize.Label.pid.get() + processInfo.getPid());
            logger.trace(location, ILogger.null_id, mb.toString());
            String nodeName = processInfo.getNodeName();
            String nodeAddress = processInfo.getNodeAddress();
            int pid = processInfo.getPid();
            StringBuffer sb = new StringBuffer();
            sb.append(nodeName);
            sb.append(File.pathSeparator);
            sb.append(nodeAddress);
            sb.append(pid);
            String jp = sb.toString();
            JobDriver jd = JobDriver.getInstance();
            boolean isKillJob = jd.isKillJob();
            boolean added = this.failedInitializationMap.putIfAbsent(jp, jp) == null;
            int failedCount = this.failedInitializationMap.size();
            int failedLimit = jd.getStartupInitializationErrorLimit();
            if (added) {
                mb = new MessageBuffer();
                mb.append(Standardize.Label.node.get() + nodeName);
                mb.append(Standardize.Label.ip.get() + nodeAddress);
                mb.append(Standardize.Label.pid.get() + pid);
                mb.append(Standardize.Label.count.get() + failedCount);
                mb.append(Standardize.Label.limit.get() + failedCount);
                mb.append(Standardize.Label.isKillJob.get() + isKillJob);
                logger.info(location, ILogger.null_id, mb.toString());
                if (!isKillJob && failedCount >= failedLimit) {
                    IMetaCasTransaction.JdState jdState = jd.getJdState();
                    switch (jdState) {
                        case Initializing: {
                            String text = "startup initialization error limit exceeded";
                            jd.killJob(IOperatingInfo.CompletionType.Exception, text);
                            mb = new MessageBuffer();
                            mb.append(Standardize.Label.node.get() + nodeName);
                            mb.append(Standardize.Label.ip.get() + nodeAddress);
                            mb.append(Standardize.Label.pid.get() + pid);
                            mb.append(Standardize.Label.isKillJob.get() + jd.isKillJob());
                            mb.append(Standardize.Label.type.get() + jd.getCompletionType().toString());
                            mb.append(Standardize.Label.reason.get() + jd.getCompletionText());
                            logger.info(location, ILogger.null_id, mb.toString());
                            break;
                        }
                    }
                }
            } else {
                mb = new MessageBuffer();
                mb.append(Standardize.Label.node.get() + nodeName);
                mb.append(Standardize.Label.ip.get() + nodeAddress);
                mb.append(Standardize.Label.pid.get() + pid);
                mb.append(Standardize.Label.count.get() + failedCount);
                logger.trace(location, ILogger.null_id, mb.toString());
            }
        }
        catch (Exception e) {
            logger.error(location, ILogger.null_id, e, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMetaCasTransation(IMetaCasTransaction trans) {
        String location = "handleMetaCasTransation";
        RemoteWorkerThread rwt = null;
        try {
            trans.setResponseHints(new ArrayList<IMetaCasTransaction.Hint>());
            rwt = new RemoteWorkerThread(trans);
            this.block(rwt);
            MessageBuffer mb = new MessageBuffer();
            mb.append(Standardize.Label.remote.get() + rwt.toString());
            mb.append(Standardize.Label.type.get() + (Object)((Object)trans.getType()));
            logger.debug(location, ILogger.null_id, mb.toString());
            IMetaCasTransaction.Type type = trans.getType();
            long stime = System.nanoTime();
            switch (type) {
                case Get: {
                    this.handleMetaCasTransationGet(trans, rwt);
                    break;
                }
                case Ack: {
                    this.handleMetaCasTransationAck(trans, rwt);
                    break;
                }
                case End: {
                    this.handleMetaCasTransationEnd(trans, rwt);
                    break;
                }
                case InvestmentReset: {
                    this.handleMetaCasTransationInvestmentReset(trans, rwt);
                    break;
                }
            }
            MessageHandler.accumulateTimes(type.name(), stime);
            IMetaCasTransaction.JdState jdState = JobDriver.getInstance().getJdState();
            trans.setJdState(jdState);
            IMetaCas metaCas = trans.getMetaCas();
            if (metaCas != null) {
                metaCas.setPerformanceMetrics(null);
                metaCas.setUserSpaceException(null);
            }
            this.unblock(rwt);
        }
        catch (Exception e) {
            try {
                logger.error(location, ILogger.null_id, e, new Object[0]);
                this.unblock(rwt);
            }
            catch (Throwable throwable) {
                this.unblock(rwt);
                throw throwable;
            }
        }
    }

    private void update(IWorkItem wi, IMetaCas metaCas) {
        IMetaCas local = wi.getMetaCas();
        IMetaCas remote = metaCas;
        if (local != null && remote != null) {
            local.setPerformanceMetrics(remote.getPerformanceMetrics());
            local.setUserSpaceException(remote.getUserSpaceException());
        }
    }

    private void handleMetaCasTransationGet(IMetaCasTransaction trans, IRemoteWorkerThread rwt) {
        WiTracker tracker = WiTracker.getInstance();
        IWorkItem wi = tracker.link(rwt);
        IFsm fsm = wi.getFsm();
        IEvent event = WiFsm.Get_Request;
        ActionData actionData = new ActionData(wi, rwt, trans);
        fsm.transition(event, actionData);
    }

    private void handleMetaCasTransationAck(IMetaCasTransaction trans, IRemoteWorkerThread rwt) {
        MetaCas metaCas;
        String location = "handleMetaCasTransationAck";
        WiTracker tracker = WiTracker.getInstance();
        if (tracker.isRecognized(rwt, metaCas = (MetaCas)trans.getMetaCas())) {
            IWorkItem wi = tracker.find(rwt);
            this.update(wi, metaCas);
            IFsm fsm = wi.getFsm();
            IEvent event = WiFsm.Ack_Request;
            ActionData actionData = new ActionData(wi, rwt, trans);
            fsm.transition(event, actionData);
            MessageBuffer mb = new MessageBuffer();
            mb.append(Standardize.Label.AckMsecs.get() + (wi.getTodAck() - wi.getTodGet()));
            logger.debug(location, ILogger.null_id, mb.toString());
        } else {
            trans.setMetaCas(null);
            TransactionHelper.addResponseHint(trans, IMetaCasTransaction.Hint.Rejected);
        }
    }

    private void handleMetaCasTransationEnd(IMetaCasTransaction trans, IRemoteWorkerThread rwt) {
        MetaCas metaCas;
        String location = "handleMetaCasTransationEnd";
        WiTracker tracker = WiTracker.getInstance();
        if (tracker.isRecognized(rwt, metaCas = (MetaCas)trans.getMetaCas())) {
            IWorkItem wi = tracker.find(rwt);
            this.update(wi, metaCas);
            IFsm fsm = wi.getFsm();
            IEvent event = WiFsm.End_Request;
            ActionData actionData = new ActionData(wi, rwt, trans);
            fsm.transition(event, actionData);
            MessageBuffer mb = new MessageBuffer();
            mb.append(Standardize.Label.EndMsecs.get() + (wi.getTodEnd() - wi.getTodAck()));
            logger.debug(location, ILogger.null_id, mb.toString());
        } else {
            trans.setMetaCas(null);
            TransactionHelper.addResponseHint(trans, IMetaCasTransaction.Hint.Rejected);
        }
    }

    private void handleMetaCasTransationInvestmentReset(IMetaCasTransaction trans, IRemoteWorkerThread rwt) {
        MetaCas metaCas;
        String location = "handleMetaCasTransationInvestmentReset";
        WiTracker tracker = WiTracker.getInstance();
        if (tracker.isRecognized(rwt, metaCas = (MetaCas)trans.getMetaCas())) {
            IWorkItem wi = tracker.find(rwt);
            this.update(wi, metaCas);
            IFsm fsm = wi.getFsm();
            IEvent event = WiFsm.Investment_Reset;
            ActionData actionData = new ActionData(wi, rwt, trans);
            fsm.transition(event, actionData);
            MessageBuffer mb = new MessageBuffer();
            mb.append(Standardize.Label.remote.get() + rwt.toString());
            mb.append("investment reset");
            logger.debug(location, ILogger.null_id, mb.toString());
        } else {
            trans.setMetaCas(null);
            TransactionHelper.addResponseHint(trans, IMetaCasTransaction.Hint.Rejected);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void accumulateTimes(String name, long stime) {
        if (!reportTimes) {
            return;
        }
        long elapsed = System.nanoTime() - stime;
        HashMap<String, long[]> hashMap = timeMap;
        synchronized (hashMap) {
            long[] nums = timeMap.get(name);
            if (nums == null) {
                nums = new long[]{0L, 0L, 10000000000L, 0L};
                timeMap.put(name, nums);
            }
            nums[0] = nums[0] + 1L;
            nums[1] = nums[1] + elapsed;
            if (elapsed < nums[2]) {
                nums[2] = elapsed;
            } else if (elapsed > nums[3]) {
                nums[3] = elapsed;
            }
            if (nums[0] == (long)totalWorkItems && name.equals("Get")) {
                for (String nam : timeMap.keySet()) {
                    nums = timeMap.get(nam);
                    logger.debug("accumulateTimes", ILogger.null_id, "Elapsed times at last Get: " + nam + ": " + nums[0] + " avg: " + 1.0E-6 * (double)nums[1] / (double)nums[0] + " min: " + (double)nums[2] * 1.0E-6 + " max: " + (double)nums[3] * 1.0E-6 + " msec");
                }
            }
        }
    }
}

