/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.container.jd.fsm.wi;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.uima.ducc.common.jd.files.workitem.IWorkItemStateKeeper;
import org.apache.uima.ducc.container.common.MessageBuffer;
import org.apache.uima.ducc.container.common.MetaCasHelper;
import org.apache.uima.ducc.container.common.Standardize;
import org.apache.uima.ducc.container.common.fsm.iface.IAction;
import org.apache.uima.ducc.container.common.fsm.iface.IEvent;
import org.apache.uima.ducc.container.common.fsm.iface.IFsm;
import org.apache.uima.ducc.container.common.logger.IComponent;
import org.apache.uima.ducc.container.common.logger.ILogger;
import org.apache.uima.ducc.container.common.logger.Logger;
import org.apache.uima.ducc.container.jd.JobDriver;
import org.apache.uima.ducc.container.jd.JobDriverHelper;
import org.apache.uima.ducc.container.jd.blacklist.JobProcessBlacklist;
import org.apache.uima.ducc.container.jd.cas.CasManager;
import org.apache.uima.ducc.container.jd.fsm.wi.IActionData;
import org.apache.uima.ducc.container.jd.fsm.wi.WiFsm;
import org.apache.uima.ducc.container.jd.log.LoggerHelper;
import org.apache.uima.ducc.container.jd.mh.RemoteWorkerProcess;
import org.apache.uima.ducc.container.jd.mh.iface.IOperatingInfo;
import org.apache.uima.ducc.container.jd.mh.iface.remote.IRemoteWorkerProcess;
import org.apache.uima.ducc.container.jd.mh.iface.remote.IRemoteWorkerThread;
import org.apache.uima.ducc.container.jd.wi.IProcessStatistics;
import org.apache.uima.ducc.container.jd.wi.IWorkItem;
import org.apache.uima.ducc.container.jd.wi.WiTracker;
import org.apache.uima.ducc.container.net.iface.IMetaCas;
import org.apache.uima.ducc.container.net.iface.IMetaCasTransaction;
import org.apache.uima.ducc.container.net.impl.TransactionHelper;

public class ActionGet
implements IAction {
    private static Logger logger = Logger.getLogger(ActionGet.class, IComponent.Id.JD.name());
    private ConcurrentHashMap<IRemoteWorkerProcess, Long> warnedJobDiscontinued = new ConcurrentHashMap();
    private ConcurrentHashMap<IRemoteWorkerProcess, Long> warnedProcessDiscontinued = new ConcurrentHashMap();
    private ConcurrentHashMap<IRemoteWorkerProcess, Long> warnedExhausted = new ConcurrentHashMap();

    @Override
    public String getName() {
        return ActionGet.class.getName();
    }

    @Override
    public void engage(Object objectData) {
        String location = "engage";
        logger.trace(location, ILogger.null_id, "enter");
        IActionData actionData = (IActionData)objectData;
        try {
            if (actionData != null) {
                MessageBuffer mb;
                IRemoteWorkerThread rwt = actionData.getRemoteWorkerThread();
                WiTracker tracker = WiTracker.getInstance();
                IWorkItem wi = tracker.find(rwt);
                IFsm fsm = wi.getFsm();
                IMetaCasTransaction trans = actionData.getMetaCasTransaction();
                RemoteWorkerProcess rwp = new RemoteWorkerProcess(trans);
                JobDriver jd = JobDriver.getInstance();
                JobDriverHelper jdh = JobDriverHelper.getInstance();
                jd.advanceJdState(IMetaCasTransaction.JdState.Active);
                CasManager cm = jd.getCasManager();
                IMetaCas metaCas = null;
                JobProcessBlacklist jobProcessBlacklist = JobProcessBlacklist.getInstance();
                if (cm.getCasManagerStats().isExhausted()) {
                    if (!this.warnedExhausted.containsKey(rwp)) {
                        MessageBuffer mbx = LoggerHelper.getMessageBuffer(actionData);
                        mbx.append(Standardize.Label.node.get() + rwp.getNodeName());
                        mbx.append(Standardize.Label.pid.get() + rwp.getPid());
                        mbx.append(Standardize.Label.text.get() + "all CASes processed");
                        logger.debug(location, ILogger.null_id, mbx.toString());
                        this.warnedExhausted.put(rwp, new Long(System.currentTimeMillis()));
                    }
                    TransactionHelper.addResponseHint(trans, IMetaCasTransaction.Hint.Exhausted);
                } else if (cm.getCasManagerStats().isKillJob()) {
                    if (!this.warnedJobDiscontinued.containsKey(rwp)) {
                        mb = LoggerHelper.getMessageBuffer(actionData);
                        mb.append(Standardize.Label.node.get() + rwp.getNodeName());
                        mb.append(Standardize.Label.pid.get() + rwp.getPid());
                        mb.append(Standardize.Label.text.get() + "job discontinued");
                        logger.warn(location, ILogger.null_id, mb.toString());
                        this.warnedJobDiscontinued.put(rwp, new Long(System.currentTimeMillis()));
                    }
                    TransactionHelper.addResponseHint(trans, IMetaCasTransaction.Hint.Killed);
                } else if (jobProcessBlacklist.includes(rwp)) {
                    if (!this.warnedProcessDiscontinued.containsKey(rwp)) {
                        mb = LoggerHelper.getMessageBuffer(actionData);
                        mb.append(Standardize.Label.node.get() + rwp.getNodeName());
                        mb.append(Standardize.Label.pid.get() + rwp.getPid());
                        mb.append(Standardize.Label.text.get() + "process discontinued");
                        logger.warn(location, ILogger.null_id, mb.toString());
                        this.warnedProcessDiscontinued.put(rwp, new Long(System.currentTimeMillis()));
                    }
                    TransactionHelper.addResponseHint(trans, IMetaCasTransaction.Hint.Blacklisted);
                } else {
                    metaCas = cm.getMetaCas();
                }
                wi.setMetaCas(metaCas);
                trans.setMetaCas(metaCas);
                IWorkItemStateKeeper wisk = jd.getWorkItemStateKeeper();
                MetaCasHelper metaCasHelper = new MetaCasHelper(metaCas);
                IProcessStatistics pStats = jdh.getProcessStatistics(rwp);
                IEvent event = null;
                if (metaCas != null) {
                    int seqNo = metaCasHelper.getSystemKey();
                    String wiId = metaCas.getUserKey();
                    String node = rwt.getNodeAddress();
                    String pid = "" + rwt.getPid();
                    String tid = "" + rwt.getTid();
                    wisk.start(seqNo, wiId, node, pid, tid);
                    wisk.queued(seqNo);
                    pStats.dispatch(wi);
                    wi.setTodGet();
                    event = WiFsm.CAS_Available;
                    MessageBuffer mb2 = LoggerHelper.getMessageBuffer(actionData);
                    JobDriver.getInstance().getMessageHandler().incGets();
                    logger.info(location, ILogger.null_id, mb2.toString());
                } else {
                    event = WiFsm.CAS_Unavailable;
                    MessageBuffer mb3 = LoggerHelper.getMessageBuffer(actionData);
                    mb3.append("No CAS found for processing");
                    logger.debug(location, ILogger.null_id, mb3.toString());
                    if (cm.getCasManagerStats().isExhausted()) {
                        if (!this.warnedExhausted.containsKey(rwp)) {
                            MessageBuffer mbx = LoggerHelper.getMessageBuffer(actionData);
                            mbx.append(Standardize.Label.node.get() + rwp.getNodeName());
                            mbx.append(Standardize.Label.pid.get() + rwp.getPid());
                            mbx.append(Standardize.Label.text.get() + "all CASes processed");
                            logger.debug(location, ILogger.null_id, mbx.toString());
                            this.warnedExhausted.put(rwp, new Long(System.currentTimeMillis()));
                        }
                        TransactionHelper.addResponseHint(trans, IMetaCasTransaction.Hint.Exhausted);
                    }
                }
                fsm.transition(event, actionData);
            } else {
                MessageBuffer mb = LoggerHelper.getMessageBuffer(actionData);
                mb.append("No action data found for processing");
                logger.warn(location, ILogger.null_id, mb.toString());
            }
        }
        catch (Exception e) {
            logger.error(location, ILogger.null_id, e, new Object[0]);
            JobDriver.getInstance().killJob(IOperatingInfo.CompletionType.Exception);
        }
        logger.trace(location, ILogger.null_id, "exit");
    }
}

