/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.container.jd.blacklist;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.uima.ducc.container.common.MessageBuffer;
import org.apache.uima.ducc.container.common.Standardize;
import org.apache.uima.ducc.container.common.logger.IComponent;
import org.apache.uima.ducc.container.common.logger.ILogger;
import org.apache.uima.ducc.container.common.logger.Logger;
import org.apache.uima.ducc.container.jd.mh.iface.remote.IRemoteWorkerProcess;

public class JobProcessBlacklist {
    private static ILogger logger = Logger.getLogger(JobProcessBlacklist.class, IComponent.Id.JD.name());
    private static ConcurrentHashMap<IRemoteWorkerProcess, Long> map = new ConcurrentHashMap();
    private static JobProcessBlacklist instance = new JobProcessBlacklist();
    private static boolean disabled = false;

    public static JobProcessBlacklist getInstance() {
        return instance;
    }

    public void add(IRemoteWorkerProcess rwp) {
        String location = "add";
        if (!disabled && rwp != null && !map.containsKey(rwp)) {
            Long time = new Long(System.currentTimeMillis());
            map.put(rwp, time);
            MessageBuffer mb = new MessageBuffer();
            mb.append(Standardize.Label.node.get() + rwp.getNodeName());
            mb.append(Standardize.Label.pid.get() + rwp.getPid());
            logger.debug(location, ILogger.null_id, mb.toString());
        }
    }

    public void remove(IRemoteWorkerProcess rwp) {
        String location = "remove";
        if (!disabled && rwp != null) {
            map.remove(rwp);
            MessageBuffer mb = new MessageBuffer();
            mb.append(Standardize.Label.node.get() + rwp.getNodeName());
            mb.append(Standardize.Label.pid.get() + rwp.getPid());
            logger.debug(location, ILogger.null_id, mb.toString());
        }
    }

    public boolean includes(IRemoteWorkerProcess rwp) {
        String location = "includes";
        boolean retVal = false;
        if (!disabled && rwp != null) {
            retVal = map.containsKey(rwp);
            MessageBuffer mb = new MessageBuffer();
            mb.append(Standardize.Label.node.get() + rwp.getNodeName());
            mb.append(Standardize.Label.pid.get() + rwp.getPid());
            mb.append(Standardize.Label.size.get() + map.size());
            mb.append(Standardize.Label.value.get() + retVal);
            logger.trace(location, ILogger.null_id, mb.toString());
        }
        return retVal;
    }

    public void disable() {
        disabled = true;
    }
}

