/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.jd.files.perf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.uima.ducc.common.jd.files.perf.PerformanceMetricsSummaryItem;
import org.apache.uima.ducc.common.jd.files.perf.PerformanceMetricsSummaryMap;
import org.apache.uima.ducc.common.jd.files.perf.PerformanceSummary;
import org.apache.uima.ducc.common.jd.files.perf.UimaStatistic;

public class ViewJobPerformanceSummary {
    public static int cascount;

    public static void main(String[] args) {
        PerformanceSummary performanceSummary;
        PerformanceMetricsSummaryMap performanceMetricsSummaryMap;
        if (args.length < 1) {
            System.out.println("this command takes one arg: job-log-dir");
            System.exit(1);
        }
        if ((performanceMetricsSummaryMap = (performanceSummary = new PerformanceSummary(args[0])).readSummary()) == null || performanceMetricsSummaryMap.size() == 0) {
            System.err.println("Null map");
            System.exit(1);
        }
        cascount = performanceMetricsSummaryMap.casCount();
        ArrayList<UimaStatistic> uimaStats = new ArrayList<UimaStatistic>();
        uimaStats.clear();
        long analysisTime = 0L;
        try {
            for (Map.Entry<String, PerformanceMetricsSummaryItem> entry : performanceMetricsSummaryMap.entrySet()) {
                String key = entry.getKey();
                int posName = key.lastIndexOf(61);
                long anTime = entry.getValue().getAnalysisTime();
                long anMinTime = entry.getValue().getAnalysisTimeMin();
                long anMaxTime = entry.getValue().getAnalysisTimeMax();
                analysisTime += anTime;
                if (posName <= 0) continue;
                String shortname = key.substring(posName + 1);
                UimaStatistic stat = new UimaStatistic(shortname, entry.getKey(), anTime, anMinTime, anMaxTime);
                uimaStats.add(stat);
            }
            Collections.sort(uimaStats);
            int numstats = uimaStats.size();
            System.out.println("Job = " + args[0]);
            System.out.printf("Processed %d workitems, Average time = %.1f seconds%n", cascount, (double)analysisTime / (1000.0 * (double)cascount));
            System.out.println("Component breakdown (ave time per workitem in sec):");
            for (int i = 0; i < numstats; ++i) {
                System.out.println(((UimaStatistic)uimaStats.get(i)).toString());
            }
        }
        catch (Exception e) {
            System.err.println("Problem parsing PerformanceMetricSummaryMap");
        }
    }
}

