/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.admin.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.uima.ducc.common.admin.event.RmAdminReply;
import org.apache.uima.ducc.common.admin.event.RmQueriedMachine;

public class RmAdminQOccupancyReply
extends RmAdminReply {
    private static final long serialVersionUID = 1L;
    boolean ready = true;
    List<RmQueriedMachine> machines = new ArrayList<RmQueriedMachine>();

    public void addMachine(RmQueriedMachine m) {
        this.machines.add(m);
    }

    @Override
    public void notReady() {
        this.ready = false;
    }

    @Override
    public boolean isReady() {
        return this.ready;
    }

    public List<RmQueriedMachine> getMachines() {
        return this.machines;
    }

    public String toString() {
        if (!this.ready) {
            return "RM is not yet initialized.";
        }
        Collections.sort(this.machines, new MachineByMemorySorter());
        StringBuffer sb = new StringBuffer();
        sb.append("[\n");
        for (RmQueriedMachine m : this.machines) {
            sb.append(m.toString());
            sb.append(",\n");
        }
        sb.append("]");
        return sb.toString();
    }

    class MachineByMemorySorter
    implements Comparator<RmQueriedMachine> {
        MachineByMemorySorter() {
        }

        @Override
        public int compare(RmQueriedMachine m1, RmQueriedMachine m2) {
            long mm2;
            long mm1 = m1.getMemory();
            if (mm1 == (mm2 = m2.getMemory())) {
                return m1.getId().compareTo(m2.getId());
            }
            return (int)(mm2 - mm1);
        }
    }
}

