/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.main;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.security.AnyTypePermission;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.concurrent.Future;
import org.apache.activemq.camel.component.ActiveMQComponent;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.dataformat.xstream.XStreamDataFormat;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.DefaultClassResolver;
import org.apache.camel.spi.ClassResolver;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.uima.ducc.common.IDuccUser;
import org.apache.uima.ducc.common.admin.event.DuccAdminEvent;
import org.apache.uima.ducc.common.admin.event.DuccAdminEventKill;
import org.apache.uima.ducc.common.admin.event.DuccAdminEventStopMetrics;
import org.apache.uima.ducc.common.authentication.BrokerCredentials;
import org.apache.uima.ducc.common.component.AbstractDuccComponent;
import org.apache.uima.ducc.common.crypto.Crypto;
import org.apache.uima.ducc.common.launcher.ssh.DuccRemoteLauncher;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.Utils;

public class DuccAdmin
extends AbstractDuccComponent
implements DuccRemoteLauncher.ProcessCompletionCallback {
    public static final String FileSeparator = System.getProperty("file.separator");
    private String brokerUrl;
    private ProducerTemplate pt;
    private String targetEndpoint;
    private CommandLine commandLine;

    public DuccAdmin(CamelContext context) {
        super("DuccServiceReaper", context);
        try {
            this.loadProperties("ducc.deploy.configuration");
            this.brokerUrl = System.getProperty("ducc.broker.url");
            try {
                String brokerCredentialsFile = System.getProperty("ducc.broker.credentials.file");
                this.targetEndpoint = System.getProperty("ducc.admin.endpoint");
                System.out.println("+++ Activating JMS Component for Endpoint:" + this.targetEndpoint + " Broker:" + this.brokerUrl);
                ActiveMQComponent duccAMQComponent = new ActiveMQComponent(context);
                duccAMQComponent.setBrokerURL(this.brokerUrl);
                if (brokerCredentialsFile != null && brokerCredentialsFile.length() > 0) {
                    String path = "";
                    try {
                        Utils.findDuccHome();
                        path = Utils.resolvePlaceholderIfExists(brokerCredentialsFile, System.getProperties());
                        BrokerCredentials.Credentials credentials = BrokerCredentials.get(path);
                        if (credentials.getUsername() != null && credentials.getPassword() != null) {
                            duccAMQComponent.setUserName(credentials.getUsername());
                            duccAMQComponent.setPassword(credentials.getPassword());
                        }
                    }
                    catch (FileNotFoundException e) {
                        System.out.println("DuccAdmin Failed - File Not Found:" + path + " Broker Credentials File:" + brokerCredentialsFile);
                        System.exit(-1);
                    }
                }
                context.addComponent("activemq", (Component)duccAMQComponent);
                this.pt = context.createProducerTemplate();
            }
            catch (Throwable exx) {
                System.out.println("DuccAdmin Failed:" + exx);
                System.exit(-1);
            }
        }
        catch (Exception e) {
            System.out.println("DuccAdmin was not able to load properties from " + System.getProperty("ducc.deploy.configuration"));
            System.exit(-1);
        }
    }

    @Override
    public DuccLogger getLogger() {
        return new DuccLogger("Admin");
    }

    public void dispatch(String serializedEvent) throws Exception {
        this.pt.sendBody(this.targetEndpoint, (Object)serializedEvent);
    }

    public String serializeAdminEvent(DuccAdminEvent event) {
        XStreamDataFormat xStreamDataFormat = new XStreamDataFormat();
        xStreamDataFormat.setPermissions("*");
        XStream xStream = xStreamDataFormat.getXStream((ClassResolver)new DefaultClassResolver());
        xStream.addPermission(AnyTypePermission.ANY);
        return xStream.toXML((Object)event);
    }

    public Options getPosixOptions() {
        Options posixOptions = new Options();
        posixOptions.addOption(DuccCommands.killAll.name(), false, "Kill All Ducc Processes");
        OptionBuilder.hasArgs((int)2);
        OptionBuilder.withDescription((String)"starting agents defined in arg1 using command defined in arg2");
        Option startAgentsOption = OptionBuilder.create((String)"startAgents");
        posixOptions.addOption(startAgentsOption);
        OptionBuilder.hasArgs((int)1);
        OptionBuilder.withDescription((String)"quiescing agents defined in arg1");
        Option quiesceAgentsOption = OptionBuilder.create((String)"quiesceAgents");
        posixOptions.addOption(quiesceAgentsOption);
        return posixOptions;
    }

    public void parseWithPosixParser(String[] args) {
        PosixParser cmdLinePosixParser = new PosixParser();
        Options posixOptions = this.getPosixOptions();
        try {
            this.commandLine = cmdLinePosixParser.parse(posixOptions, args);
        }
        catch (ParseException parseException) {
            System.err.println("Exception while parsing using commandling with PosixParser:\n" + parseException.getMessage());
        }
    }

    private void killAll() throws Exception {
        String user = System.getProperty("user.name");
        Crypto crypto = new Crypto(user, true);
        byte[] cypheredMessage = crypto.getSignature();
        this.dispatch(this.serializeAdminEvent(new DuccAdminEventKill(user, cypheredMessage)));
        System.out.println("DuccAdmin sent Kill to all Ducc processes ...");
    }

    private void quiesceAgents(String nodes) throws Exception {
        String user = System.getProperty("user.name");
        Crypto crypto = new Crypto(user, true);
        byte[] cypheredMessage = crypto.getSignature();
        this.dispatch(this.serializeAdminEvent(new DuccAdminEventStopMetrics(nodes, user, cypheredMessage)));
        System.out.println("DuccAdmin sent Quiesce request to Ducc Agents ...");
    }

    private String readCommand(String commandFile) throws FileNotFoundException, IOException {
        File file = new File(commandFile);
        FileInputStream in = new FileInputStream(file);
        long length = file.length();
        byte[] bytes = new byte[(int)length];
        int numRead = 0;
        for (int offset = 0; offset < bytes.length && (numRead = ((InputStream)in).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
        }
        ((InputStream)in).close();
        return new String(bytes);
    }

    private void startAgents(String nodesFile, String commandFile) {
        InputStream in = null;
        try {
            String strLine;
            String command = this.readCommand(commandFile);
            command = Utils.resolvePlaceholderIfExists(command, System.getProperties());
            System.out.println("Command To Run:" + command);
            in = new FileInputStream(nodesFile);
            BufferedReader br = new BufferedReader(new InputStreamReader(new DataInputStream(in)));
            String sshUser = System.getenv(IDuccUser.EnvironmentVariable.USER.value());
            String userHome = System.getProperty("user.home");
            String sshIdentityLocation = userHome + FileSeparator + ".ssh" + FileSeparator + "id_dsa";
            DuccRemoteLauncher remoteLauncher = new DuccRemoteLauncher(sshUser, sshIdentityLocation, System.out);
            ArrayList<Future<DuccRemoteLauncher.ProcessCompletionResult>> results = new ArrayList<Future<DuccRemoteLauncher.ProcessCompletionResult>>();
            while ((strLine = br.readLine()) != null) {
                results.add(remoteLauncher.execute(strLine.trim(), command, this));
            }
            in.close();
            for (Future future : results) {
                future.get();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void process() throws Exception {
        if (this.commandLine.hasOption(DuccCommands.killAll.name())) {
            this.killAll();
        } else if (this.commandLine.hasOption(DuccCommands.startAgents.name())) {
            System.out.println("---------- Starting Agents");
            String[] args = this.commandLine.getOptionValues(DuccCommands.startAgents.name());
            this.startAgents(args[0], args[1]);
        } else if (this.commandLine.hasOption(DuccCommands.quiesceAgents.name())) {
            System.out.println("---------- Quiescing Agents");
            String[] args = this.commandLine.getOptionValues(DuccCommands.quiesceAgents.name());
            this.quiesceAgents(args[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            DuccAdmin admin = new DuccAdmin((CamelContext)new DefaultCamelContext());
            admin.parseWithPosixParser(args);
            admin.process();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            System.exit(-1);
        }
    }

    @Override
    public void completed(DuccRemoteLauncher.ProcessCompletionResult result) {
        StringBuffer sb = new StringBuffer();
        if (result.exitCode != 0) {
            sb.append("DuccRemoteLauncher Failure. Host:").append(result.host).append(" Error:").append(result.stderr).append("\nCommand:").append(result.command);
        } else {
            sb.append("DuccRemoteLauncher Launched Command on Host:").append(result.host);
        }
        System.out.println(sb.toString());
    }

    public static enum DuccCommands {
        killAll,
        startAgents,
        quiesceAgents;

    }
}

