/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.jd.files.perf;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.uima.ducc.common.jd.files.IJobPerformanceSummary;
import org.apache.uima.ducc.common.jd.files.JobPerformanceSummary;
import org.apache.uima.ducc.common.jd.files.JobPerformanceSummaryData;
import org.apache.uima.ducc.common.jd.files.perf.PerformanceMetricsSummaryItem;
import org.apache.uima.ducc.common.jd.files.perf.PerformanceMetricsSummaryMap;
import org.apache.uima.ducc.common.jd.files.perf.PerformanceSummaryBase;

public class PerformanceSummaryReader
extends PerformanceSummaryBase {
    @Deprecated
    private boolean legacy = true;

    public PerformanceSummaryReader(String dirname) {
        super(dirname);
    }

    @Deprecated
    public PerformanceMetricsSummaryMap readJsonGz() throws IOException, ClassNotFoundException {
        PerformanceMetricsSummaryMap map = new PerformanceMetricsSummaryMap();
        JobPerformanceSummaryData data = this.jsonGz.importData();
        Integer casCount = data.getCasCount();
        map.putCasCount(casCount);
        ConcurrentSkipListMap<String, JobPerformanceSummary> gzMap = data.getMap();
        Set<Map.Entry<String, JobPerformanceSummary>> entries = gzMap.entrySet();
        for (Map.Entry<String, JobPerformanceSummary> entry : entries) {
            String key = entry.getKey();
            IJobPerformanceSummary jps = entry.getValue();
            PerformanceMetricsSummaryItem value = new PerformanceMetricsSummaryItem(jps.getName(), jps.getUniqueName(), jps.getAnalysisTime(), jps.getNumProcessed(), jps.getAnalysisTimeMin(), jps.getAnalysisTimeMax());
            map.putItem(key, value);
        }
        return map;
    }

    public PerformanceMetricsSummaryMap readJsonGz(String userId) throws IOException, ClassNotFoundException {
        PerformanceMetricsSummaryMap map = new PerformanceMetricsSummaryMap();
        JobPerformanceSummaryData data = null;
        try {
            data = this.jsonGz.importData(userId);
        }
        catch (Exception e) {
            System.err.println("readJsonGz " + userId + " ignoring exception " + e);
        }
        if (data == null) {
            return null;
        }
        Integer casCount = data.getCasCount();
        map.putCasCount(casCount);
        ConcurrentSkipListMap<String, JobPerformanceSummary> gzMap = data.getMap();
        Set<Map.Entry<String, JobPerformanceSummary>> entries = gzMap.entrySet();
        for (Map.Entry<String, JobPerformanceSummary> entry : entries) {
            String key = entry.getKey();
            IJobPerformanceSummary jps = entry.getValue();
            PerformanceMetricsSummaryItem value = new PerformanceMetricsSummaryItem(jps.getName(), jps.getUniqueName(), jps.getAnalysisTime(), jps.getNumProcessed(), jps.getAnalysisTimeMin(), jps.getAnalysisTimeMax());
            map.putItem(key, value);
        }
        return map;
    }

    @Deprecated
    private PerformanceMetricsSummaryMap readSer() {
        PerformanceMetricsSummaryMap map = null;
        if (this.legacy) {
            try {
                FileInputStream fis = new FileInputStream(this.filename);
                ObjectInputStream in = new ObjectInputStream(fis);
                this.summaryMap = (PerformanceMetricsSummaryMap)in.readObject();
                in.close();
                map = this.getSummaryMap();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return map;
    }

    @Deprecated
    public PerformanceMetricsSummaryMap readSummary() {
        PerformanceMetricsSummaryMap map = null;
        try {
            map = this.readJsonGz();
            return map;
        }
        catch (Exception e) {
            if (!this.legacy) {
                e.printStackTrace();
            }
            map = this.readSer();
            return map;
        }
    }

    public PerformanceMetricsSummaryMap readSummary(String userId) {
        PerformanceMetricsSummaryMap map = null;
        try {
            map = this.readJsonGz(userId);
        }
        catch (Exception e) {
            System.err.println("readSummary " + userId + " ignoring exception " + e);
        }
        if (map == null && this.legacy) {
            map = this.readSer();
        }
        return map;
    }
}

