/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccProperties;
import org.apache.uima.ducc.common.utils.IllegalConfigurationException;
import org.apache.uima.ducc.common.utils.SystemPropertyResolver;
import org.apache.uima.ducc.common.utils.id.DuccId;

public class NodeConfiguration {
    String config_file_name = null;
    String ducc_nodes = null;
    String ducc_users = null;
    BufferedReader in;
    int lineno = 0;
    DuccProperties defaultFairShareClass = new DuccProperties();
    DuccProperties defaultFixedShareClass = new DuccProperties();
    DuccProperties defaultReserveClass = new DuccProperties();
    DuccProperties defaultNodepool = new DuccProperties();
    DuccProperties defaultUser = new DuccProperties();
    Map<String, DuccProperties> nodepools = new HashMap<String, DuccProperties>();
    ArrayList<DuccProperties> independentNodepools = new ArrayList();
    List<DuccProperties> classes = new ArrayList<DuccProperties>();
    Map<String, DuccProperties> clmap = new HashMap<String, DuccProperties>();
    Map<String, DuccProperties> usermap = new HashMap<String, DuccProperties>();
    ArrayList<String> independentClasses = new ArrayList();
    Map<String, String> allNodes = new HashMap<String, String>();
    Map<String, DuccProperties> poolsByNodefile = new HashMap<String, DuccProperties>();
    Map<String, DuccProperties> poolsByNodeName = new HashMap<String, DuccProperties>();
    Map<String, String> allImports = new HashMap<String, String>();
    Map<String, String> referrers = new HashMap<String, String>();
    DuccLogger logger;
    String defaultDomain = null;
    int defaultQuantum = 15;
    String firstNodepool = null;
    boolean fairShareExists = false;
    boolean fixedExists = false;
    boolean reserveExists = false;
    DuccProperties fairShareDefault = null;
    DuccProperties fixedDefault = null;
    DuccProperties reserveDefault = null;
    String ducc_home = null;
    StringTokenizer buf = null;
    String pushback = null;

    public NodeConfiguration(String config_file_name, String ducc_nodes, String ducc_users, DuccLogger logger) {
        this.config_file_name = config_file_name;
        this.ducc_nodes = ducc_nodes;
        this.ducc_users = ducc_users;
        this.logger = logger;
        this.ducc_home = System.getProperty("DUCC_HOME");
        this.defaultFairShareClass.put("type", "class");
        this.defaultFairShareClass.put("name", "defaultFairShareClass");
        this.defaultFairShareClass.put("policy", "FAIR_SHARE");
        this.defaultFairShareClass.put("weight", "100");
        this.defaultFairShareClass.put("priority", "10");
        this.defaultFairShareClass.put("cap", Integer.toString(Integer.MAX_VALUE));
        this.defaultFairShareClass.put("expand-by-doubling", "" + SystemPropertyResolver.getBooleanProperty("ducc.rm.expand.by.doubling", true));
        this.defaultFairShareClass.put("initialization-cap", "" + SystemPropertyResolver.getIntProperty("ducc.rm.initialization.cap", 2));
        this.defaultFairShareClass.put("use-prediction", "" + SystemPropertyResolver.getBooleanProperty("ducc.rm.prediction", true));
        this.defaultFairShareClass.put("prediction-fudge", "" + SystemPropertyResolver.getIntProperty("ducc.rm.prediction.fudge", 60000));
        this.defaultFairShareClass.put("max-processes", "<optional>");
        this.defaultFairShareClass.put("nodepool", "<required>");
        this.defaultFairShareClass.put("users", "<optional>");
        this.defaultFairShareClass.put("debug", "fixed");
        this.defaultFairShareClass.put("abstract", "<optional>");
        this.defaultFairShareClass.put("children", "<optional>");
        this.defaultFairShareClass.put("parent", "<optional>");
        this.defaultFairShareClass.put("debug", "<optional>");
        this.defaultFairShareClass.put("default", "<optional>");
        this.defaultFairShareClass.put("name", "<required>");
        this.defaultFixedShareClass.put("type", "class");
        this.defaultFixedShareClass.put("name", "defaultFixedShareClass");
        this.defaultFixedShareClass.put("abstract", "<optional>");
        this.defaultFixedShareClass.put("children", "<optional>");
        this.defaultFixedShareClass.put("parent", "<optional>");
        this.defaultFixedShareClass.put("policy", "FIXED_SHARE");
        this.defaultFixedShareClass.put("priority", "5");
        this.defaultFixedShareClass.put("default", "<optional>");
        this.defaultFixedShareClass.put("max-processes", "<optional>");
        this.defaultFixedShareClass.put("cap", "<optional>");
        this.defaultFixedShareClass.put("nodepool", "<required>");
        this.defaultFixedShareClass.put("users", "<optional>");
        this.defaultReserveClass.put("type", "class");
        this.defaultReserveClass.put("name", "defaultReserveClass");
        this.defaultReserveClass.put("abstract", "<optional>");
        this.defaultReserveClass.put("children", "<optional>");
        this.defaultReserveClass.put("parent", "<optional>");
        this.defaultReserveClass.put("policy", "RESERVE");
        this.defaultReserveClass.put("priority", "1");
        this.defaultReserveClass.put("default", "<optional>");
        this.defaultReserveClass.put("max-machines", "<optional>");
        this.defaultReserveClass.put("cap", "<optional>");
        this.defaultReserveClass.put("nodepool", "<required>");
        this.defaultReserveClass.put("users", "<optional>");
        this.defaultReserveClass.put("enforce", "true");
        this.defaultNodepool.put("type", "nodepool");
        this.defaultNodepool.put("name", "<optional>");
        this.defaultNodepool.put("nodefile", "<optional>");
        this.defaultNodepool.put("parent", "<optional>");
        this.defaultNodepool.put("share-quantum", "<optional>");
        this.defaultNodepool.put("domain", "<optional>");
        this.defaultNodepool.put("search-order", "100");
        this.defaultUser.put("type", "user");
        this.defaultUser.put("name", "<optional>");
        this.defaultUser.put("max-allotment", Integer.toString(Integer.MAX_VALUE));
    }

    String resolve(String file) throws IllegalConfigurationException {
        File f;
        if (file == null) {
            return null;
        }
        if (!file.startsWith("/")) {
            file = this.ducc_home + "/resources/" + file;
        }
        if (!(f = new File(file)).exists()) {
            return null;
        }
        return file;
    }

    void logInfo(String methodName, String message) {
        if (this.logger == null) {
            System.out.println(message);
        } else {
            this.logger.info(methodName, null, message);
        }
    }

    void logWarn(String methodName, String message) {
        if (this.logger == null) {
            System.out.println(message);
        } else {
            this.logger.warn(methodName, null, message);
        }
    }

    void logError(String methodName, String message) {
        if (this.logger == null) {
            System.out.println(message);
        } else {
            this.logger.error(methodName, null, message);
        }
    }

    private String getDomainName() {
        String location = "getDomainName";
        DuccId jobid = null;
        if (this.defaultDomain != null) {
            return this.defaultDomain;
        }
        InetAddress me = null;
        try {
            me = InetAddress.getLocalHost();
            String my_happy_name = me.getHostName();
            String my_canonical_name = me.getCanonicalHostName();
            if (my_canonical_name.startsWith(my_happy_name)) {
                int ndx = my_canonical_name.indexOf(".");
                return my_canonical_name.substring(ndx + 1);
            }
        }
        catch (UnknownHostException e1) {
            this.logger.error(location, jobid, e1, new Object[0]);
        }
        return null;
    }

    String readLine() throws IOException {
        String line = null;
        while ((line = this.in.readLine()) != null) {
            ++this.lineno;
            if ((line = line.trim()).equals("") || line.startsWith("#")) continue;
            return line + ";";
        }
        return null;
    }

    boolean fillBuf() throws IOException {
        while (this.buf == null || !this.buf.hasMoreTokens()) {
            String line = this.readLine();
            if (line == null) {
                return false;
            }
            this.buf = new StringTokenizer(line, "\n\t\r\f{} =,;", true);
        }
        return true;
    }

    String nextToken() throws IOException {
        if (this.pushback != null) {
            String ret = this.pushback;
            this.pushback = null;
            return ret;
        }
        while (this.fillBuf()) {
            String tok = null;
            while (this.buf.hasMoreTokens()) {
                tok = this.buf.nextToken();
                if (tok.equals(" ") || tok.equals("\t") || tok.equals(",")) continue;
                return tok;
            }
        }
        return null;
    }

    String consume() throws IOException {
        String tok = this.nextToken();
        if (tok.equals("=")) {
            tok = this.nextToken();
        }
        if (tok.equals("}")) {
            return tok;
        }
        if (tok.equals("{")) {
            return tok;
        }
        String ret = null;
        while (tok != null) {
            if (tok.equals(";")) {
                return ret;
            }
            if (tok.equals("}") || tok.equals("{")) {
                this.pushback = tok;
                return ret;
            }
            ret = ret == null ? tok : ret + " " + tok;
            tok = this.nextToken();
        }
        return ret;
    }

    void parseInternal(DuccProperties props) throws IOException, IllegalConfigurationException {
        String tok = null;
        while ((tok = this.nextToken()) != null) {
            if (tok.equals(";")) continue;
            if (tok.equals("}")) {
                return;
            }
            String k = tok;
            if (k.equals("{")) {
                throw new IllegalConfigurationException("Missing '}' near line " + this.lineno + " in " + this.config_file_name);
            }
            String v = this.consume();
            if (v.equals("}")) {
                throw new IllegalConfigurationException("Missing value near line " + this.lineno + " in " + this.config_file_name);
            }
            if (v.equals("{")) {
                throw new IllegalConfigurationException("Missing '}' near line " + this.lineno + " in " + this.config_file_name);
            }
            if (!props.containsKey(k)) {
                props.put(k, v);
                continue;
            }
            throw new IllegalConfigurationException("Duplicate property not allowed near line " + this.lineno + " in " + this.config_file_name + ": " + k);
        }
    }

    DuccProperties parseNodepool(String name, String parent) throws IOException, IllegalConfigurationException {
        if (this.firstNodepool == null) {
            this.firstNodepool = name;
        }
        DuccProperties ret = new DuccProperties();
        ret.put("type", "nodepool");
        ret.put("name", name);
        if (parent != null) {
            throw new IllegalConfigurationException("Illegal inheritance (inheritance not supported for nodepools) near line " + this.lineno + " in " + this.config_file_name);
        }
        if (this.nodepools.containsKey(name)) {
            throw new IllegalConfigurationException("Duplicate nodepool: " + name);
        }
        this.nodepools.put(name, ret);
        this.parseInternal(ret);
        String dd = ret.getProperty("domain");
        if (name.equals(this.firstNodepool) && dd != null) {
            this.defaultDomain = dd;
        } else if (dd != null) {
            throw new IllegalConfigurationException("Default domain specified in nodepool other than first nodepool \"" + this.firstNodepool + "\", not allowed, near line " + this.lineno + " in " + this.config_file_name);
        }
        this.supplyDefaults(ret, this.defaultNodepool);
        if (!ret.containsKey("nodefile") && this.ducc_nodes != null) {
            ret.put("nodefile", this.ducc_nodes);
        }
        if (!ret.containsKey("parent")) {
            this.independentNodepools.add(ret);
        }
        return ret;
    }

    DuccProperties parseClass(String name, String parent) throws IOException, IllegalConfigurationException {
        DuccProperties ret = new DuccProperties();
        ret.put("type", "class");
        ret.put("name", name);
        if (parent != null) {
            ret.put("parent", parent);
        }
        this.parseInternal(ret);
        return ret;
    }

    DuccProperties parseUser(String name, String parent) throws IOException, IllegalConfigurationException {
        DuccProperties ret = new DuccProperties();
        ret.put("type", "user");
        ret.put("name", name);
        if (parent != null) {
            ret.put("parent", parent);
        }
        this.parseInternal(ret);
        return ret;
    }

    DuccProperties parseStanzas() throws IOException, IllegalConfigurationException {
        String tok;
        while ((tok = this.nextToken()) != null) {
            if (tok.equals(";")) continue;
            String type = tok;
            String name = this.nextToken();
            if (name == null) {
                throw new IllegalConfigurationException("Missing stanza name near line " + this.lineno + " in " + this.config_file_name);
            }
            String parent = this.nextToken();
            String start = null;
            if (parent.equals("{")) {
                start = parent;
                parent = null;
            } else {
                start = this.nextToken();
            }
            if (!start.equals("{")) {
                throw new IllegalConfigurationException("Missing '{' near line " + this.lineno + " in " + this.config_file_name);
            }
            if (type.equals("Nodepool")) {
                this.nodepools.put(name, this.parseNodepool(name, parent));
            }
            if (type.equals("Class")) {
                this.classes.add(this.parseClass(name, parent));
            }
            if (!type.equals("User")) continue;
            this.usermap.put(name, this.parseUser(name, parent));
        }
        return null;
    }

    void supplyDefaults(DuccProperties in, DuccProperties model) throws IllegalConfigurationException {
        String k;
        String name = in.getProperty("name");
        String type = in.getProperty("type");
        for (Object o : in.keySet()) {
            k = (String)o;
            if (model.get(k) != null) continue;
            throw new IllegalConfigurationException("Illegal property \"" + k + "\" in " + type + " " + name);
        }
        for (Object o : model.keySet()) {
            k = (String)o;
            String vm = model.getProperty(k);
            String vi = in.getProperty(k);
            if (vi != null) continue;
            if (vm.equals("<required>")) {
                throw new IllegalConfigurationException("Missing required property " + k + " in " + type + " " + name);
            }
            if (vm.contains("<optional>")) continue;
            in.put(k, vm);
        }
    }

    void propogateDown(String clname) {
        String[] kids;
        DuccProperties cl = this.clmap.get(clname);
        String children = cl.getStringProperty("children", null);
        if (children == null) {
            return;
        }
        for (String kid : kids = children.split("\\s+")) {
            DuccProperties kp = this.clmap.get(kid);
            for (Object o : cl.keySet()) {
                String k;
                if (kp.containsKey(o) || (k = (String)o).equals("abstract") || k.equals("children") || k.equals("default")) continue;
                String v = cl.getStringProperty(k);
                kp.put(k, v);
            }
            this.propogateDown(kid);
        }
    }

    void handleDefault(DuccProperties p, DuccProperties def, String policy) throws IllegalConfigurationException {
        String dflt = p.getProperty("default");
        if (dflt != null) {
            if (def != null) {
                throw new IllegalConfigurationException("Class " + p.getProperty("name") + ": Only one " + policy + " default allowed.  Already defined in class \"" + def.getProperty("name") + "\"");
            }
            if (policy.equals("FAIR_SHARE")) {
                this.fairShareDefault = p;
            } else if (policy.equals("FIXED_SHARE")) {
                this.fixedDefault = p;
            } else {
                this.reserveDefault = p;
            }
        }
    }

    void doClassInheritance() throws IllegalConfigurationException {
        String name;
        for (DuccProperties p : this.classes) {
            String name2 = p.getStringProperty("name");
            if (this.clmap.containsKey(name2)) {
                throw new IllegalConfigurationException("Duplicate class: " + name2);
            }
            this.clmap.put(name2, p);
        }
        for (DuccProperties p : this.clmap.values()) {
            String parent = p.getProperty("parent");
            name = p.getProperty("name");
            if (p.getProperty("abstract") != null && p.getProperty("default") != null) {
                throw new IllegalConfigurationException("Class " + name + ": Abstract class is not allowed to specify \"default\"");
            }
            if (parent == null) {
                this.independentClasses.add(name);
                continue;
            }
            DuccProperties par_cl = this.clmap.get(parent);
            if (par_cl == null) {
                throw new IllegalConfigurationException("Class " + name + " parent pool " + parent + " cannot be found.");
            }
            String children = par_cl.getStringProperty("children", null);
            children = children == null ? name : children + " " + name;
            par_cl.put("children", children);
        }
        for (String s : this.independentClasses) {
            this.propogateDown(s);
        }
        for (DuccProperties p : this.clmap.values()) {
            String policy = p.getStringProperty("policy", null);
            name = p.getProperty("name");
            if (policy == null) {
                throw new IllegalConfigurationException("Class " + name + " is missing scheduling policy ");
            }
            if (policy.equals("FAIR_SHARE")) {
                this.fairShareExists = true;
                this.handleDefault(p, this.fairShareDefault, policy);
                this.supplyDefaults(p, this.defaultFairShareClass);
                continue;
            }
            if (policy.equals("FIXED_SHARE")) {
                this.fixedExists = true;
                this.handleDefault(p, this.fixedDefault, policy);
                this.supplyDefaults(p, this.defaultFixedShareClass);
                continue;
            }
            if (policy.equals("RESERVE")) {
                this.reserveExists = true;
                this.handleDefault(p, this.reserveDefault, policy);
                this.supplyDefaults(p, this.defaultReserveClass);
                continue;
            }
            throw new IllegalConfigurationException("Unknown scheduling policy \"" + policy + "\" in class " + name);
        }
        Iterator<String> iter = this.clmap.keySet().iterator();
        while (iter.hasNext()) {
            String k = iter.next();
            DuccProperties p = this.clmap.get(k);
            if (!p.containsKey("abstract")) continue;
            iter.remove();
        }
    }

    void setShareQuantum() throws IllegalConfigurationException {
        for (DuccProperties props : this.independentNodepools) {
            String q = props.getProperty("share-quantum");
            if (q == null) {
                props.setProperty("share-quantum", "" + this.defaultQuantum);
                continue;
            }
            try {
                Integer.parseInt(q);
            }
            catch (NumberFormatException e) {
                throw new IllegalConfigurationException("Value for \"share-quantum\" in nodepool " + props.getProperty("name") + " is not a number.");
            }
        }
    }

    DuccProperties getTopLevel(DuccProperties child) {
        String parent = child.getStringProperty("parent", null);
        if (parent == null) {
            return child;
        }
        return this.getTopLevel(this.nodepools.get(parent));
    }

    void connectNodepools() throws IllegalConfigurationException {
        this.setShareQuantum();
        for (DuccProperties p : this.nodepools.values()) {
            String parent = p.getStringProperty("parent", null);
            String name = p.getStringProperty("name");
            if (parent == null) continue;
            if (p.getProperty("share-quantum") != null) {
                throw new IllegalConfigurationException("Nodepool " + name + ": \"share-quantum\" is legal only for top-level nodepools.");
            }
            DuccProperties tl = this.getTopLevel(p);
            p.setProperty("share-quantum", tl.getProperty("share-quantum"));
            DuccProperties par_pool = this.nodepools.get(parent);
            if (par_pool == null) {
                throw new IllegalConfigurationException("Nodepool " + name + " parent pool " + parent + " cannot be found.");
            }
            ArrayList<DuccProperties> children = (ArrayList<DuccProperties>)par_pool.get("children");
            if (children == null) {
                children = new ArrayList<DuccProperties>();
                par_pool.put("children", children);
            }
            children.add(p);
        }
        for (DuccProperties p : this.classes) {
            if (p.containsKey("abstract")) continue;
            String name = p.getStringProperty("name");
            String npname = p.getStringProperty("nodepool", null);
            if (npname == null) {
                throw new IllegalConfigurationException("Class " + name + " is not assigned to a nodepool.");
            }
            DuccProperties np = this.nodepools.get(npname);
            if (np == null) {
                throw new IllegalConfigurationException("Class " + name + " assigned to nodepool " + npname + " but nodepool does not exist.");
            }
            ArrayList<DuccProperties> class_set = (ArrayList<DuccProperties>)np.get("classes");
            if (class_set == null) {
                class_set = new ArrayList<DuccProperties>();
                np.put("classes", class_set);
            }
            class_set.add(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readNodepoolNodes(String nodefile, DuccProperties p, String domain) throws IllegalConfigurationException {
        String methodName = "readnodepoolFiles";
        HashMap<String, String> nodes = (HashMap<String, String>)p.get("nodes");
        if (nodes == null) {
            nodes = new HashMap<String, String>();
            p.put("nodes", nodes);
        }
        BufferedReader br = null;
        try {
            String tnodefile = this.resolve(nodefile);
            if (tnodefile == null) {
                throw new IllegalConfigurationException("File " + nodefile + " does not exist.");
            }
            nodefile = tnodefile;
            br = new BufferedReader(new FileReader(nodefile));
            String node = "";
            while ((node = br.readLine()) != null) {
                int ndx = node.indexOf("#");
                if (ndx >= 0) {
                    node = node.substring(0, ndx);
                }
                if ((node = node.trim()).equals("")) continue;
                if (node.startsWith("domain")) {
                    this.logInfo(methodName, "The \"domain\" keyword is no long supported in node files. Found in file " + nodefile);
                    continue;
                }
                if (node.startsWith("import")) {
                    String[] tmp = node.split("\\s+");
                    String importfile = tmp[1];
                    if (this.poolsByNodefile.containsKey(importfile)) continue;
                    this.readNodepoolNodes(importfile, p, domain);
                    continue;
                }
                if (this.allNodes.containsKey(node)) {
                    throw new IllegalConfigurationException("Duplicate node found in " + nodefile + ": " + node + "; first occurance in " + this.allNodes.get(node));
                }
                this.allNodes.put(node, nodefile);
                nodes.put(node, nodefile);
                this.poolsByNodeName.put(node, p);
                ndx = node.indexOf(".");
                String dnode = null;
                if (ndx >= 0) {
                    dnode = node.substring(0, ndx);
                    nodes.put(dnode, nodefile);
                } else if (domain != null) {
                    dnode = node + "." + domain;
                    nodes.put(dnode, nodefile);
                }
                if (dnode == null) continue;
                if (this.allNodes.containsKey(dnode)) {
                    throw new IllegalConfigurationException("Duplicate node found in " + nodefile + ": " + dnode + "; first occurance in " + this.allNodes.get(dnode));
                }
                this.allNodes.put(dnode, nodefile);
            }
        }
        catch (FileNotFoundException e) {
            throw new IllegalConfigurationException("Cannot open NodePool file \"" + nodefile + "\": file not found.");
        }
        catch (IOException e) {
            throw new IllegalConfigurationException("Cannot read NodePool file \"" + nodefile + "\": I/O Error.");
        }
        catch (IllegalConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    void checkForDuplicatePoolFiles() throws IllegalConfigurationException {
        for (DuccProperties dp : this.nodepools.values()) {
            String npfile = dp.getProperty("nodefile");
            if (this.poolsByNodefile.containsKey(npfile)) {
                throw new IllegalConfigurationException("Duplicate nodepool file reference to " + npfile + " from " + dp.getProperty("name") + " not allowed " + " first reference was from " + this.poolsByNodefile.get(npfile));
            }
            if (npfile == null) continue;
            this.poolsByNodefile.put(npfile, dp);
        }
    }

    void checkForMissingNodeFile() throws IllegalConfigurationException {
        ArrayList<String> missing = new ArrayList<String>();
        for (DuccProperties dp : this.nodepools.values()) {
            if (dp.containsKey("nodefile")) continue;
            missing.add(dp.getProperty("name"));
            if (this.ducc_nodes == null) continue;
            dp.setProperty("nodefile", this.ducc_nodes);
        }
        if (missing.size() > 1) {
            StringBuffer sb = new StringBuffer("Multiple nodepools with no associated node file, not allowed: ");
            for (String s : missing) {
                sb.append(" ");
                sb.append(s);
            }
            throw new IllegalConfigurationException(sb.toString());
        }
    }

    void checkForCycles() throws IllegalConfigurationException {
        HashMap<String, String> visited = new HashMap<String, String>();
        ArrayList<String> pools = new ArrayList<String>();
        for (DuccProperties dp : this.nodepools.values()) {
            visited.clear();
            pools.clear();
            DuccProperties current = dp;
            String currentName = current.getProperty("name");
            while (current != null) {
                if (visited.containsKey(currentName)) {
                    StringBuffer sb = new StringBuffer();
                    for (String s : pools) {
                        sb.append(s);
                        sb.append(" <-- ");
                    }
                    sb.append(currentName);
                    throw new IllegalConfigurationException("Nodepool cycle detected: " + sb.toString());
                }
                visited.put(currentName, currentName);
                pools.add(currentName);
                currentName = current.getProperty("parent");
                if (currentName != null) {
                    current = this.nodepools.get(currentName);
                    continue;
                }
                current = null;
            }
        }
    }

    void checkPriorities() throws IllegalConfigurationException {
        HashMap<String, String> policyMap = new HashMap<String, String>();
        for (DuccProperties p : this.classes) {
            String priority = p.getProperty("priority");
            String policy = p.getProperty("policy");
            String p4p = (String)policyMap.get(priority);
            if (p4p == null) {
                policyMap.put(priority, policy);
                continue;
            }
            if (p4p.equals(policy)) continue;
            throw new IllegalConfigurationException("Class " + p.getProperty("name") + " has the same priority (" + priority + ") as another but with a different scheduling policy (" + policy + ")");
        }
    }

    void verifyUserLimits() throws IllegalConfigurationException {
        for (String o : this.usermap.keySet()) {
            DuccProperties dp = this.usermap.get(o);
            for (Object l : dp.keySet()) {
                if (this.defaultUser.containsKey(l)) continue;
                String k = (String)l;
                String val = ((String)dp.get(k)).trim();
                if (k.indexOf(".") <= 0) {
                    throw new IllegalConfigurationException("User " + o + ": allotment incorrectly specified, cannot determine class. " + k + " = " + val);
                }
                String[] tmp = k.split("\\.");
                if (!this.clmap.containsKey(tmp[1])) {
                    throw new IllegalConfigurationException("User " + o + ": allotment incorrectly specified, class not defined. " + k + " = " + val);
                }
                try {
                    Integer.parseInt(val);
                }
                catch (NumberFormatException e) {
                    throw new IllegalConfigurationException("User " + o + ": allotment incorrectly specified, value not a number. " + k + " = " + val);
                }
            }
        }
    }

    void readNpNodes(String domain) throws IllegalConfigurationException {
        this.checkForMissingNodeFile();
        this.checkForDuplicatePoolFiles();
        for (String k : this.poolsByNodefile.keySet()) {
            this.readNodepoolNodes(k, this.poolsByNodefile.get(k), domain);
        }
    }

    public void fullValidation(String global_nodefile) throws IllegalConfigurationException {
    }

    public String getFirstNodepool() {
        return this.firstNodepool;
    }

    public DuccProperties getDefaultFairShareClass() {
        return this.fairShareDefault;
    }

    public DuccProperties getDefaultFixedClass() {
        return this.fixedDefault;
    }

    public DuccProperties getDefaultReserveClass() {
        return this.reserveDefault;
    }

    public DuccProperties getNodePoolForNode(String node) {
        DuccProperties retVal = null;
        if (node != null) {
            retVal = this.poolsByNodeName.get(node);
        }
        return retVal;
    }

    public String getNodePoolNameForNode(String node) {
        String retVal = null;
        if (node != null) {
            DuccProperties np = this.poolsByNodeName.get(node);
            String key = "name";
            if (np != null) {
                retVal = np.getProperty(key);
            }
        }
        return retVal;
    }

    public int getQuantumForNode(String node) {
        DuccProperties np = this.poolsByNodeName.get(node);
        if (np == null) {
            return this.defaultQuantum;
        }
        return Integer.parseInt(np.getProperty("share-quantum"));
    }

    public int getQuantumForClass(String classname) throws IllegalConfigurationException {
        DuccProperties props = this.clmap.get(classname);
        if (props == null) {
            throw new IllegalConfigurationException("Class " + classname + " is not configured.");
        }
        String npname = props.getProperty("nodepool");
        DuccProperties np = this.nodepools.get(npname);
        return Integer.parseInt(np.getProperty("share-quantum"));
    }

    public DuccProperties[] getToplevelNodepools() {
        return this.independentNodepools.toArray(new DuccProperties[this.independentNodepools.size()]);
    }

    public DuccProperties getClass(String name) {
        if (this.clmap == null) {
            return null;
        }
        return this.clmap.get(name);
    }

    public String getDefaultDomain() {
        return this.defaultDomain;
    }

    public Map<String, DuccProperties> getClasses() {
        return this.clmap;
    }

    public Map<String, DuccProperties> getUsers() {
        return this.usermap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readConfiguration() throws FileNotFoundException, IOException, IllegalConfigurationException {
        if (this.ducc_home == null) {
            throw new IllegalConfigurationException("DUCC_HOME must be defined as a system property.");
        }
        this.defaultDomain = this.getDomainName();
        this.defaultQuantum = SystemPropertyResolver.getIntProperty("ducc.rm.share.quantum", 15);
        try {
            String tconfig_file_name = this.resolve(this.config_file_name);
            if (tconfig_file_name == null) {
                throw new IllegalConfigurationException("File " + this.config_file_name + " does not exist.");
            }
            this.config_file_name = tconfig_file_name;
            this.in = new BufferedReader(new FileReader(this.config_file_name));
            this.parseStanzas();
            this.doClassInheritance();
            this.connectNodepools();
            this.readNpNodes(this.defaultDomain);
            this.checkForCycles();
            this.checkPriorities();
        }
        finally {
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (IOException tconfig_file_name) {}
            }
        }
        String msg = "";
        String sep = "";
        if (this.fairShareExists && this.fairShareDefault == null) {
            msg = "Definition for Default FAIR_SHARE is missing.";
            sep = "\n";
        }
        if (this.fixedExists && this.fixedDefault == null) {
            msg = msg + sep + "Definition for Default FIXED_SHARE class is missing.";
            sep = "\n";
        }
        if (this.reserveExists && this.reserveDefault == null) {
            msg = msg + sep + "Definition for Default RESERVE class is missing.";
        }
        if (!msg.equals("")) {
            throw new IllegalConfigurationException(msg);
        }
        try {
            this.ducc_users = this.resolve(this.ducc_users);
            if (this.ducc_users != null) {
                this.in = new BufferedReader(new FileReader(this.ducc_users));
                this.parseStanzas();
                this.verifyUserLimits();
            }
        }
        finally {
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    String formatNodes(Map<String, String> nodes, int indent) {
        int MAX_WIDTH = 100;
        int cur_width = indent;
        StringBuffer sb = new StringBuffer();
        String leader = String.format("%" + indent + "s", " ");
        if (nodes == null || nodes.size() == 0) {
            return leader + "<None>";
        }
        sb.append(leader);
        for (String s : nodes.keySet()) {
            if (s.indexOf(".") >= 0) continue;
            if (cur_width + s.length() + 1 > MAX_WIDTH) {
                sb.append("\n");
                sb.append(leader);
                cur_width = indent;
            }
            sb.append(s);
            sb.append(" ");
            cur_width += s.length() + 1;
        }
        return sb.toString();
    }

    void printNodepool(DuccProperties p, String indent) {
        String methodName = "printNodepool";
        this.logInfo(methodName, indent + "Nodepool " + p.getProperty("name"));
        this.logInfo(methodName, indent + "   Scheduling quantum: " + p.getProperty("share-quantum"));
        this.logInfo(methodName, indent + "   Search Order: " + p.getProperty("search-order"));
        String nodefile = p.getProperty("nodefile");
        String nfheader = "   Node File: ";
        this.logInfo(methodName, indent + nfheader + (nodefile == null ? "None" : nodefile));
        Map nodes = (Map)p.get("nodes");
        this.logInfo(methodName, this.formatNodes(nodes, indent.length() + nfheader.length()));
        List class_set = (List)p.get("classes");
        if (class_set == null) {
            this.logInfo(methodName, indent + "   No classes defined.");
        } else {
            StringBuffer buf = new StringBuffer();
            buf.append(indent + "   Classes:");
            for (DuccProperties cp : class_set) {
                buf.append(" " + cp.get("name"));
            }
            this.logInfo(methodName, buf.toString());
        }
        List children = (List)p.get("children");
        if (children == null) {
            this.logInfo(methodName, indent + "   No subpools.\n");
        } else {
            StringBuffer buf = new StringBuffer();
            buf.append(indent + "   Subpools:");
            for (DuccProperties cp : children) {
                buf.append(" " + cp.get("name"));
            }
            this.logInfo(methodName, buf.toString());
            for (DuccProperties cp : children) {
                this.printNodepool(cp, indent + indent);
            }
        }
    }

    void printProperty(String k, Object v) {
        String methodName = "printProperty";
        if (v == null) {
            return;
        }
        this.logInfo(methodName, String.format("   %-20s: %s", k, v));
    }

    void printDeprecatedProperty(String k, Object v, String msg) {
        String methodName = "printProperty";
        if (v == null) {
            return;
        }
        this.logInfo(methodName, String.format("   %-20s: Deprecated property - %s", k, msg));
    }

    void printClass(DuccProperties cl) {
        String methodName = "printClass";
        this.logInfo(methodName, "Class " + cl.get("name"));
        this.printProperty("Policy", cl.get("policy"));
        this.printProperty("Nodepool", cl.get("nodepool"));
        this.printProperty("Priority", cl.get("priority"));
        this.printProperty("Weight", cl.get("weight"));
        this.printProperty("Debug", cl.get("debug"));
        this.printProperty("Cap", cl.get("cap"));
        this.printProperty("Expand By Doubling", cl.get("expand-by-doubling"));
        this.printProperty("Initialization Cap", cl.get("initialization-cap"));
        this.printProperty("Use Prediction", cl.get("use-prediction"));
        this.printProperty("Prediction Fudge", cl.get("prediction-fudge"));
        this.printDeprecatedProperty("Max Processes", cl.get("max-processes"), "IGNORED Use max-allotment = [mem in GB] instead.");
        this.printDeprecatedProperty("Max Machines", cl.get("max-machines"), "IGNORED Use max-allotment = [mem in GB] instead.");
        this.printProperty("Max Allotment", cl.get("max-allotment"));
        this.printProperty("Enforce Memory Size", cl.get("enforce"));
        this.printProperty("Authorized Users", cl.get("users"));
        this.logInfo(methodName, "");
    }

    void printUser(DuccProperties cl) {
        String methodName = "printUser";
        this.logInfo(methodName, "User " + cl.get("name"));
        for (Object o : cl.keySet()) {
            String k = (String)o;
            if (!k.startsWith("max-allotment")) continue;
            this.printProperty(k, cl.get(k));
        }
        this.logInfo(methodName, "");
    }

    public void printConfiguration() {
        String methodName = "printConfiguration";
        if (this.independentNodepools == null || this.clmap == null) {
            this.logError(methodName, "Configuration has not been generated. (Run readConfiguration first.)");
        }
        for (DuccProperties p : this.independentNodepools) {
            this.printNodepool(p, "   ");
        }
        DuccProperties[] class_set = this.clmap.values().toArray(new DuccProperties[this.clmap.size()]);
        Arrays.sort(class_set, new ClassSorter());
        for (DuccProperties p : class_set) {
            this.printClass(p);
        }
        DuccProperties[] user_set = this.usermap.values().toArray(new DuccProperties[this.usermap.size()]);
        Arrays.sort(user_set, new UserSorter());
        for (DuccProperties p : user_set) {
            this.printUser(p);
        }
    }

    public void printNodepool(String nodepool) {
        String methodName = "printConfiguration";
        this.logInfo(methodName, nodepool);
    }

    static void usage(String msg) {
        if (msg != null) {
            System.out.println(msg);
            System.out.println("");
        }
        System.out.println("Usage:");
        System.out.println("    NodeConfiguration [-c class-definitions] [-n nodefile] [-u userfile] [-p] <configfile>");
        System.out.println("Where:");
        System.out.println("    -c <class-definitions> is the class definition file, defaults to ducc.classes.");
        System.out.println("    -n <nodefile> is nodefile used with the system, defaults to ducc.nodes");
        System.out.println("    -u <userfile> is the user registry.");
        System.out.println("    -m Prints the nodepool for the given node.");
        System.out.println("    -p Prints the parsed configuration, for verification.");
        System.out.println("    -? show this help.");
        System.out.println("");
        System.exit(1);
    }

    public static void main(String[] args) {
        boolean doprint = false;
        String nodefile = "ducc.nodes";
        String userfile = null;
        String config = "ducc.classes";
        String mapNodeToPool = null;
        int i = 0;
        for (i = 0; i < args.length; ++i) {
            if (args[i].equals("-p")) {
                doprint = true;
                continue;
            }
            if (args[i].equals("-n")) {
                nodefile = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equals("-u")) {
                userfile = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equals("-c")) {
                config = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equals("-m")) {
                mapNodeToPool = args[i + 1];
                ++i;
                continue;
            }
            if (!args[i].equals("-?")) continue;
            NodeConfiguration.usage(null);
        }
        if (config == null) {
            NodeConfiguration.usage("Class configuration file not specified.");
        }
        if (nodefile == null) {
            NodeConfiguration.usage("Nodefile not specified.");
        }
        NodeConfiguration nc = new NodeConfiguration(config, nodefile, userfile, null);
        int rc = 0;
        try {
            nc.readConfiguration();
            if (mapNodeToPool != null) {
                String nodepool = nc.getNodePoolNameForNode(mapNodeToPool);
                if (nodepool == null) {
                    nodepool = "";
                }
                nc.printNodepool(nodepool);
            }
            if (doprint) {
                nc.printConfiguration();
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("Configuration file " + config + " does not exist or cannot be read.");
            rc = 1;
        }
        catch (IOException e) {
            System.out.println("IOError reading configuration file " + config + ": " + e.toString());
            rc = 1;
        }
        catch (IllegalConfigurationException e) {
            System.out.println(e.getMessage());
            rc = 1;
        }
        System.exit(rc);
    }

    public static class UserSorter
    implements Comparator<DuccProperties> {
        @Override
        public int compare(DuccProperties u1, DuccProperties u2) {
            String n1 = u1.getProperty("name");
            String n2 = u2.getProperty("name");
            return n1.compareTo(n2);
        }
    }

    public static class ClassSorter
    implements Comparator<DuccProperties> {
        @Override
        public int compare(DuccProperties pr1, DuccProperties pr2) {
            String p2;
            if (pr1.equals(pr2)) {
                return 0;
            }
            String p1 = pr1.getProperty("policy");
            if (!p1.equals(p2 = pr2.getProperty("policy"))) {
                return p1.compareTo(p2);
            }
            String n1 = pr1.getProperty("name");
            String n2 = pr2.getProperty("name");
            return n1.compareTo(n2);
        }
    }
}

