/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.component;

import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.rmi.registry.LocateRegistry;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.activemq.camel.component.ActiveMQComponent;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.uima.ducc.common.admin.event.DuccAdminEvent;
import org.apache.uima.ducc.common.admin.event.DuccAdminEventKill;
import org.apache.uima.ducc.common.component.AbstractDuccComponentMBean;
import org.apache.uima.ducc.common.component.DuccComponent;
import org.apache.uima.ducc.common.crypto.Crypto;
import org.apache.uima.ducc.common.exception.DuccComponentInitializationException;
import org.apache.uima.ducc.common.exception.DuccConfigurationException;
import org.apache.uima.ducc.common.main.DuccService;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccProperties;
import org.apache.uima.ducc.common.utils.LinuxUtils;
import org.apache.uima.ducc.common.utils.Utils;

public abstract class AbstractDuccComponent
implements DuccComponent,
Thread.UncaughtExceptionHandler,
AbstractDuccComponentMBean {
    private CamelContext context;
    private final String componentName;
    private JMXConnectorServer jmxConnector = null;
    private String processJmxUrl = null;
    private volatile boolean stopping;
    private DuccService service;
    private Object monitor = new Object();
    private DuccLogger logger;

    public AbstractDuccComponent(String componentName) {
        this(componentName, null);
    }

    public AbstractDuccComponent(String componentName, CamelContext context) {
        this.componentName = componentName;
        this.setContext(context);
        this.logger = this.getLogger();
        if (this.logger == null) {
            System.out.println("Component '" + componentName + "' returned null logger; cannot boot.");
            System.exit(1);
        }
        DuccService.setDuccLogger(this.logger);
        this.logger.setAdditionalAppenders();
        this.logger.info("Component", null, "Starting Component " + componentName);
    }

    private void startAdminChannel(final String endpoint, final AbstractDuccComponent delegate) throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                AbstractDuccComponent.this.logger.info("configure", null, "Configuring Admin Channel on Endpoint:" + endpoint);
                this.onException(Exception.class).handled(true).process((Processor)new ErrorProcessor());
                this.from(endpoint).routeId("AdminRoute").unmarshal().xstream().process((Processor)new AdminEventProcessor(delegate));
            }
        });
        this.logger.info("startAdminChannel", null, "Admin Channel Activated on endpoint:" + endpoint);
    }

    public void loadProperties(String componentProperties) throws Exception {
        DuccProperties duccProperties = new DuccProperties();
        duccProperties.load(System.getProperty(componentProperties));
        this.enrichSystemPropertiesWith(duccProperties);
        this.composeBrokerUrl();
    }

    public void reloadProperties(String componentProperties) throws Exception {
        DuccProperties duccProperties = new DuccProperties();
        duccProperties.load(System.getProperty(componentProperties));
        Properties sysprops = System.getProperties();
        for (Map.Entry<Object, Object> entry : duccProperties.entrySet()) {
            String key = ((String)entry.getKey()).trim();
            sysprops.remove(key);
        }
        this.enrichSystemPropertiesWith(duccProperties);
        this.composeBrokerUrl();
    }

    private void enrichSystemPropertiesWith(DuccProperties duccProperties) throws Exception {
        Properties props = System.getProperties();
        for (Map.Entry<Object, Object> entry : duccProperties.entrySet()) {
            String key = ((String)entry.getKey()).trim();
            if (System.getProperties().containsKey(key)) continue;
            String value = (String)entry.getValue();
            value = Utils.resolvePlaceholderIfExists(value, duccProperties).trim();
            value = Utils.resolvePlaceholderIfExists(value, props).trim();
            if (key.endsWith(".endpoint")) {
                value = this.adjustTransportEndpoint(value, duccProperties.getProperty(key + ".type"));
            }
            System.setProperty(key, value);
        }
    }

    private void composeBrokerUrl() throws Exception {
        String duccBrokerHostname;
        String duccBrokerProtocol = System.getProperty("ducc.broker.protocol");
        if (duccBrokerProtocol == null) {
            throw new DuccConfigurationException("Ducc Configuration Exception. Please add ducc.broker.protocol property to ducc.propeties");
        }
        int pos = duccBrokerProtocol.indexOf(":");
        if (pos > -1) {
            duccBrokerProtocol = duccBrokerProtocol.substring(0, pos);
        }
        if ((duccBrokerHostname = System.getProperty("ducc.broker.hostname")) == null) {
            throw new DuccConfigurationException("Ducc Configuration Exception. Please add ducc.broker.hostname property to ducc.propeties");
        }
        String duccBrokerPort = System.getProperty("ducc.broker.port");
        if (duccBrokerPort == null) {
            throw new DuccConfigurationException("Ducc Configuration Exception. Please add ducc.broker.port property to ducc.propeties");
        }
        String duccBrokerUrlDecoration = System.getProperty("ducc.broker.url.decoration");
        if (duccBrokerUrlDecoration != null && duccBrokerUrlDecoration.startsWith("?")) {
            duccBrokerUrlDecoration = duccBrokerUrlDecoration.substring(1, duccBrokerUrlDecoration.length());
        }
        StringBuffer burl = new StringBuffer();
        burl.append(duccBrokerProtocol).append("://").append(duccBrokerHostname).append(":").append(duccBrokerPort);
        if (duccBrokerUrlDecoration != null && duccBrokerUrlDecoration.trim().length() > 0) {
            burl.append("?").append(duccBrokerUrlDecoration);
        }
        System.setProperty("ducc.broker.url", burl.toString());
    }

    public String adjustTransportEndpoint(String endpointValue, String endpointType) throws Exception {
        if (endpointType == null) {
            throw new DuccComponentInitializationException("Endpoint type not specified in component properties. Specify vm, queue, or topic type value for endpoint: " + endpointValue);
        }
        if (endpointType.equals("vm")) {
            endpointValue = "vm:" + endpointValue;
        } else if (endpointType.equals("topic") || endpointType.equals("queue")) {
            endpointValue = "activemq:" + endpointType + ":" + endpointValue;
        } else if (endpointType.equals("socket")) {
            endpointValue = "mina:tcp://localhost:";
        } else {
            throw new DuccComponentInitializationException("Provided Endpoint type is invalid:" + endpointType + ". Specify vm, queue, or topic type value for endpoint: " + endpointValue);
        }
        return endpointValue;
    }

    @Override
    public void setContext(CamelContext context) {
        this.context = context;
    }

    @Override
    public CamelContext getContext() {
        return this.context;
    }

    public boolean validateAdministrator(DuccAdminEvent event) {
        String methodName = "validate_user";
        String user = event.getUser();
        byte[] auth_block = event.getAuthBlock();
        try {
            String userHome = null;
            userHome = LinuxUtils.getUserHome(user);
            Crypto crypto = new Crypto(user, userHome, Crypto.AccessType.READER);
            String signature = (String)crypto.decrypt(auth_block);
            if (!user.equals(signature)) {
                return false;
            }
        }
        catch (Throwable t) {
            this.logger.error(methodName, null, "Crypto failure:", t.toString());
            return false;
        }
        if (!user.equals(System.getProperty("user.name"))) {
            this.logger.warn(methodName, null, user, "is not DUCC process owner.");
            return false;
        }
        return true;
    }

    public void onDuccAdminKillEvent(DuccAdminEvent event) throws Exception {
        String methodName = "onDuccAdminKillEvent";
        this.logger.info("onDuccAdminKillEvent", null, "\n\tDucc Process:" + this.componentName);
        if (!this.validateAdministrator(event)) {
            this.logger.info(methodName, null, "Failed authentication/authorization Ignoring shutdown event.");
            return;
        }
        this.logger.info(methodName, null, "Received Kill Event - Cleaning Up and Stopping");
        this.stop();
        System.exit(2);
    }

    @Override
    public void start(DuccService service) throws Exception {
        this.start(service, null);
    }

    public void start(DuccService service, String[] args) throws Exception {
        String endpoint = null;
        this.service = service;
        if (!(System.getProperty("ducc.deploy.components") == null || System.getProperty("ducc.deploy.components").equals("uima-as") || System.getProperty("ducc.deploy.components").equals("job-process") || System.getProperty("ducc.deploy.components").equals("service") || System.getProperty("ducc.deploy.components").equals("jd") || (endpoint = System.getProperty("ducc.admin.endpoint")) == null)) {
            this.logger.info("start", null, ".....Starting Admin Channel on endpoint:" + endpoint);
            this.startAdminChannel(endpoint, this);
            this.logger.info("start", null, "Admin Channel started on endpoint:" + endpoint);
        }
        this.logger.info("start", null, ".....Starting Camel Context");
        this.context.start();
        List routes = this.context.getRoutes();
        for (Route route : routes) {
            this.context.startRoute(route.getId());
            this.logger.info("start", null, "---OR Route in Camel Context-" + route.getEndpoint().getEndpointUri() + " Route State:" + this.context.getRouteStatus(route.getId()));
        }
        this.logger.info("start", null, "..... Camel Initialized and Started");
        this.logger.info("start", null, "..... Starting JMX Agent");
        this.processJmxUrl = this.startJmxAgent();
        if (this.processJmxUrl != null && this.processJmxUrl.trim().length() > 0) {
            this.logger.info("start", null, "..... JMX Agent Ready");
            this.logger.info("start", null, "Connect jConsole to this process using JMX URL:" + this.processJmxUrl);
        }
        System.getProperties().setProperty("ducc.jmx.url", this.processJmxUrl);
        if (!System.getProperty("ducc.deploy.components").equals("uima-as") && !System.getProperty("ducc.deploy.components").equals("jd")) {
            ServiceShutdownHook shutdownHook = new ServiceShutdownHook(this, this.logger);
            Runtime.getRuntime().addShutdownHook(shutdownHook);
        }
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        ObjectName name = new ObjectName("org.apache.uima.ducc.service.admin.jmx:type=DuccComponentMBean,name=" + this.getClass().getSimpleName());
        mbs.registerMBean(this, name);
    }

    protected String getProcessJmxUrl() {
        return this.processJmxUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws Exception {
        Object name;
        String methodName = "stop";
        Object object = this.monitor;
        synchronized (object) {
            if (this.stopping) {
                return;
            }
            this.stopping = true;
        }
        this.logger.info(methodName, null, "----------stop() called");
        try {
            this.logger.info(methodName, null, "Stopping Camel Routes");
            List routes = this.context.getRoutes();
            for (Route route : routes) {
                if (route.getId().startsWith("mina")) continue;
                this.logger.info(methodName, null, "Stopping Route:" + route.getId());
                route.getConsumer().stop();
                route.getEndpoint().stop();
            }
            ActiveMQComponent amqc = (ActiveMQComponent)this.context.getComponent("activemq");
            amqc.stop();
            amqc.shutdown();
            name = new ObjectName("org.apache.uima.ducc.service.admin.jmx:type=DuccComponentMBean,name=" + this.getClass().getSimpleName());
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            Set<ObjectInstance> set = mbs.queryMBeans((ObjectName)name, null);
            if (set.size() > 0) {
                mbs.unregisterMBean((ObjectName)name);
            }
            if (this.jmxConnector != null) {
                this.jmxConnector.stop();
            }
            if (this.service != null) {
                this.service.stop();
            }
            this.logger.info(methodName, null, "Component cleanup completed - terminating process");
        }
        catch (Exception e) {
            System.out.println("----------------------------------------------------------------------------------------------------");
            e.printStackTrace();
            System.out.println("----------------------------------------------------------------------------------------------------");
            this.logger.error(methodName, null, e, new Object[0]);
        }
        long waitTime = 0L;
        if (System.getProperty("WaitTime") != null) {
            try {
                name = this;
                synchronized (name) {
                    waitTime = Long.valueOf(System.getProperty("WaitTime"));
                    if (waitTime > 0L) {
                        this.wait(waitTime);
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    @Override
    public void handleUncaughtException(Exception e) {
        e.printStackTrace();
    }

    public void handleUncaughtException(Error e) {
        e.printStackTrace();
        System.out.println("Unexpected Java Error - Terminating Process via Runtime halt");
        Runtime.getRuntime().halt(2);
    }

    public String startJmxAgent() throws Exception {
        int rmiRegistryPort = 2099;
        if (System.getProperty("ducc.jmx.port") != null) {
            try {
                int tmp;
                rmiRegistryPort = tmp = Integer.valueOf(System.getProperty("ducc.jmx.port")).intValue();
            }
            catch (NumberFormatException nfe) {
                nfe.printStackTrace();
            }
        }
        boolean done = false;
        JMXServiceURL url = null;
        while (!done) {
            try {
                LocateRegistry.createRegistry(rmiRegistryPort);
                done = true;
            }
            catch (Exception exx) {
                ++rmiRegistryPort;
            }
        }
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            String hostname = InetAddress.getLocalHost().getHostName();
            String s = String.format("service:jmx:rmi:///jndi/rmi://%s:%d/jmxrmi", hostname, rmiRegistryPort);
            url = new JMXServiceURL(s);
            this.jmxConnector = JMXConnectorServerFactory.newJMXConnectorServer(url, null, mbs);
            this.jmxConnector.start();
        }
        catch (Exception e) {
            url = null;
            this.logger.error("startJmxAgent", null, "Unable to Start JMX Connector. Running with *No* JMX Connectivity");
        }
        if (url == null) {
            return "";
        }
        return url.toString();
    }

    @Override
    public void cleanup(Throwable e) {
        e.printStackTrace();
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        e.printStackTrace();
        System.exit(1);
    }

    @Override
    public void handleAdminEvent(DuccAdminEvent event) throws Exception {
    }

    @Override
    public void setLogLevel(String clz, String level) {
        this.service.setLogLevel(clz, level);
    }

    @Override
    public void setLogLevel(String level) {
        this.service.setLogLevel(this.getClass().getCanonicalName(), level);
    }

    public String getLogLevel() {
        return this.service.getLogLevel(this.getClass().getCanonicalName());
    }

    public boolean isStopping() {
        return this.stopping;
    }

    static class KillerThreadTask
    extends TimerTask {
        DuccLogger logger;

        public KillerThreadTask(DuccLogger logger) {
            this.logger = logger;
        }

        @Override
        public void run() {
            try {
                this.logger.info("start", null, "Process is about to kill itself via Runtime.getRuntime().halt()");
                Runtime.getRuntime().halt(-1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static class ServiceShutdownHook
    extends Thread {
        private AbstractDuccComponent duccProcess;
        private DuccLogger logger;

        public ServiceShutdownHook(AbstractDuccComponent service, DuccLogger logger) {
            this.duccProcess = service;
            this.logger = logger;
        }

        @Override
        public void run() {
            try {
                this.logger.info("start", null, "DUCC Service Caught Kill Signal - Registering Killer Task and Stopping ...");
                Timer killTimer = new Timer();
                killTimer.schedule((TimerTask)new KillerThreadTask(this.logger), 60000L);
                this.duccProcess.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public class AdminEventProcessor
    implements Processor {
        final AbstractDuccComponent delegate;

        public AdminEventProcessor(AbstractDuccComponent delegate) {
            this.delegate = delegate;
        }

        public void process(final Exchange exchange) throws Exception {
            AbstractDuccComponent.this.logger.info("AdminEventProcessor.process()", null, "Received Admin Message of Type:" + exchange.getIn().getBody().getClass().getName());
            if (exchange.getIn().getBody() instanceof DuccAdminEventKill) {
                Thread th = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            AdminEventProcessor.this.delegate.onDuccAdminKillEvent((DuccAdminEventKill)exchange.getIn().getBody());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
                th.start();
            } else {
                AbstractDuccComponent.this.handleAdminEvent((DuccAdminEvent)exchange.getIn().getBody());
            }
        }
    }

    public class ErrorProcessor
    implements Processor {
        public void process(Exchange exchange) throws Exception {
            Throwable caused = (Throwable)exchange.getProperty("CamelExceptionCaught", Throwable.class);
            caused.printStackTrace();
            AbstractDuccComponent.this.logger.error("ErrorProcessor.process()", null, caused, new Object[0]);
        }
    }
}

