/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common;

import java.util.HashMap;
import java.util.Map;
import org.apache.uima.ducc.common.Node;

public abstract class ANodeStability
implements Runnable {
    private HashMap<Node, Integer> heartbeats = new HashMap();
    private int nodeStability;
    private int agentMetricsRate;
    private boolean shutdown = false;
    private Thread watchThread;

    public ANodeStability(int nodeStability, int agentMetricsRate) {
        this.nodeStability = nodeStability;
        this.agentMetricsRate = agentMetricsRate;
    }

    public void start() {
        this.watchThread = new Thread(this);
        this.watchThread.setDaemon(true);
        this.watchThread.start();
    }

    public abstract void nodeDeath(Map<Node, Node> var1);

    public synchronized void nodeArrives(Node n) {
        this.heartbeats.put(n, 0);
    }

    public abstract void missedNode(Node var1, int var2);

    public synchronized void shutdown() {
        this.shutdown = true;
        this.watchThread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        HashMap<Node, Node> deadNodes = new HashMap<Node, Node>();
        while (true) {
            ANodeStability aNodeStability = this;
            synchronized (aNodeStability) {
                if (this.shutdown) {
                    return;
                }
                for (Node n : this.heartbeats.keySet()) {
                    int c = this.heartbeats.get(n);
                    if (++c >= this.nodeStability) {
                        deadNodes.put(n, n);
                    }
                    if (c > 1) {
                        this.missedNode(n, c);
                    }
                    this.heartbeats.put(n, c);
                }
            }
            if (deadNodes.size() > 0) {
                this.nodeDeath(deadNodes);
                for (Node n : deadNodes.keySet()) {
                    this.heartbeats.remove(n);
                }
                deadNodes.clear();
            }
            try {
                Thread.sleep(this.agentMetricsRate);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }
}

