/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.utils;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.uima.ducc.common.utils.AlienAbstract;
import org.apache.uima.ducc.common.utils.AlienFile;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccLoggerComponents;

public class AlienDirectory
extends AlienAbstract {
    private static DuccLogger duccLogger = DuccLoggerComponents.getWsLogger(AlienFile.class.getName());
    private String command_ls = "/bin/ls";
    private String command_ls_flags = "-atl";
    private String directory_name;

    protected void set_command_ls(String value) {
        this.command_ls = value;
    }

    protected String get_command_ls() {
        return this.command_ls;
    }

    protected void set_command_ls_flags(String value) {
        this.command_ls_flags = value;
    }

    protected String get_command_ls_flags() {
        return this.command_ls_flags;
    }

    protected void set_directory_name(String value) {
        this.directory_name = value;
    }

    protected String get_directory_name() {
        return this.directory_name;
    }

    public AlienDirectory(String user, String directory_name, String ducc_ling) {
        this.set_user(user);
        this.set_directory_name(directory_name);
        this.set_ducc_ling(ducc_ling);
    }

    private String[] getCommand() {
        String[] command_ducc_ling_yes = new String[]{this.ducc_ling, this.q_parameter, this.u_parameter, this.user, this.command_ls, this.command_ls_flags, this.directory_name};
        String[] command_ducc_ling_no = new String[]{this.command_ls, this.command_ls_flags, this.directory_name};
        String[] command = command_ducc_ling_yes;
        if (this.ducc_ling == null) {
            command = command_ducc_ling_no;
        }
        return command;
    }

    private String reader() throws Throwable {
        String string;
        String data = null;
        BufferedReader br = null;
        InputStreamReader isr = null;
        try {
            String line;
            String[] command = this.getCommand();
            this.echo(command);
            ProcessBuilder pb = new ProcessBuilder(command);
            Process p = pb.start();
            InputStream pOut = p.getInputStream();
            isr = new InputStreamReader(pOut);
            br = new BufferedReader(isr);
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            while ((line = br.readLine()) != null) {
                if (first) {
                    first = false;
                    continue;
                }
                sb.append(line);
                sb.append("\n");
            }
            string = data = sb.toString();
        }
        catch (Throwable t) {
            try {
                t.printStackTrace();
                throw t;
            }
            catch (Throwable throwable) {
                this.closer(br);
                this.closer(isr);
                throw throwable;
            }
        }
        this.closer(br);
        this.closer(isr);
        return string;
    }

    public String getString() throws Throwable {
        String methodName = "getString";
        String data = this.reader();
        duccLogger.debug(methodName, this.duccId, data);
        return data;
    }

    public InputStreamReader getInputStreamReader() throws Throwable {
        InputStreamReader isr = null;
        String[] command = this.getCommand();
        this.echo(command);
        ProcessBuilder pb = new ProcessBuilder(command);
        Process p = pb.start();
        InputStream pOut = p.getInputStream();
        isr = new InputStreamReader(pOut);
        return isr;
    }

    public DataInputStream getDataInputStream() throws Throwable {
        DataInputStream dis = null;
        String[] command = this.getCommand();
        this.echo(command);
        ProcessBuilder pb = new ProcessBuilder(command);
        Process p = pb.start();
        InputStream pOut = p.getInputStream();
        dis = new DataInputStream(pOut);
        return dis;
    }

    public static void main(String[] args) throws Throwable {
        AlienDirectory alienDirectory;
        String arg_user = args[0];
        String arg_directory = args[1];
        if (args.length < 3) {
            alienDirectory = new AlienDirectory(arg_user, arg_directory, null);
        } else {
            String arg_ducc_ling = args[2];
            alienDirectory = new AlienDirectory(arg_user, arg_directory, arg_ducc_ling);
        }
        String data = alienDirectory.getString();
        System.out.println(data);
    }
}

