/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.main;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.main.Main;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.uima.ducc.common.NodeIdentity;
import org.apache.uima.ducc.common.component.AbstractDuccComponent;
import org.apache.uima.ducc.common.exception.DuccComponentInitializationException;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.Utils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class DuccService
extends AbstractDuccComponent {
    public static final String DUCC_PROPERTY_FILE = "ducc.deploy.configuration";
    public static final String DUCC_DEPLOY_COMPONENTS = "ducc.deploy.components";
    private Main main;
    private static DuccLogger globalLogger = null;
    private ApplicationContext context;
    Map<String, AbstractDuccComponent> duccComponents = null;

    public DuccService() {
        super("");
        Thread.currentThread().setUncaughtExceptionHandler(this);
    }

    public static DuccLogger getDuccLogger() {
        return globalLogger;
    }

    public static DuccLogger getDuccLogger(String claz) {
        return globalLogger.getLoggerFor(claz);
    }

    public static DuccLogger getDuccLogger(Class claz) {
        return DuccService.getDuccLogger(claz.getName());
    }

    public static void setDuccLogger(DuccLogger l) {
        globalLogger = l;
    }

    @Override
    public DuccLogger getLogger() {
        if (DuccService.getDuccLogger() == null) {
            return new DuccLogger(DuccService.class);
        }
        return DuccService.getDuccLogger();
    }

    private void exitIfInvalid(String componentName, String classToVerify, String reason) {
        if (classToVerify == null || classToVerify.trim().length() == 0) {
            System.out.println("Unable to start Component: " + componentName + ". Missing " + reason + ".\nUsage: java -DServiceConfigurationClass=<Configuration.class> ...");
            System.exit(-1);
        }
    }

    private Class<?>[] getComponentsToLoad() throws Exception {
        String[] componentsToLoad = System.getProperty(DUCC_DEPLOY_COMPONENTS).split(",");
        if (componentsToLoad == null || componentsToLoad.length == 0) {
            throw new DuccComponentInitializationException("Ducc Component not specified. Provide Ducc Component(s) to Load via -Dducc.deploy.components System property");
        }
        ArrayList components = new ArrayList();
        for (String componentToLoad : componentsToLoad) {
            String configurationClassName = System.getProperty("ducc." + componentToLoad + ".configuration.class");
            this.exitIfInvalid(componentToLoad, configurationClassName, "Configuration Class Name");
            components.add(Class.forName(configurationClassName));
        }
        Class[] configClasses = new Class[components.size()];
        components.toArray(configClasses);
        return configClasses;
    }

    public void boot(String[] args) throws Exception {
        String methodName = "boot";
        this.main = new Main();
        this.main.enableHangupSupport();
        this.loadProperties(DUCC_PROPERTY_FILE);
        System.out.println(System.getProperties());
        Class[] configClasses = this.getComponentsToLoad();
        this.context = new AnnotationConfigApplicationContext(configClasses);
        this.duccComponents = this.context.getBeansOfType(AbstractDuccComponent.class);
        for (Map.Entry<String, AbstractDuccComponent> duccComponent : this.duccComponents.entrySet()) {
            DuccService.getDuccLogger().info(methodName, null, "... Starting Component: ", duccComponent.getKey());
            if (args != null && args.length > 0) {
                duccComponent.getValue().start(this, args);
            } else {
                duccComponent.getValue().start(this);
            }
            DuccService.getDuccLogger().info(methodName, null, "... Component started: ", duccComponent.getKey());
        }
        DuccService.getDuccLogger().info(methodName, null, "Starting Camel. Use ctrl + c to terminate the JVM.\n");
        this.main.run();
    }

    public AbstractDuccComponent getComponentInstance(String componentKey) {
        Map duccComponents = this.context.getBeansOfType(AbstractDuccComponent.class);
        for (Map.Entry duccComponent : duccComponents.entrySet()) {
            if (!componentKey.equals(duccComponent.getKey())) continue;
            return (AbstractDuccComponent)duccComponent.getValue();
        }
        return null;
    }

    @Override
    public void stop() throws Exception {
        if (this.main.isStarted()) {
            List ctxList = this.main.getCamelContexts();
            for (CamelContext ctx : ctxList) {
                ctx.stop();
            }
            this.main.stop();
            DuccService.getDuccLogger().shutdown();
        }
    }

    public static void main(String[] args) {
        DuccService duccService = null;
        try {
            if (Utils.findDuccHome() == null) {
                System.out.println("Unable to Launch Ducc Service - DUCC_HOME not defined. Add it to your environment or provide it with -DDUCC_HOME=<path>");
                System.exit(-1);
            }
            if (System.getenv("IP") == null) {
                NodeIdentity ni = new NodeIdentity();
                System.setProperty("IP", ni.getIp());
                System.setProperty("NodeName", ni.getName());
            } else {
                System.setProperty("IP", System.getenv("IP"));
                System.setProperty("NodeName", System.getenv("NodeName"));
            }
            duccService = new DuccService();
            duccService.boot(args);
        }
        catch (DuccComponentInitializationException e) {
            e.printStackTrace();
            if (duccService != null) {
                try {
                    duccService.stop();
                }
                catch (Exception stopException) {
                    stopException.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setLogLevel(String clz, String level) {
        Enumeration loggers = LogManager.getCurrentLoggers();
        while (loggers.hasMoreElements()) {
            Logger logger = (Logger)loggers.nextElement();
            if (!logger.getName().equals(clz)) continue;
            logger.setLevel(Level.toLevel((String)level));
            System.out.println("---------Set New Log Level:" + level + " For Logger:" + clz);
        }
    }

    public String getLogLevel(String clz) {
        Enumeration loggers = LogManager.getCurrentLoggers();
        while (loggers.hasMoreElements()) {
            Logger logger = (Logger)loggers.nextElement();
            if (!logger.getName().equals(clz)) continue;
            if (logger.getLevel() == null) {
                logger.setLevel(Level.toLevel((String)"info"));
                continue;
            }
            return logger.getLevel().toString();
        }
        return "";
    }
}

