/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.jd.files.workitem;

import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.GZIPOutputStream;
import org.apache.uima.ducc.common.jd.files.IWorkItemState;
import org.apache.uima.ducc.common.jd.files.WorkItemState;
import org.apache.uima.ducc.common.jd.files.workitem.ActiveMap;
import org.apache.uima.ducc.common.jd.files.workitem.RemoteLocation;
import org.apache.uima.ducc.common.jd.files.workitem.WorkItemStateAbstract;
import org.apache.uima.ducc.common.jd.files.workitem.WorkItemStatistics;
import org.apache.uima.ducc.common.utils.DuccLogger;

public class WorkItemStateKeeper
extends WorkItemStateAbstract {
    private DuccLogger logger = DuccLogger.getLogger(WorkItemStateKeeper.class, null);

    public WorkItemStateKeeper(String component, String directory) {
        this.logger = DuccLogger.getLogger(WorkItemStateKeeper.class, component);
        this.activeMap = new ActiveMap(component);
        this.initialize(directory);
    }

    public ConcurrentHashMap<RemoteLocation, Long> getOperatingMillisMap() {
        DuccLogger logger = null;
        return this.getOperatingMillisMap(logger);
    }

    public ConcurrentHashMap<RemoteLocation, Long> getOperatingMillisMap(DuccLogger logger) {
        String pid;
        String location = "getOperatingMillisMap";
        ConcurrentHashMap<RemoteLocation, Long> map = new ConcurrentHashMap<RemoteLocation, Long>();
        if (logger != null) {
            logger.trace(location, jobid, "size: " + this.activeMap.size());
        }
        for (Map.Entry<Long, IWorkItemState> entry : this.activeMap.entrySet()) {
            IWorkItemState wis = entry.getValue();
            IWorkItemState.State state = wis.getState();
            pid = wis.getPid();
            String node = wis.getNode();
            switch (state) {
                case operating: {
                    RemoteLocation key = new RemoteLocation(node, pid);
                    if (key == null) break;
                    Long value = new Long(wis.getMillisProcessing());
                    if (logger != null) {
                        logger.trace(location, jobid, "node: " + node + " " + "pid: " + pid + " " + "time: " + value);
                    }
                    if (map.contains(key)) {
                        value = value + map.get(key);
                    }
                    map.put(key, value);
                }
            }
        }
        if (logger != null) {
            for (Map.Entry<Long, IWorkItemState> entry : map.entrySet()) {
                RemoteLocation key = (RemoteLocation)((Object)entry.getKey());
                String nodeIP = key.getNodeIP();
                pid = key.getPid();
                Long time = map.get(key);
                logger.trace(location, jobid, "nodeIP: " + nodeIP + " " + "pid: " + pid + " " + "time: " + time);
            }
        }
        return map;
    }

    public synchronized void zip() {
        String location = "zip";
        try {
            for (Map.Entry<Long, IWorkItemState> entry : this.activeMap.entrySet()) {
                IWorkItemState wis = entry.getValue();
                this.recordFinal(wis);
                this.updateStatistics(wis);
            }
            this.deleteActive();
            this.deleteZip();
            this.transform();
            this.deleteJson();
        }
        catch (Exception e) {
            this.logger.error(location, jobid, e, new Object[0]);
        }
    }

    public void start(int seqNo, String wiId) {
        WorkItemState wis = new WorkItemState(seqNo);
        Long key = new Long(seqNo);
        this.activeMap.put(key, wis);
        wis.setWiId(wiId);
        wis.stateStart();
        this.record(wis);
    }

    public void queued(String seqNo) {
        Long key = new Long(seqNo);
        this.queued(key.intValue());
    }

    public void queued(int seqNo) {
        Long key = new Long(seqNo);
        IWorkItemState wis = this.activeMap.get(key);
        wis.stateQueued();
        this.record(wis);
    }

    public void operating(String seqNo) {
        Long key = new Long(seqNo);
        this.operating(key.intValue());
    }

    public void operating(int seqNo) {
        Long key = new Long(seqNo);
        IWorkItemState wis = this.activeMap.get(key);
        wis.stateOperating();
        this.record(wis);
    }

    public void ended(int seqNo) {
        Long key = new Long(seqNo);
        IWorkItemState wis = this.activeMap.get(key);
        wis.stateEnded();
        this.record(wis);
    }

    public void error(int seqNo) {
        Long key = new Long(seqNo);
        IWorkItemState wis = this.activeMap.get(key);
        wis.stateError();
        this.record(wis);
    }

    public void lost(int seqNo) {
        Long key = new Long(seqNo);
        IWorkItemState wis = this.activeMap.get(key);
        wis.stateLost();
        this.record(wis);
    }

    public void retry(int seqNo) {
        Long key = new Long(seqNo);
        IWorkItemState wis = this.activeMap.get(key);
        wis.stateRetry();
        this.record(wis);
    }

    public void location(String seqNo, String node, String pid) {
        Long key = new Long(seqNo);
        this.location(key.intValue(), node, pid);
    }

    public void location(int seqNo, String node, String pid) {
        Long key = new Long(seqNo);
        IWorkItemState wis = this.activeMap.get(key);
        wis.setNode(node);
        wis.setPid(pid);
        this.record(wis);
    }

    private synchronized void record(IWorkItemState wis) {
        String location = "record";
        try {
            IWorkItemState.State state = wis.getState();
            String seqNo = wis.getSeqNo();
            Long key = Long.valueOf(seqNo);
            this.logger.info(location, jobid, "seqNo:" + seqNo + " " + state.name());
            switch (state) {
                case ended: 
                case error: {
                    this.activeMap.remove(key);
                    this.recordFinal(wis);
                    this.updateStatistics(wis);
                    break;
                }
                default: {
                    this.activeMap.put(key, wis);
                }
            }
            this.recordActive();
        }
        catch (Exception e) {
            this.logger.error(location, jobid, e, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transform() throws IOException {
        String location = "transform";
        FileInputStream fis = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        String line = null;
        File fileOut = null;
        FileOutputStream fos = null;
        GZIPOutputStream gos = null;
        OutputStreamWriter osw = null;
        JsonWriter jw = null;
        try {
            String targetFileIn = this.fnJson;
            String targetFileOut = this.fnJsonGz;
            fis = new FileInputStream(targetFileIn);
            isr = new InputStreamReader(fis);
            br = new BufferedReader(isr);
            fileOut = new File(targetFileOut);
            fos = new FileOutputStream(fileOut);
            gos = new GZIPOutputStream(fos);
            osw = new OutputStreamWriter((OutputStream)gos, "UTF-8");
            jw = new JsonWriter((Writer)osw);
            jw.setIndent("  ");
            jw.beginArray();
            Type type = new TypeToken<WorkItemState>(){}.getType();
            line = br.readLine();
            while (line != null) {
                this.logger.trace(location, jobid, line);
                StringReader sr = new StringReader(line.trim());
                WorkItemState wis = (WorkItemState)gson.fromJson((Reader)sr, type);
                gson.toJson((Object)wis, WorkItemState.class, jw);
                line = br.readLine();
            }
            jw.endArray();
        }
        catch (Exception e) {
            this.logger.error(location, jobid, e, new Object[0]);
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (jw != null) {
                jw.close();
            }
        }
    }

    private void deleteZip() {
        String targetFile = this.fnJsonGz;
        File file = new File(targetFile);
        file.delete();
    }

    private void deleteActive() {
        String targetFile = this.fnActiveJson;
        File file = new File(targetFile);
        file.delete();
    }

    private void deleteJson() {
        String targetFile = this.fnJson;
        File file = new File(targetFile);
        file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordActive() throws IOException {
        OutputStreamWriter fw = null;
        String targetFile = this.fnActiveJson;
        try {
            this.deleteActive();
            fw = new FileWriter(targetFile, !append);
            for (Map.Entry<Long, IWorkItemState> entry : this.activeMap.entrySet()) {
                IWorkItemState wis = entry.getValue();
                String json = gson.toJson((Object)wis) + linend;
                fw.write(json);
            }
        }
        finally {
            if (fw != null) {
                fw.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordFinal(IWorkItemState wis) throws IOException {
        FileWriter fw = null;
        String targetFile = this.fnJson;
        try {
            fw = new FileWriter(targetFile, append);
            String json = gson.toJson((Object)wis) + linend;
            fw.write(json);
        }
        finally {
            if (fw != null) {
                fw.close();
            }
        }
    }

    public WorkItemStatistics getStatistics() {
        this.stats.millisOperatingLeast = this.activeMap.getOperatingLeast();
        return this.stats;
    }

    private void updateStatistics(IWorkItemState wis) throws IOException {
        long wiMillis = wis.getMillisProcessing();
        if (this.stats.count > 0L) {
            if (wiMillis > this.stats.millisMax) {
                this.stats.millisMax = wiMillis;
            }
            if (wiMillis < this.stats.millisMin) {
                this.stats.millisMin = wiMillis;
            }
            long total = this.stats.count * this.stats.millisAvg + wiMillis;
            long count = this.stats.count + 1L;
            long avg = (long)(1.0 * (double)total / (double)count);
            this.stats.count = count;
            this.stats.millisAvg = avg;
            switch (wis.getState()) {
                case ended: 
                case error: {
                    if (wiMillis <= this.stats.millisCompletedMost) break;
                    this.stats.millisCompletedMost = wiMillis;
                    break;
                }
            }
        } else {
            this.stats.millisMax = wiMillis;
            this.stats.millisMin = wiMillis;
            this.stats.millisAvg = wiMillis;
            this.stats.count = 1L;
            switch (wis.getState()) {
                case ended: 
                case error: {
                    this.stats.millisCompletedMost = wiMillis;
                    break;
                }
                default: {
                    this.stats.millisCompletedMost = 0L;
                }
            }
        }
    }
}

