/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.authentication;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.apache.uima.ducc.common.utils.DuccLogger;

public class BrokerCredentials {
    public static Credentials get(String brokerCredentialsFile) throws FileNotFoundException {
        Credentials cr = new Credentials();
        Properties properties = new Properties();
        if (brokerCredentialsFile != null) {
            try {
                if (!new File(brokerCredentialsFile).canRead()) {
                    DuccLogger logger = DuccLogger.getLogger(BrokerCredentials.class.getName(), null);
                    logger.info("BrokerCredentials.get", null, "Cannot access broker credentials file so will have restricted access");
                    return cr;
                }
                properties.load(new FileInputStream(brokerCredentialsFile));
                cr.setUsername(properties.getProperty("ducc.broker.admin.username"));
                cr.setPassword(properties.getProperty("ducc.broker.admin.password"));
                return cr;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        throw new FileNotFoundException();
    }

    public static class Credentials {
        String username;
        String password;

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }
    }
}

