/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.agent.metrics.swap;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.apache.uima.ducc.common.agent.metrics.swap.ProcessSwapSpaceUsage;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.Utils;

public class DuccProcessSwapSpaceUsage
implements ProcessSwapSpaceUsage {
    String pid = null;
    String execScript = null;
    DuccLogger logger = null;
    String[] command;

    public DuccProcessSwapSpaceUsage(String pid, String owner, String execScript, DuccLogger logger) {
        this.pid = pid;
        this.execScript = execScript;
        this.logger = logger;
        String c_launcher_path = Utils.resolvePlaceholderIfExists(System.getProperty("ducc.agent.launcher.ducc_spawn_path"), System.getProperties());
        this.command = new String[]{c_launcher_path, "-u", owner, "--", execScript, pid};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getSwapUsage() {
        long swapusage = 0L;
        if (this.pid != null && this.execScript != null) {
            InputStreamReader in = null;
            try {
                ProcessBuilder pb = new ProcessBuilder(new String[0]);
                pb.command(this.command);
                pb.redirectErrorStream(true);
                Process swapCollectorProcess = pb.start();
                in = new InputStreamReader(swapCollectorProcess.getInputStream());
                BufferedReader reader = new BufferedReader(in);
                String line = null;
                boolean skip = true;
                while ((line = reader.readLine()) != null) {
                    try {
                        if (line.startsWith("1001")) {
                            skip = false;
                            continue;
                        }
                        if (skip) continue;
                        swapusage = Long.parseLong(line.trim());
                        this.logger.info("getSwapUsage-", null, "PID:" + this.pid + " Swap Usage:" + line);
                    }
                    catch (NumberFormatException e) {
                        this.logger.error("getSwapUsage", null, line);
                    }
                }
            }
            catch (Exception e) {
                this.logger.error("getSwapUsage", null, e, new Object[0]);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception e) {
                        this.logger.error("getSwapUsage", null, e, new Object[0]);
                    }
                }
            }
        }
        return swapusage;
    }
}

