/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.admin.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.uima.ducc.common.admin.event.RmAdminReply;
import org.apache.uima.ducc.common.admin.event.RmQueriedMachine;

public class RmAdminQOccupancyReply
extends RmAdminReply {
    private static final long serialVersionUID = -8101741014979144426L;
    List<RmQueriedMachine> machines = new ArrayList<RmQueriedMachine>();

    public RmAdminQOccupancyReply() {
        super(null);
    }

    public void addMachine(RmQueriedMachine m) {
        this.machines.add(m);
    }

    public List<RmQueriedMachine> getMachines() {
        return this.machines;
    }

    public String toConsole() {
        Collections.sort(this.machines, new MachineByOrderSorter());
        StringBuffer sb = new StringBuffer();
        sb.append(RmQueriedMachine.header());
        sb.append("\n");
        for (RmQueriedMachine m : this.machines) {
            sb.append(m.toConsole());
            sb.append("\n");
        }
        return sb.toString();
    }

    public String toCompact() {
        StringBuffer sb = new StringBuffer();
        for (RmQueriedMachine m : this.machines) {
            sb.append(m.toCompact());
            sb.append("\n");
        }
        return sb.toString();
    }

    class MachineByOrderSorter
    implements Comparator<RmQueriedMachine> {
        MachineByOrderSorter() {
        }

        @Override
        public int compare(RmQueriedMachine m1, RmQueriedMachine m2) {
            int o2;
            int o1 = m1.getShareOrder();
            if (o1 == (o2 = m2.getShareOrder())) {
                return m1.getId().compareTo(m2.getId());
            }
            return o2 - o1;
        }
    }
}

