/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.admin.event;

import org.apache.uima.ducc.common.admin.event.RmAdminReply;

public class RmAdminQLoadReply
extends RmAdminReply {
    private static final long serialVersionUID = -8101741014979144426L;
    int nodesOnline;
    int nodesDead;
    int nodesOffline;
    int nodesFree;
    int sharesAvailable;
    int sharesFree;
    int[] sharesDemanded;
    int[] sharesAwarded;
    int[] machinesOnline;
    int[] machinesFree;
    int[] machinesVirtual;
    int pendingEvictions;
    int pendingExpansions;

    public RmAdminQLoadReply() {
        super(null);
    }

    public int getNodesOnline() {
        return this.nodesOnline;
    }

    public void setNodesOnline(int nodes_online) {
        this.nodesOnline = nodes_online;
    }

    public int getNodesFree() {
        return this.nodesFree;
    }

    public void setNodesFree(int nodes_free) {
        this.nodesFree = nodes_free;
    }

    public int getNodesDead() {
        return this.nodesDead;
    }

    public void setNodesDead(int nodes_dead) {
        this.nodesDead = nodes_dead;
    }

    public int getNodesOffline() {
        return this.nodesOffline;
    }

    public void setNodesOffline(int nodes_offline) {
        this.nodesOffline = nodes_offline;
    }

    public int getSharesAvailable() {
        return this.sharesAvailable;
    }

    public void setSharesAvailable(int shares_available) {
        this.sharesAvailable = shares_available;
    }

    public int getSharesFree() {
        return this.sharesFree;
    }

    public void setSharesFree(int shares_free) {
        this.sharesFree = shares_free;
    }

    public int getPendingEvictions() {
        return this.pendingEvictions;
    }

    public void setPendingEvictions(int pending_evictions) {
        this.pendingEvictions = pending_evictions;
    }

    public int getPendingExpansions() {
        return this.pendingExpansions;
    }

    public void setPendingExpansions(int pending_expansions) {
        this.pendingExpansions = pending_expansions;
    }

    public int[] getSharesDemanded() {
        return this.sharesDemanded;
    }

    public void setSharesDemanded(int[] shares_demanded) {
        this.sharesDemanded = shares_demanded;
    }

    public int[] getSharesAwarded() {
        return this.sharesAwarded;
    }

    public void setSharesAwarded(int[] shares_awarded) {
        this.sharesAwarded = shares_awarded;
    }

    public int[] getMachinesOnline() {
        return this.machinesOnline;
    }

    public void setMachinesOnline(int[] machines_online) {
        this.machinesOnline = machines_online;
    }

    public int[] getMachinesFree() {
        return this.machinesFree;
    }

    public void setMachinesFree(int[] machines_free) {
        this.machinesFree = machines_free;
    }

    public int[] getVirtualMachinesFree() {
        int[] vm = (int[])this.machinesVirtual.clone();
        int len = vm.length;
        for (int o = 1; o < len; ++o) {
            for (int p = o + 1; p < len; ++p) {
                if (vm[p] == 0) continue;
                int n = o;
                vm[n] = vm[n] + p / o * vm[p];
            }
        }
        return vm;
    }

    public int[] getMachinesVirtual() {
        return this.machinesVirtual;
    }

    public void setMachinesVirtual(int[] machines_virtual) {
        this.machinesVirtual = machines_virtual;
    }

    private String fmtArray(int[] array) {
        Object[] vals = new Object[array.length];
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            sb.append("%3s ");
            vals[i] = Integer.toString(array[i]);
        }
        return String.format(sb.toString(), vals);
    }

    public String toCompact() {
        StringBuffer sb = new StringBuffer();
        sb.append("OnlineHosts ");
        sb.append(this.fmtArray(this.machinesOnline));
        sb.append("\nFreeHosts ");
        sb.append(this.fmtArray(this.machinesFree));
        sb.append("\nFreeShares ");
        sb.append(this.fmtArray(this.machinesVirtual));
        sb.append("\nVirtualShares ");
        sb.append(this.fmtArray(this.getVirtualMachinesFree()));
        sb.append("\nWantedShares ");
        sb.append(this.fmtArray(this.sharesDemanded));
        sb.append("\nGivenShares ");
        sb.append(this.fmtArray(this.sharesAwarded));
        return sb.toString();
    }

    public String toConsole() {
        StringBuffer sb = new StringBuffer();
        String hdr = "%10s %9s %12s %9s %16s %10s %16s %17s";
        String fmt = "%10d %9d %12d %9d %16d %10d %16d %17d";
        sb.append(String.format(hdr, "TotalNodes", "DeadNOdes", "OfflineNodes", "FreeNodes", "SharesAvailable", "SharesFree", "PendingEvictions", "PendingExpansions"));
        sb.append("\n");
        sb.append(String.format(fmt, this.nodesOnline, this.nodesDead, this.nodesOffline, this.nodesFree, this.sharesAvailable, this.sharesFree, this.pendingEvictions, this.pendingExpansions));
        sb.append("\nOnline Hosts:\n");
        sb.append(this.fmtArray(this.machinesOnline));
        sb.append("\nFree Hosts:\n");
        sb.append(this.fmtArray(this.machinesFree));
        sb.append("\nFree Shares:\n");
        sb.append(this.fmtArray(this.machinesVirtual));
        sb.append("\nVirtual Shares:\n");
        sb.append(this.fmtArray(this.getVirtualMachinesFree()));
        sb.append("\nWanted Shares:\n");
        sb.append(this.fmtArray(this.sharesDemanded));
        sb.append("\nGiven Shares:\n");
        sb.append(this.fmtArray(this.sharesAwarded));
        return sb.toString();
    }
}

