/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccProperties;
import org.apache.uima.ducc.common.utils.IllegalConfigurationException;
import org.apache.uima.ducc.common.utils.SystemPropertyResolver;

public class NodeConfiguration {
    String config_file_name = null;
    BufferedReader in;
    int lineno = 0;
    DuccProperties defaultFairShareClass = new DuccProperties();
    DuccProperties defaultFixedShareClass = new DuccProperties();
    DuccProperties defaultReserveClass = new DuccProperties();
    DuccProperties defaultNodepool = new DuccProperties();
    Map<String, DuccProperties> np_set;
    Map<String, DuccProperties> class_set;
    Map<String, String> allNodefiles;
    DuccLogger logger;
    String defaultDomain = null;
    String firstNodepool = null;
    boolean fairShareExists = false;
    boolean fixedExists = false;
    boolean reserveExists = false;
    DuccProperties fairShareDefault = null;
    DuccProperties fixedDefault = null;
    DuccProperties reserveDefault = null;
    String ducc_home = null;
    Map<String, String> allNodes = new HashMap<String, String>();
    StringTokenizer buf = null;
    ArrayList<DuccProperties> nodepools = new ArrayList();
    ArrayList<DuccProperties> classes = new ArrayList();
    Map<String, DuccProperties> npmap = new HashMap<String, DuccProperties>();
    Map<String, DuccProperties> clmap = new HashMap<String, DuccProperties>();
    ArrayList<DuccProperties> independentNodepools = new ArrayList();
    ArrayList<String> independentClasses = new ArrayList();

    public NodeConfiguration(String config_file_name, DuccLogger logger) {
        this.config_file_name = config_file_name;
        this.logger = logger;
        this.allNodefiles = new HashMap<String, String>();
        this.ducc_home = System.getProperty("DUCC_HOME");
        this.defaultFairShareClass.put("type", "class");
        this.defaultFairShareClass.put("name", "defaultFairShareClass");
        this.defaultFairShareClass.put("policy", "FAIR_SHARE");
        this.defaultFairShareClass.put("weight", "100");
        this.defaultFairShareClass.put("priority", "10");
        this.defaultFairShareClass.put("cap", Integer.toString(Integer.MAX_VALUE));
        this.defaultFairShareClass.put("expand-by-doubling", "" + SystemPropertyResolver.getBooleanProperty("ducc.rm.expand.by.doubling", true));
        this.defaultFairShareClass.put("initialization-cap", "" + SystemPropertyResolver.getIntProperty("ducc.rm.initialization.cap", 2));
        this.defaultFairShareClass.put("use-prediction", "" + SystemPropertyResolver.getBooleanProperty("ducc.rm.prediction", true));
        this.defaultFairShareClass.put("prediction-fudge", "" + SystemPropertyResolver.getIntProperty("ducc.rm.prediction.fudge", 60000));
        this.defaultFairShareClass.put("max-processes", Integer.toString(Integer.MAX_VALUE));
        this.defaultFairShareClass.put("nodepool", "<required>");
        this.defaultFairShareClass.put("debug", "fixed");
        this.defaultFairShareClass.put("abstract", "<optional>");
        this.defaultFairShareClass.put("children", "<optional>");
        this.defaultFairShareClass.put("parent", "<optional>");
        this.defaultFairShareClass.put("debug", "<optional>");
        this.defaultFairShareClass.put("default", "<optional>");
        this.defaultFairShareClass.put("name", "<required>");
        this.defaultFixedShareClass.put("type", "class");
        this.defaultFixedShareClass.put("name", "defaultFixedShareClass");
        this.defaultFixedShareClass.put("abstract", "<optional>");
        this.defaultFixedShareClass.put("children", "<optional>");
        this.defaultFixedShareClass.put("parent", "<optional>");
        this.defaultFixedShareClass.put("policy", "FIXED_SHARE");
        this.defaultFixedShareClass.put("priority", "5");
        this.defaultFixedShareClass.put("default", "<optional>");
        this.defaultFixedShareClass.put("max-processes", Integer.toString(Integer.MAX_VALUE));
        this.defaultFixedShareClass.put("cap", Integer.toString(Integer.MAX_VALUE));
        this.defaultFixedShareClass.put("nodepool", "<required>");
        this.defaultReserveClass.put("type", "class");
        this.defaultReserveClass.put("name", "defaultReserveClass");
        this.defaultReserveClass.put("abstract", "<optional>");
        this.defaultReserveClass.put("children", "<optional>");
        this.defaultReserveClass.put("parent", "<optional>");
        this.defaultReserveClass.put("policy", "RESERVE");
        this.defaultReserveClass.put("priority", "1");
        this.defaultReserveClass.put("default", "<optional>");
        this.defaultReserveClass.put("max-machines", Integer.toString(Integer.MAX_VALUE));
        this.defaultReserveClass.put("cap", Integer.toString(Integer.MAX_VALUE));
        this.defaultReserveClass.put("nodepool", "<required>");
        this.defaultReserveClass.put("enforce", "true");
        this.defaultNodepool.put("type", "nodepool");
        this.defaultNodepool.put("name", "<optional>");
        this.defaultNodepool.put("nodefile", "<optional>");
        this.defaultNodepool.put("parent", "<optional>");
        this.defaultNodepool.put("domain", "<optional>");
    }

    String resolve(String file) throws IllegalConfigurationException {
        File f;
        if (!file.startsWith("/")) {
            file = this.ducc_home + "/resources/" + file;
        }
        if (!(f = new File(file)).exists()) {
            throw new IllegalConfigurationException("File " + file + " does not exist or cannot be read.");
        }
        return file;
    }

    void logInfo(String methodName, String message) {
        if (this.logger == null) {
            System.out.println(message);
        } else {
            this.logger.info(methodName, null, message);
        }
    }

    void logWarn(String methodName, String message) {
        if (this.logger == null) {
            System.out.println(message);
        } else {
            this.logger.warn(methodName, null, message);
        }
    }

    void logError(String methodName, String message) {
        if (this.logger == null) {
            System.out.println(message);
        } else {
            this.logger.error(methodName, null, message);
        }
    }

    private String getDomainName() {
        if (this.defaultDomain != null) {
            return this.defaultDomain;
        }
        InetAddress me = null;
        try {
            me = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e1) {
            e1.printStackTrace();
        }
        String my_happy_name = me.getHostName();
        String my_canonical_name = me.getCanonicalHostName();
        if (my_canonical_name.startsWith(my_happy_name)) {
            int ndx = my_canonical_name.indexOf(".");
            return my_canonical_name.substring(ndx + 1);
        }
        return null;
    }

    Map<String, String> readNodepoolFile(String npfile, String domain, boolean skip) throws IllegalConfigurationException {
        this.allNodefiles.put(npfile, npfile);
        npfile = this.resolve(npfile);
        HashMap<String, String> response = new HashMap<String, String>();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(npfile));
            String node = "";
            while ((node = br.readLine()) != null) {
                String[] tmp;
                int ndx = node.indexOf("#");
                if (ndx >= 0) {
                    node = node.substring(0, ndx);
                }
                if ((node = node.trim()).equals("")) continue;
                if (node.startsWith("domain")) {
                    tmp = node.split("\\s+");
                    if (tmp.length == 2) {
                        domain = tmp[1];
                        continue;
                    }
                    throw new IllegalConfigurationException("Invalid domain specification in node file " + npfile + ": " + node);
                }
                if (node.startsWith("import")) {
                    tmp = node.split("\\s+");
                    if (this.allNodefiles.containsKey(tmp[1])) {
                        if (skip) continue;
                        throw new IllegalConfigurationException("Duplicate imported nodefile " + tmp[1] + " found in " + npfile + ", not allowed.");
                    }
                    response.putAll(this.readNodepoolFile(tmp[1], domain, skip));
                    continue;
                }
                if (this.allNodes.containsKey(node)) {
                    throw new IllegalConfigurationException("Duplicate node found in " + npfile + ": " + node + "; first occurance in " + this.allNodes.get(node));
                }
                this.allNodes.put(node, npfile);
                response.put(node, node);
                ndx = node.indexOf(".");
                String dnode = null;
                if (ndx >= 0) {
                    dnode = node.substring(0, ndx);
                    response.put(dnode, dnode);
                } else if (domain != null) {
                    dnode = node + "." + domain;
                    response.put(dnode, dnode);
                }
                if (dnode == null) continue;
                if (this.allNodes.containsKey(dnode)) {
                    throw new IllegalConfigurationException("Duplicate node found in " + npfile + ": " + dnode + "; first occurance in " + this.allNodes.get(dnode));
                }
                this.allNodes.put(dnode, npfile);
            }
        }
        catch (FileNotFoundException e) {
            throw new IllegalConfigurationException("Cannot open NodePool file \"" + npfile + "\": file not found.");
        }
        catch (IOException e) {
            throw new IllegalConfigurationException("Cannot read NodePool file \"" + npfile + "\": I/O Error.");
        }
        finally {
            try {
                br.close();
            }
            catch (IOException e) {}
        }
        return response;
    }

    String readLine() throws IOException {
        String line = null;
        while ((line = this.in.readLine()) != null) {
            ++this.lineno;
            if ((line = line.trim()).equals("") || line.startsWith("#")) continue;
            return line;
        }
        return null;
    }

    boolean fillBuf() throws IOException {
        while (this.buf == null || !this.buf.hasMoreTokens()) {
            String line = this.readLine();
            if (line == null) {
                return false;
            }
            this.buf = new StringTokenizer(line, "\n\t\r\f{} =;", true);
        }
        return true;
    }

    String nextToken() throws IOException {
        while (this.fillBuf()) {
            String tok = null;
            while (this.buf.hasMoreTokens()) {
                tok = this.buf.nextToken();
                if (tok.equals(" ") || tok.equals("\t") || tok.equals(";")) continue;
                return tok;
            }
        }
        return null;
    }

    void parseInternal(DuccProperties props) throws IOException, IllegalConfigurationException {
        String tok = null;
        while ((tok = this.nextToken()) != null) {
            if (tok.equals("}")) {
                return;
            }
            String k = tok;
            if (k.equals("{")) {
                throw new IllegalConfigurationException("Missing '}' near line " + this.lineno + " in " + this.config_file_name);
            }
            String v = this.nextToken();
            if (v.equals("=")) {
                v = this.nextToken();
            }
            if (v.equals("}")) {
                throw new IllegalConfigurationException("Missing value near line " + this.lineno + " in " + this.config_file_name);
            }
            if (v.equals("{")) {
                throw new IllegalConfigurationException("Missing '}' near line " + this.lineno + " in " + this.config_file_name);
            }
            if (props.getProperty(k) == null) {
                props.put(k, v);
                continue;
            }
            throw new IllegalConfigurationException("Duplicate property near line " + this.lineno + " in " + this.config_file_name + ": " + k);
        }
    }

    DuccProperties parseNodepool(String name, String parent) throws IOException, IllegalConfigurationException {
        if (this.firstNodepool == null) {
            this.firstNodepool = name;
        }
        DuccProperties ret = new DuccProperties();
        ret.put("type", "nodepool");
        ret.put("name", name);
        if (parent != null) {
            throw new IllegalConfigurationException("Illegal inheritance (inheritance not supported for nodepools) near line " + this.lineno + " in " + this.config_file_name);
        }
        this.parseInternal(ret);
        String dd = ret.getProperty("domain");
        if (name.equals(this.firstNodepool) && dd != null) {
            this.defaultDomain = dd;
        } else if (dd != null) {
            throw new IllegalConfigurationException("Default domain specified in nodepool other than first nodepool \"" + this.firstNodepool + "\", not allowed, near line " + this.lineno + " in " + this.config_file_name);
        }
        this.supplyDefaults(ret, this.defaultNodepool);
        return ret;
    }

    DuccProperties parseClass(String name, String parent) throws IOException, IllegalConfigurationException {
        DuccProperties ret = new DuccProperties();
        ret.put("type", "class");
        ret.put("name", name);
        if (parent != null) {
            ret.put("parent", parent);
        }
        this.parseInternal(ret);
        return ret;
    }

    DuccProperties parseStanzas() throws IOException, IllegalConfigurationException {
        String tok;
        while ((tok = this.nextToken()) != null) {
            String type = tok;
            String name = this.nextToken();
            if (name == null) {
                throw new IllegalConfigurationException("Missing stanza name near line " + this.lineno + " in " + this.config_file_name);
            }
            String parent = this.nextToken();
            String start = null;
            if (parent.equals("{")) {
                start = parent;
                parent = null;
            } else {
                start = this.nextToken();
            }
            if (!start.equals("{")) {
                throw new IllegalConfigurationException("Missing '{' near line " + this.lineno + " in " + this.config_file_name);
            }
            if (type.equals("Nodepool")) {
                this.nodepools.add(this.parseNodepool(name, parent));
            }
            if (!type.equals("Class")) continue;
            this.classes.add(this.parseClass(name, parent));
        }
        return null;
    }

    void supplyDefaults(DuccProperties in, DuccProperties model) throws IllegalConfigurationException {
        String k;
        String name = in.getProperty("name");
        String type = in.getProperty("type");
        for (Object o : in.keySet()) {
            k = (String)o;
            if (model.get(k) != null) continue;
            throw new IllegalConfigurationException("Illegal property \"" + k + "\" in " + type + " " + name);
        }
        for (Object o : model.keySet()) {
            k = (String)o;
            String vm = model.getProperty(k);
            String vi = in.getProperty(k);
            if (vi != null) continue;
            if (vm.equals("<required>")) {
                throw new IllegalConfigurationException("Missing required property " + k + " in " + type + " " + name);
            }
            if (vm.equals("<optional>")) continue;
            in.put(k, vm);
        }
    }

    void propogateDown(String clname) {
        String[] kids;
        DuccProperties cl = this.clmap.get(clname);
        String children = cl.getStringProperty("children", null);
        if (children == null) {
            return;
        }
        for (String kid : kids = children.split("\\s+")) {
            DuccProperties kp = this.clmap.get(kid);
            for (Object o : cl.keySet()) {
                String k;
                if (kp.containsKey(o) || (k = (String)o).equals("abstract") || k.equals("children") || k.equals("default")) continue;
                String v = cl.getStringProperty(k);
                kp.put(k, v);
            }
            this.propogateDown(kid);
        }
    }

    void handleDefault(DuccProperties p, DuccProperties def, String policy) throws IllegalConfigurationException {
        String dflt = p.getProperty("default");
        if (dflt != null) {
            if (def != null) {
                throw new IllegalConfigurationException("Class " + p.getProperty("name") + ": Only one " + policy + " default allowed.  Already defined in class \"" + def.getProperty("name") + "\"");
            }
            if (policy.equals("FAIR_SHARE")) {
                this.fairShareDefault = p;
            } else if (policy.equals("FIXED_SHARE")) {
                this.fixedDefault = p;
            } else {
                this.reserveDefault = p;
            }
        }
    }

    void doClassInheritance() throws IllegalConfigurationException {
        String name;
        for (DuccProperties p : this.classes) {
            String name2 = p.getStringProperty("name");
            if (this.clmap.containsKey(name2)) {
                throw new IllegalConfigurationException("Duplicate class: " + name2);
            }
            this.clmap.put(name2, p);
        }
        for (DuccProperties p : this.clmap.values()) {
            String parent = p.getProperty("parent");
            name = p.getProperty("name");
            if (p.getProperty("abstract") != null && p.getProperty("default") != null) {
                throw new IllegalConfigurationException("Class " + name + ": Abstract class is not allowed to specify \"default\"");
            }
            if (parent == null) {
                this.independentClasses.add(name);
                continue;
            }
            DuccProperties par_cl = this.clmap.get(parent);
            if (par_cl == null) {
                throw new IllegalConfigurationException("Class " + name + " parent pool " + parent + " cannot be found.");
            }
            String children = par_cl.getStringProperty("children", null);
            children = children == null ? name : children + " " + name;
            par_cl.put("children", children);
        }
        for (String s : this.independentClasses) {
            this.propogateDown(s);
        }
        for (DuccProperties p : this.clmap.values()) {
            String policy = p.getStringProperty("policy", null);
            name = p.getProperty("name");
            if (policy == null) {
                throw new IllegalConfigurationException("Class " + name + " is missing scheduling policy ");
            }
            if (policy.equals("FAIR_SHARE")) {
                this.fairShareExists = true;
                this.handleDefault(p, this.fairShareDefault, policy);
                this.supplyDefaults(p, this.defaultFairShareClass);
                continue;
            }
            if (policy.equals("FIXED_SHARE")) {
                this.fixedExists = true;
                this.handleDefault(p, this.fixedDefault, policy);
                this.supplyDefaults(p, this.defaultFixedShareClass);
                continue;
            }
            if (policy.equals("RESERVE")) {
                this.reserveExists = true;
                this.handleDefault(p, this.reserveDefault, policy);
                this.supplyDefaults(p, this.defaultReserveClass);
                continue;
            }
            throw new IllegalConfigurationException("Unknown scheduling policy \"" + policy + "\" in class " + name);
        }
        Iterator<String> iter = this.clmap.keySet().iterator();
        while (iter.hasNext()) {
            String k = iter.next();
            DuccProperties p = this.clmap.get(k);
            if (!p.containsKey("abstract")) continue;
            iter.remove();
        }
    }

    void connectNodepools() throws IllegalConfigurationException {
        String name;
        for (DuccProperties p : this.nodepools) {
            name = p.getStringProperty("name");
            if (this.npmap.containsKey(name)) {
                throw new IllegalConfigurationException("Duplicate nodepool: " + name);
            }
            this.npmap.put(name, p);
        }
        for (DuccProperties p : this.nodepools) {
            String parent = p.getStringProperty("parent", null);
            String name2 = p.getStringProperty("name");
            if (parent == null) {
                this.independentNodepools.add(p);
                continue;
            }
            DuccProperties par_pool = this.npmap.get(parent);
            if (par_pool == null) {
                throw new IllegalConfigurationException("Nodepool " + name2 + " parent pool " + parent + " cannot be found.");
            }
            ArrayList<DuccProperties> children = (ArrayList<DuccProperties>)par_pool.get("children");
            if (children == null) {
                children = new ArrayList<DuccProperties>();
                par_pool.put("children", children);
            }
            children.add(p);
        }
        for (DuccProperties p : this.classes) {
            if (p.containsKey("abstract")) continue;
            name = p.getStringProperty("name");
            String npname = p.getStringProperty("nodepool", null);
            if (npname == null) {
                throw new IllegalConfigurationException("Class " + name + " is not assigned to a nodepool.");
            }
            DuccProperties np = this.npmap.get(npname);
            if (np == null) {
                throw new IllegalConfigurationException("Class " + name + " assigned to nodepool " + npname + " but nodepool does not exist.");
            }
            ArrayList<DuccProperties> class_set = (ArrayList<DuccProperties>)np.get("classes");
            if (class_set == null) {
                class_set = new ArrayList<DuccProperties>();
                np.put("classes", class_set);
            }
            class_set.add(p);
        }
    }

    void readNodefile(DuccProperties p, String domain) throws IllegalConfigurationException {
        List children;
        String npfile = p.getProperty("nodefile");
        if (npfile != null) {
            p.put("nodes", this.readNodepoolFile(npfile, domain, false));
        }
        if ((children = (List)p.get("children")) != null) {
            for (DuccProperties pc : children) {
                this.readNodefile(pc, domain);
            }
        }
    }

    void fullValidation(String global_nodefile) throws IllegalConfigurationException {
        if (this.allNodefiles.containsKey(global_nodefile = this.resolve(global_nodefile))) {
            return;
        }
        this.readNodepoolFile(global_nodefile, this.defaultDomain, true);
    }

    public DuccProperties getDefaultFairShareClass() {
        return this.fairShareDefault;
    }

    public DuccProperties getDefaultFixedClass() {
        return this.fixedDefault;
    }

    public DuccProperties getDefaultReserveClass() {
        return this.reserveDefault;
    }

    public DuccProperties[] getToplevelNodepools() {
        return this.independentNodepools.toArray(new DuccProperties[this.independentNodepools.size()]);
    }

    public DuccProperties getClass(String name) {
        if (this.clmap == null) {
            return null;
        }
        return this.clmap.get(name);
    }

    public Map<String, DuccProperties> getClasses() {
        return this.clmap;
    }

    public void readConfiguration() throws FileNotFoundException, IOException, IllegalConfigurationException {
        if (this.ducc_home == null) {
            throw new IllegalConfigurationException("DUCC_HOME must be defined as a system property.");
        }
        this.defaultDomain = this.getDomainName();
        this.config_file_name = this.resolve(this.config_file_name);
        this.in = new BufferedReader(new FileReader(this.config_file_name));
        this.parseStanzas();
        this.doClassInheritance();
        this.connectNodepools();
        for (DuccProperties p : this.independentNodepools) {
            this.readNodefile(p, this.defaultDomain);
        }
        String msg = "";
        String sep = "";
        if (this.fairShareExists && this.fairShareDefault == null) {
            msg = "Definition for Default FAIR_SHARE is missing.";
            sep = "\n";
        }
        if (this.fixedExists && this.fixedDefault == null) {
            msg = msg + sep + "Definition for Default FIXED_SHARE class is missing.";
            sep = "\n";
        }
        if (this.reserveExists && this.reserveDefault == null) {
            msg = msg + sep + "Definition for Default RESERVE class is missing.";
        }
        if (!msg.equals("")) {
            throw new IllegalConfigurationException(msg);
        }
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void printNodepool(DuccProperties p, String indent) {
        String methodName = "printNodepool";
        this.logInfo(methodName, indent + "Nodepool " + p.getProperty("name"));
        String nodefile = p.getProperty("nodeile");
        this.logInfo(methodName, indent + "   Node File: " + (nodefile == null ? "None" : nodefile));
        List class_set = (List)p.get("classes");
        if (class_set == null) {
            this.logInfo(methodName, indent + "   No classes defined.");
        } else {
            StringBuffer buf = new StringBuffer();
            buf.append(indent + "   Classes:");
            for (DuccProperties cp : class_set) {
                buf.append(" " + cp.get("name"));
            }
            this.logInfo(methodName, buf.toString());
        }
        List children = (List)p.get("children");
        if (children == null) {
            this.logInfo(methodName, indent + "   No subpools.\n");
        } else {
            StringBuffer buf = new StringBuffer();
            buf.append(indent + "   Subpools:");
            for (DuccProperties cp : children) {
                buf.append(" " + cp.get("name"));
            }
            this.logInfo(methodName, buf.toString());
            for (DuccProperties cp : children) {
                this.printNodepool(cp, indent + indent);
            }
        }
    }

    void printProperty(String k, Object v) {
        String methodName = "printProperty";
        if (v == null) {
            return;
        }
        this.logInfo(methodName, String.format("   %-20s: %s", k, v));
    }

    void printClass(DuccProperties cl) {
        String methodName = "printClass";
        this.logInfo(methodName, "Class " + cl.get("name"));
        this.printProperty("Policy", cl.get("policy"));
        this.printProperty("Nodepool", cl.get("nodepool"));
        this.printProperty("Priority", cl.get("priority"));
        this.printProperty("Weight", cl.get("weight"));
        this.printProperty("Debug", cl.get("debug"));
        this.printProperty("Cap", cl.get("cap"));
        this.printProperty("Expand By Doubling", cl.get("expand-by-doubling"));
        this.printProperty("Initialization Cap", cl.get("initialization-cap"));
        this.printProperty("Use Prediction", cl.get("use-prediction"));
        this.printProperty("Prediction Fudge", cl.get("prediction-fudge"));
        this.printProperty("Max Processes", cl.get("max-processes"));
        this.printProperty("Max Machines", cl.get("max-machines"));
        this.printProperty("Enforce Memory Size", cl.get("enforce"));
        this.logInfo(methodName, "");
    }

    public void printConfiguration() {
        String methodName = "printConfiguration";
        if (this.independentNodepools == null || this.clmap == null) {
            this.logError(methodName, "Configuration has not been generated. (Run readConfiguration first.)");
        }
        for (DuccProperties p : this.independentNodepools) {
            this.printNodepool(p, "   ");
        }
        DuccProperties[] class_set = this.clmap.values().toArray(new DuccProperties[this.clmap.size()]);
        Arrays.sort(class_set, new ClassSorter());
        for (DuccProperties p : class_set) {
            this.printClass(p);
        }
    }

    static void usage(String msg) {
        if (msg != null) {
            System.out.println(msg);
            System.out.println("");
        }
        System.out.println("Usage:");
        System.out.println("    NodeConfiguration [-p] [-v nodefile] <configfile>");
        System.out.println("Where:");
        System.out.println("    -p does validation and prints the configuration with all defaults filled in");
        System.out.println("       If omitted, validation only is performed.");
        System.out.println("    -v <nodefile> does full node validation against the startup nodefile.  This is useful");
        System.out.println("       when there are configured nodes not explicitly defined to a nodepool.");
        System.out.println("    <configfile is the node configuration in ducc_runtime/resources, assuming you've installed DUCC into ducc_runtime");
        System.out.println("     -? show this help.");
        System.out.println("");
        System.exit(1);
    }

    public static void main(String[] args) {
        boolean doprint = false;
        boolean validate_nodes = false;
        String global_nodefile = null;
        String config = null;
        int i = 0;
        for (i = 0; i < args.length; ++i) {
            if (args[i].equals("-p")) {
                doprint = true;
                continue;
            }
            if (args[i].equals("-v")) {
                validate_nodes = true;
                global_nodefile = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equals("-?")) {
                NodeConfiguration.usage(null);
            }
            config = args[i];
        }
        NodeConfiguration nc = new NodeConfiguration(config, null);
        int rc = 0;
        try {
            nc.readConfiguration();
            if (validate_nodes) {
                nc.fullValidation(global_nodefile);
            }
            if (doprint) {
                nc.printConfiguration();
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("Configuration file " + config + " does not exist or cannot be read.");
            rc = 1;
        }
        catch (IOException e) {
            System.out.println("IOError reading configuration file " + config + ": " + e.toString());
            rc = 1;
        }
        catch (IllegalConfigurationException e) {
            System.out.println(e.getMessage());
            rc = 1;
        }
        System.exit(rc);
    }

    public static class ClassSorter
    implements Comparator<DuccProperties> {
        @Override
        public int compare(DuccProperties pr1, DuccProperties pr2) {
            String p2;
            if (pr1.equals(pr2)) {
                return 0;
            }
            String p1 = pr1.getProperty("policy");
            if (!p1.equals(p2 = pr2.getProperty("policy"))) {
                return p1.compareTo(p2);
            }
            String n1 = pr1.getProperty("name");
            String n2 = pr2.getProperty("name");
            return n1.compareTo(n2);
        }
    }
}

