/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class QuotedOptions {
    public static ArrayList<String> tokenizeList(String options, boolean stripQuotes) {
        ArrayList<String> tokens = new ArrayList<String>();
        if (options == null) {
            return tokens;
        }
        String noSpaceRegex = "[^\\s\"']+";
        String doubleQuoteRegex = "\"([^\"]*)\"";
        String singleQuoteRegex = "'([^']*)'";
        String regex = noSpaceRegex + "|" + doubleQuoteRegex + "|" + singleQuoteRegex;
        Pattern patn = Pattern.compile(regex);
        Matcher matcher = patn.matcher(options);
        StringBuilder sb = new StringBuilder();
        if (stripQuotes) {
            while (matcher.find()) {
                if (matcher.group(1) != null) {
                    sb.append(matcher.group(1));
                } else if (matcher.group(2) != null) {
                    sb.append(matcher.group(2));
                } else {
                    sb.append(matcher.group());
                }
                if (matcher.end() < options.length() && !Character.isWhitespace(options.charAt(matcher.end()))) continue;
                tokens.add(sb.toString());
                sb.setLength(0);
            }
        } else {
            while (matcher.find()) {
                sb.append(matcher.group());
                if (matcher.end() < options.length() && !Character.isWhitespace(options.charAt(matcher.end()))) continue;
                tokens.add(sb.toString());
                sb.setLength(0);
            }
        }
        return tokens;
    }

    public static Map<String, String> parseAssignments(List<String> assignments, boolean jvmArgs) throws IllegalArgumentException {
        HashMap<String, String> map = new HashMap<String, String>();
        if (assignments == null || assignments.size() == 0) {
            return map;
        }
        for (String assignment : assignments) {
            String[] parts = assignment.split("=", 2);
            String key = parts[0];
            if (key.length() == 0) {
                throw new IllegalArgumentException("Missing key in assignment: " + assignment);
            }
            if (jvmArgs) {
                if (!key.startsWith("-D")) continue;
                key = key.substring(2);
            }
            map.put(key, parts.length > 1 ? parts[1] : "");
        }
        return map;
    }

    public static void main(String[] args) {
        String[] lists;
        for (String list : lists = new String[]{"SINGLE_QUOTED='single quoted'\tDOUBLE_QUOTED=\"double quoted\"     SINGLE_QUOTE=\"'\" \r DOUBLE_QUOTE='\"'", "", "            ", null}) {
            System.out.println("List: " + list);
            ArrayList<String> tokens = QuotedOptions.tokenizeList(list, false);
            System.out.println("\n  quotes preserved on " + tokens.size());
            for (String token : tokens) {
                System.out.println("~" + token + "~");
            }
            tokens = QuotedOptions.tokenizeList(list, true);
            System.out.println("\n  quotes stripped from " + tokens.size());
            for (String token : tokens) {
                System.out.println("~" + token + "~");
            }
        }
    }
}

