/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.apache.uima.ducc.common.NodeConfiguration;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccProperties;
import org.apache.uima.ducc.common.utils.DuccPropertiesResolver;
import org.apache.uima.ducc.common.utils.Utils;

public class DuccSchedulerClasses {
    public static final String FAIR_SHARE = "FAIR_SHARE";
    public static final String FIXED_SHARE = "FIXED_SHARE";
    public static final String RESERVE = "RESERVE";
    public static final String JobDriver = "JobDriver";
    private static DuccSchedulerClasses instance = null;
    private long lastModified = 0L;
    NodeConfiguration nodeConfiguration = null;
    DuccLogger logger = null;
    private String fileName = null;

    public static DuccSchedulerClasses getInstance() {
        if (instance == null) {
            instance = new DuccSchedulerClasses();
        }
        return instance;
    }

    public DuccSchedulerClasses() {
        String dir_home = Utils.findDuccHome();
        String key = "ducc.rm.class.definitions";
        String file_classes = DuccPropertiesResolver.getInstance().getFileProperty(key);
        String dir_resources = "resources";
        this.fileName = dir_home + File.separator + dir_resources + File.separator + file_classes;
    }

    public DuccSchedulerClasses(DuccLogger logger) {
        this.logger = logger;
    }

    public String getProperty(Properties properties, String name) {
        if (properties == null) {
            return null;
        }
        String retVal = "";
        String property = properties.getProperty(name);
        if (property != null) {
            retVal = property.trim();
        }
        return retVal;
    }

    public NodeConfiguration readConfiguration() throws Exception {
        instance = DuccSchedulerClasses.getInstance();
        File file = new File(this.fileName);
        if (this.lastModified != file.lastModified()) {
            this.lastModified = file.lastModified();
            this.nodeConfiguration = new NodeConfiguration(this.fileName, this.logger);
            this.lastModified = file.lastModified();
            this.nodeConfiguration.readConfiguration();
        }
        return this.nodeConfiguration;
    }

    public Map<String, DuccProperties> getClasses() throws Exception {
        this.readConfiguration();
        return this.nodeConfiguration.getClasses();
    }

    public boolean isPreemptable(String class_name) throws Exception {
        boolean retVal = false;
        this.readConfiguration();
        DuccProperties properties = this.nodeConfiguration.getClass(class_name);
        String policy = this.getProperty(properties, "policy");
        if (policy.equals(FAIR_SHARE)) {
            retVal = true;
        }
        return retVal;
    }

    public String getDefaultClassName() throws Exception {
        String retVal = null;
        this.readConfiguration();
        DuccProperties properties = this.nodeConfiguration.getDefaultFairShareClass();
        if (properties != null) {
            retVal = properties.getProperty("name");
        }
        return retVal;
    }

    public String getDebugClassDefaultName() throws Exception {
        String retVal = null;
        this.readConfiguration();
        DuccProperties properties = this.nodeConfiguration.getDefaultFixedClass();
        if (properties != null) {
            retVal = properties.getProperty("name");
        }
        return retVal;
    }

    public String getDebugClassSpecificName(String class_name) throws Exception {
        String retVal = null;
        this.readConfiguration();
        DuccProperties properties = this.nodeConfiguration.getClass(class_name);
        if (properties != null) {
            retVal = properties.getProperty("debug");
        }
        if (retVal == null) {
            retVal = this.getDebugClassDefaultName();
        }
        return retVal;
    }

    public String[] getReserveClasses() throws Exception {
        this.readConfiguration();
        Map<String, DuccProperties> allClasses = this.nodeConfiguration.getClasses();
        ArrayList<String> classList = new ArrayList<String>();
        for (DuccProperties p : allClasses.values()) {
            String pol = p.getProperty("policy");
            String name = p.getProperty("name");
            if (!pol.equals(RESERVE) && !pol.equals(FIXED_SHARE) || name.equals(JobDriver)) continue;
            classList.add(p.getProperty("name"));
        }
        String[] retVal = classList.toArray(new String[0]);
        return retVal;
    }

    public String getReserveClassDefaultName() throws Exception {
        String retVal = "";
        this.readConfiguration();
        DuccProperties properties = this.nodeConfiguration.getDefaultReserveClass();
        if (properties != null) {
            retVal = properties.getProperty("name");
        }
        return retVal;
    }
}

