/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.utils;

import java.io.File;
import java.io.FileInputStream;
import java.net.InetAddress;
import java.util.Map;
import java.util.Properties;
import org.apache.uima.ducc.common.utils.MissingPropertyException;
import org.apache.uima.ducc.common.utils.Utils;

public class DuccProperties
extends Properties {
    public static final String AGENT_LOG_DIR = "ducc.agent.log.dir";
    public static final String AGENT_BROKER_URL = "ducc.agent.broker.url";
    public static final String AGENT_ENDPOINT = "ducc.agent.endpoint";
    private static final long serialVersionUID = 1L;

    public void load() throws Exception {
        Properties tmp = Utils.loadPropertiesFromClasspathForResource("agent");
        for (Map.Entry<Object, Object> entry : tmp.entrySet()) {
            super.put(entry.getKey(), entry.getValue());
        }
    }

    private String trimComments(String val) {
        String answer = "";
        int ndx = val.indexOf("#");
        answer = ndx >= 0 ? val.substring(0, ndx) : val.trim();
        return answer.trim();
    }

    public int getIntProperty(String k) {
        String v = this.getProperty(k);
        if (v == null) {
            throw new MissingPropertyException("Can't find property \"" + k + "\"");
        }
        v = this.trimComments(v);
        return Integer.parseInt(v);
    }

    public int getIntProperty(String k, int dflt) {
        String v = this.getProperty(k);
        if (v == null) {
            return dflt;
        }
        v = this.trimComments(v);
        return Integer.parseInt(v);
    }

    public long getLongProperty(String k) {
        String v = this.getProperty(k);
        if (v == null) {
            throw new MissingPropertyException("Can't find property \"" + k + "\"");
        }
        v = this.trimComments(v);
        return Long.parseLong(v);
    }

    public long getLongProperty(String k, long dflt) {
        String v = this.getProperty(k);
        if (v == null) {
            return dflt;
        }
        v = this.trimComments(v);
        return Long.parseLong(v);
    }

    public String getStringProperty(String k) {
        String v = this.getProperty(k);
        if (v == null) {
            throw new MissingPropertyException("Can't find property \"" + k + "\"");
        }
        return this.trimComments(v);
    }

    public String getStringProperty(String k, String dflt) {
        String v = this.getProperty(k);
        if (v == null) {
            return dflt;
        }
        return this.trimComments(v);
    }

    public boolean getBooleanProperty(String k, boolean dflt) {
        String v = this.getProperty(k);
        if (v == null) {
            return dflt;
        }
        return (v = this.trimComments(v)).equalsIgnoreCase("t") || v.equalsIgnoreCase("true");
    }

    @Override
    public String getProperty(String k) {
        String val = super.getProperty(k);
        if (val == null) {
            return null;
        }
        if (val.contains("${")) {
            val = Utils.resolvePlaceholders(val, this);
        }
        return val;
    }

    private void override(String configDir) throws Exception {
        File overrides;
        String overrideFile = "";
        String hostname = InetAddress.getLocalHost().getHostName();
        if (configDir != null && (overrides = new File(overrideFile = configDir + hostname.concat(".properties"))).exists()) {
            Properties op = new Properties();
            FileInputStream fis = new FileInputStream(overrideFile);
            op.load(fis);
            fis.close();
            for (Map.Entry<Object, Object> value : op.entrySet()) {
                if (super.containsKey((String)value.getKey())) {
                    super.remove((String)value.getKey());
                }
                super.put(value.getKey(), value.getValue());
            }
        }
    }

    public void load(String agentPropertyFile) throws Exception {
        String configDir = null;
        agentPropertyFile = Utils.resolvePlaceholders(agentPropertyFile);
        FileInputStream fis = new FileInputStream(agentPropertyFile);
        super.load(fis);
        fis.close();
        configDir = agentPropertyFile.substring(0, agentPropertyFile.lastIndexOf(Utils.FileSeparator) + 1);
        this.override(configDir);
    }
}

