/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.jd.files;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Type;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.uima.ducc.common.jd.files.IPersistenceWorkItemState;
import org.apache.uima.ducc.common.jd.files.IWorkItemState;
import org.apache.uima.ducc.common.jd.files.WorkItemState;
import org.apache.uima.ducc.common.utils.AlienFile;
import org.apache.uima.ducc.common.utils.IOHelper;
import org.apache.uima.ducc.common.utils.Utils;

public class WorkItemStateJsonGz
implements IPersistenceWorkItemState {
    public static final String work_item_status_json_gz = "work-item-status.json.gz";
    private String filename = null;
    private Gson gson = new Gson();
    private String ducc_ling = Utils.resolvePlaceholderIfExists(System.getProperty("ducc.agent.launcher.ducc_spawn_path"), System.getProperties());
    public final String encoding = "UTF-8";

    public WorkItemStateJsonGz(String directory) {
        this.initialize(directory);
    }

    @Override
    public void initialize(String directory) {
        this.filename = IOHelper.marryDir2File(directory, work_item_status_json_gz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportData(ConcurrentSkipListMap<Long, IWorkItemState> map) throws IOException {
        BufferedWriter writer = null;
        OutputStreamWriter osr = null;
        GZIPOutputStream gos = null;
        FileOutputStream fos = null;
        File file = null;
        try {
            String json = this.gson.toJson(map);
            file = new File(this.filename);
            fos = new FileOutputStream(file);
            gos = new GZIPOutputStream(fos);
            osr = new OutputStreamWriter((OutputStream)gos, "UTF-8");
            writer = new BufferedWriter(osr);
            writer.write(json);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getSize() throws IOException {
        int size = 0;
        BufferedReader reader = null;
        InputStreamReader isr = null;
        GZIPInputStream gis = null;
        FileInputStream fis = null;
        File file = null;
        int rc = 0;
        try {
            file = new File(this.filename);
            fis = new FileInputStream(file);
            gis = new GZIPInputStream(fis);
            isr = new InputStreamReader((InputStream)gis, "UTF-8");
            reader = new BufferedReader(isr);
            while (rc >= 0) {
                rc = reader.read();
                ++size;
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return size - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConcurrentSkipListMap<Long, IWorkItemState> importData() throws IOException, ClassNotFoundException {
        ConcurrentSkipListMap map = new ConcurrentSkipListMap();
        BufferedReader reader = null;
        InputStreamReader isr = null;
        GZIPInputStream gis = null;
        FileInputStream fis = null;
        File file = null;
        char[] cbuf = new char[this.getSize()];
        try {
            file = new File(this.filename);
            fis = new FileInputStream(file);
            gis = new GZIPInputStream(fis);
            isr = new InputStreamReader((InputStream)gis, "UTF-8");
            reader = new BufferedReader(isr);
            reader.read(cbuf);
            String json = new String(cbuf);
            Type typeOfMap = new TypeToken<ConcurrentSkipListMap<Long, WorkItemState>>(){}.getType();
            map = (ConcurrentSkipListMap)this.gson.fromJson(json, typeOfMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return map;
    }

    public ConcurrentSkipListMap<Long, IWorkItemState> importData(String userid) throws IOException, ClassNotFoundException {
        ConcurrentSkipListMap<Long, IWorkItemState> map = new ConcurrentSkipListMap();
        if (userid == null) {
            map = this.importData();
        } else {
            try {
                AlienFile alienFile = new AlienFile(userid, this.filename, this.ducc_ling);
                String json = alienFile.getString();
                Type typeOfMap = new TypeToken<ConcurrentSkipListMap<Long, WorkItemState>>(){}.getType();
                map = (ConcurrentSkipListMap)this.gson.fromJson(json, typeOfMap);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return map;
    }
}

