/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.cli.aio;

import java.util.Properties;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.impl.XmiSerializationSharedData;
import org.apache.uima.ducc.cli.CliBase;
import org.apache.uima.ducc.cli.DuccJobSubmit;
import org.apache.uima.ducc.cli.IUiOptions;
import org.apache.uima.ducc.cli.aio.CasGenerator;
import org.apache.uima.ducc.cli.aio.CasPipeline;
import org.apache.uima.ducc.cli.aio.IMessageHandler;
import org.apache.uima.ducc.cli.aio.MessageHandler;
import org.apache.uima.ducc.common.utils.DuccProperties;
import org.apache.uima.ducc.transport.event.cli.JobRequestProperties;
import org.apache.uima.ducc.user.common.DuccUimaSerializer;

public class AllInOne
extends CliBase {
    private static String cid = AllInOne.class.getSimpleName();
    private static DuccUimaSerializer uimaSerializer = new DuccUimaSerializer();
    private static XmiSerializationSharedData xmiSerializationSharedData = new XmiSerializationSharedData();
    private IMessageHandler mh = new MessageHandler();
    private JobRequestProperties jobRequestProperties = new JobRequestProperties();
    private boolean showStats = true;
    CasGenerator casGenerator;
    CasPipeline casPipeline;

    public AllInOne(String[] args) throws Exception {
        IUiOptions.UiOption[] opts = DuccJobSubmit.opts;
        this.init(this.getClass().getName(), opts, args, (DuccProperties)this.jobRequestProperties, this.consoleCb);
    }

    private void examine_debug() {
        String mid = "examine_debug";
        this.debug = this.jobRequestProperties.containsKey((Object)IUiOptions.UiOption.Debug.pname());
        if (this.debug) {
            this.mh.setLevel(IMessageHandler.Level.FrameworkInfo, IMessageHandler.Toggle.On);
            this.mh.setLevel(IMessageHandler.Level.FrameworkDebug, IMessageHandler.Toggle.On);
            this.mh.setLevel(IMessageHandler.Level.FrameworkError, IMessageHandler.Toggle.On);
            this.mh.setLevel(IMessageHandler.Level.FrameworkWarn, IMessageHandler.Toggle.On);
            String message = "true";
            this.mh.frameworkDebug(cid, mid, message);
        } else {
            String message = "false";
            this.mh.frameworkDebug(cid, mid, message);
        }
    }

    private void examine_timestamp() {
        String mid = "examine_timestamp";
        boolean timestamp = this.jobRequestProperties.containsKey((Object)IUiOptions.UiOption.Timestamp.pname());
        if (timestamp) {
            this.mh.setTimestamping(IMessageHandler.Toggle.On);
            String message = "true";
            this.mh.frameworkDebug(cid, mid, message);
        } else {
            String message = "false";
            this.mh.frameworkDebug(cid, mid, message);
        }
    }

    private void examine() throws IllegalArgumentException {
        String mid = "examine";
        this.mh.frameworkTrace(cid, mid, "enter");
        this.examine_debug();
        this.examine_timestamp();
        this.mh.frameworkTrace(cid, mid, "exit");
    }

    private void initialize() throws Exception {
        String mid = "initialize";
        this.mh.frameworkTrace(cid, mid, "enter");
        this.casGenerator = new CasGenerator((Properties)this.jobRequestProperties, this.mh);
        this.casGenerator.initialize();
        int total = this.casGenerator.getTotal();
        if (total <= 0) {
            throw new NoWorkItems();
        }
        this.casPipeline = new CasPipeline((Properties)this.jobRequestProperties, this.mh);
        this.casPipeline.initialize();
        this.mh.frameworkTrace(cid, mid, "exit");
    }

    private void process() throws Exception {
        String mid = "process";
        this.mh.frameworkTrace(cid, mid, "enter");
        int count = 0;
        int total = this.casGenerator.getTotal();
        this.mh.frameworkDebug(cid, mid, "total:" + total);
        CAS cas = null;
        while (this.casGenerator.hasNext()) {
            cas = this.casGenerator.getCas(cas);
            this.mh.frameworkDebug(cid, mid, "cas:" + count);
            String serializedCas = uimaSerializer.serializeCasToXmi(cas, xmiSerializationSharedData);
            CAS cas2 = this.casPipeline.getEmptyCas();
            uimaSerializer.deserializeCasFromXmi(serializedCas, cas2, xmiSerializationSharedData, true, -1);
            this.casPipeline.process(cas2);
            ++count;
        }
        this.casPipeline.destroy();
        this.mh.frameworkTrace(cid, mid, "exit");
    }

    private void statistics() {
        if (this.showStats) {
            this.casPipeline.dumpStatistics(System.out);
        }
    }

    public void go() throws Exception {
        String mid = "go";
        this.mh.frameworkTrace(cid, mid, "enter");
        try {
            this.examine();
            this.initialize();
            this.process();
            this.statistics();
        }
        catch (NoWorkItems e) {
            String message = "no work items";
            this.mh.warn(cid, mid, message);
        }
        this.mh.frameworkTrace(cid, mid, "exit");
    }

    public static void main(String[] args) {
        try {
            AllInOne allInOne = new AllInOne(args);
            allInOne.go();
        }
        catch (Exception e) {
            System.exit(1);
        }
    }

    @Override
    public boolean execute() throws Exception {
        return false;
    }

    private class NoWorkItems
    extends Exception {
        private static final long serialVersionUID = 1L;

        private NoWorkItems() {
        }
    }
}

