/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.cli;

import java.util.ArrayList;
import java.util.Properties;
import org.apache.uima.ducc.cli.CliBase;
import org.apache.uima.ducc.cli.CliVersion;
import org.apache.uima.ducc.cli.IDuccCallback;
import org.apache.uima.ducc.cli.IUiOptions;
import org.apache.uima.ducc.cli.aio.AllInOneLauncher;
import org.apache.uima.ducc.common.utils.DuccProperties;
import org.apache.uima.ducc.common.utils.DuccSchedulerClasses;
import org.apache.uima.ducc.transport.event.AbstractDuccOrchestratorEvent;
import org.apache.uima.ducc.transport.event.DuccEvent;
import org.apache.uima.ducc.transport.event.IDuccContext;
import org.apache.uima.ducc.transport.event.SubmitJobDuccEvent;
import org.apache.uima.ducc.transport.event.SubmitJobReplyDuccEvent;
import org.apache.uima.ducc.transport.event.cli.JobRequestProperties;

public class DuccJobSubmit
extends CliBase {
    private JobRequestProperties jobRequestProperties = new JobRequestProperties();
    public static IUiOptions.UiOption[] opts = new IUiOptions.UiOption[]{IUiOptions.UiOption.Help, IUiOptions.UiOption.Debug, IUiOptions.UiOption.Timestamp, IUiOptions.UiOption.AllInOne, IUiOptions.UiOption.AttachConsole, IUiOptions.UiOption.ProcessDebug, IUiOptions.UiOption.DriverDebug, IUiOptions.UiOption.Description, IUiOptions.UiOption.SchedulingClass, IUiOptions.UiOption.LogDirectory, IUiOptions.UiOption.WorkingDirectory, IUiOptions.UiOption.Jvm, IUiOptions.UiOption.Classpath, IUiOptions.UiOption.Environment, IUiOptions.UiOption.DriverJvmArgs, IUiOptions.UiOption.DriverDescriptorCR, IUiOptions.UiOption.DriverDescriptorCROverrides, IUiOptions.UiOption.DriverExceptionHandler, IUiOptions.UiOption.DriverExceptionHandlerArguments, IUiOptions.UiOption.ProcessJvmArgs, IUiOptions.UiOption.ProcessMemorySize, IUiOptions.UiOption.ProcessDD, IUiOptions.UiOption.ProcessDescriptorCM, IUiOptions.UiOption.ProcessDescriptorCMOverrides, IUiOptions.UiOption.ProcessDescriptorAE, IUiOptions.UiOption.ProcessDescriptorAEOverrides, IUiOptions.UiOption.ProcessDescriptorCC, IUiOptions.UiOption.ProcessDescriptorCCOverrides, IUiOptions.UiOption.ProcessDeploymentsMax, IUiOptions.UiOption.ProcessInitializationFailuresCap, IUiOptions.UiOption.ProcessFailuresLimit, IUiOptions.UiOption.ProcessThreadCount, IUiOptions.UiOption.ProcessPerItemTimeMax, IUiOptions.UiOption.ProcessGetMetaTimeMax, IUiOptions.UiOption.ProcessInitializationTimeMax, IUiOptions.UiOption.Specification, IUiOptions.UiOption.SuppressConsoleLog, IUiOptions.UiOption.WaitForCompletion, IUiOptions.UiOption.CancelOnInterrupt, IUiOptions.UiOption.ServiceDependency};
    private AllInOneLauncher allInOneLauncher = null;

    public DuccJobSubmit(String[] args) throws Exception {
        this(args, null);
    }

    public DuccJobSubmit(ArrayList<String> args) throws Exception {
        this(args, null);
    }

    public DuccJobSubmit(Properties props) throws Exception {
        this(props, null);
    }

    public DuccJobSubmit(ArrayList<String> args, IDuccCallback consoleCb) throws Exception {
        this(args.toArray(new String[args.size()]), consoleCb);
    }

    public DuccJobSubmit(String[] args, IDuccCallback consoleCb) throws Exception {
        this.init(this.getClass().getName(), opts, args, (DuccProperties)this.jobRequestProperties, consoleCb);
        this.check_descriptor_options();
        if (this.isAllInOne()) {
            this.allInOneLauncher = new AllInOneLauncher(this.userSpecifiedProperties, consoleCb);
        }
    }

    public DuccJobSubmit(Properties props, IDuccCallback consoleCb) throws Exception {
        this.init(this.getClass().getName(), opts, props, (DuccProperties)this.jobRequestProperties, consoleCb);
        this.check_descriptor_options();
        if (this.isAllInOne()) {
            this.allInOneLauncher = new AllInOneLauncher(this.userSpecifiedProperties, consoleCb);
        }
    }

    protected void transform_scheduling_class(CliBase base, Properties props) throws Exception {
        String scheduling_class = null;
        String user_scheduling_class = null;
        String pname = IUiOptions.UiOption.SchedulingClass.pname();
        DuccSchedulerClasses duccSchedulerClasses = DuccSchedulerClasses.getInstance();
        if (props.containsKey(pname)) {
            user_scheduling_class = props.getProperty(pname);
            if (duccSchedulerClasses.isPreemptable(user_scheduling_class)) {
                scheduling_class = duccSchedulerClasses.getDebugClassSpecificName(user_scheduling_class);
            }
        } else {
            scheduling_class = duccSchedulerClasses.getDebugClassDefaultName();
        }
        if (scheduling_class != null) {
            props.setProperty(pname, scheduling_class);
            String text = pname + "=" + scheduling_class + " -- was " + user_scheduling_class;
            base.message(text);
        }
    }

    private void check_descriptor_options() {
        boolean isPPjob;
        boolean isDDjob = this.jobRequestProperties.containsKey((Object)IUiOptions.UiOption.ProcessDD.pname());
        boolean bl = isPPjob = this.jobRequestProperties.containsKey((Object)IUiOptions.UiOption.ProcessDescriptorCM.pname()) || this.jobRequestProperties.containsKey((Object)IUiOptions.UiOption.ProcessDescriptorAE.pname()) || this.jobRequestProperties.containsKey((Object)IUiOptions.UiOption.ProcessDescriptorCC.pname());
        if (isDDjob && isPPjob) {
            throw new IllegalArgumentException("--process_descriptor_DD is mutually exclusive with the AE, CC, & CM descriptor options");
        }
        if (!isDDjob && !isPPjob) {
            throw new IllegalArgumentException("Missing --process_descriptor_xx option .. DD or at least one of AE, CC, CM required");
        }
    }

    private void set_debug_parms(Properties props, String key, int port) {
        String debug_jvmargs = "-Xdebug -Xrunjdwp:transport=dt_socket,address=" + this.host_address + ":" + port;
        String jvmargs = props.getProperty(key);
        jvmargs = jvmargs == null ? debug_jvmargs : jvmargs + " " + debug_jvmargs;
        props.put(key, jvmargs);
    }

    protected void enrich_parameters_for_debug(Properties props) throws Exception {
        try {
            int jp_debug_port = -1;
            int jd_debug_port = -2;
            String do_debug = IUiOptions.UiOption.ProcessDebug.pname();
            if (props.containsKey(do_debug)) {
                String jp_port_s = props.getProperty(do_debug);
                if (jp_port_s == null) {
                    throw new IllegalArgumentException("Missing port for " + do_debug);
                }
                jp_debug_port = Integer.parseInt(jp_port_s);
                this.set_debug_parms(props, IUiOptions.UiOption.ProcessJvmArgs.pname(), jp_debug_port);
                props.setProperty(IUiOptions.UiOption.ProcessDeploymentsMax.pname(), "1");
                props.setProperty(IUiOptions.UiOption.ProcessFailuresLimit.pname(), "1");
                this.transform_scheduling_class(this, props);
            }
            if (props.containsKey(do_debug = IUiOptions.UiOption.DriverDebug.pname())) {
                String jd_port_s = props.getProperty(do_debug);
                if (jd_port_s == null) {
                    throw new IllegalArgumentException("Missing port for " + do_debug);
                }
                jd_debug_port = Integer.parseInt(jd_port_s);
                this.set_debug_parms(props, IUiOptions.UiOption.DriverJvmArgs.pname(), jd_debug_port);
            }
            if (jp_debug_port == jd_debug_port) {
                throw new IllegalArgumentException("Process and Driver debug ports must differ.");
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid debug port (not numeric)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() throws Exception {
        if (this.allInOneLauncher != null) {
            return this.allInOneLauncher.execute();
        }
        try {
            this.enrich_parameters_for_debug((Properties)this.jobRequestProperties);
        }
        catch (Exception e1) {
            this.message(e1.toString());
            return false;
        }
        String key_cp = IUiOptions.UiOption.Classpath.pname();
        if (!this.jobRequestProperties.containsKey((Object)key_cp)) {
            this.jobRequestProperties.setProperty(key_cp, System.getProperty("java.class.path"));
        }
        if (this.jobRequestProperties.containsKey((Object)IUiOptions.UiOption.Debug.pname())) {
            this.jobRequestProperties.dump();
        }
        if (!this.check_service_dependencies(null)) {
            return false;
        }
        SubmitJobDuccEvent submitJobDuccEvent = new SubmitJobDuccEvent((DuccProperties)this.jobRequestProperties, CliVersion.getVersion());
        SubmitJobReplyDuccEvent submitJobReplyDuccEvent = null;
        try {
            submitJobReplyDuccEvent = (SubmitJobReplyDuccEvent)this.dispatcher.dispatchAndWaitForDuccReply((DuccEvent)submitJobDuccEvent);
        }
        catch (Exception e) {
            this.message("Job not submitted: " + e.getMessage());
            this.stopListeners();
            boolean bl = false;
            return bl;
        }
        finally {
            this.dispatcher.close();
        }
        boolean rc = this.extractReply((AbstractDuccOrchestratorEvent)submitJobReplyDuccEvent);
        if (rc) {
            this.saveSpec("job-specification.properties", (DuccProperties)this.jobRequestProperties);
            this.startMonitors(false, IDuccContext.DuccContext.Job);
        }
        return rc;
    }

    @Override
    public int getReturnCode() {
        if (this.allInOneLauncher != null) {
            return this.allInOneLauncher.getReturnCode();
        }
        return super.getReturnCode();
    }

    @Override
    public long getDuccId() {
        if (this.allInOneLauncher != null) {
            return this.allInOneLauncher.getDuccId();
        }
        return super.getDuccId();
    }

    private boolean isAllInOne() {
        return this.jobRequestProperties.containsKey((Object)IUiOptions.UiOption.AllInOne.pname());
    }

    public static void main(String[] args) {
        try {
            DuccJobSubmit ds = new DuccJobSubmit(args, null);
            boolean rc = ds.execute();
            if (rc) {
                System.out.println("Job " + ds.getDuccId() + " submitted");
                int exit_code = ds.getReturnCode();
                System.exit(exit_code);
            } else {
                System.out.println("Could not submit job");
                System.exit(1);
            }
        }
        catch (Exception e) {
            System.out.println("Cannot initialize: " + e.getMessage());
            if (!(e instanceof IllegalArgumentException)) {
                e.printStackTrace();
            }
            System.exit(1);
        }
    }
}

