/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.cli;

import java.util.ArrayList;
import java.util.Properties;
import org.apache.uima.ducc.cli.CliBase;
import org.apache.uima.ducc.cli.CliVersion;
import org.apache.uima.ducc.cli.IUiOptions;
import org.apache.uima.ducc.common.utils.DuccProperties;
import org.apache.uima.ducc.transport.event.AbstractDuccOrchestratorEvent;
import org.apache.uima.ducc.transport.event.DuccEvent;
import org.apache.uima.ducc.transport.event.SubmitReservationDuccEvent;
import org.apache.uima.ducc.transport.event.SubmitReservationReplyDuccEvent;
import org.apache.uima.ducc.transport.event.cli.ReservationReplyProperties;
import org.apache.uima.ducc.transport.event.cli.ReservationRequestProperties;

public class DuccReservationSubmit
extends CliBase {
    ReservationRequestProperties requestProperties = new ReservationRequestProperties();
    private String nodeList = "";
    private String info = "";
    IUiOptions.UiOption[] opts = new IUiOptions.UiOption[]{IUiOptions.UiOption.Help, IUiOptions.UiOption.Debug, IUiOptions.UiOption.Description, IUiOptions.UiOption.SchedulingClass, IUiOptions.UiOption.NumberOfInstances, IUiOptions.UiOption.Specification, IUiOptions.UiOption.ReservationMemorySize};

    public DuccReservationSubmit(String[] args) throws Exception {
        this.init(this.getClass().getName(), this.opts, args, (DuccProperties)this.requestProperties, null);
    }

    public DuccReservationSubmit(ArrayList<String> args) throws Exception {
        String[] arg_array = args.toArray(new String[args.size()]);
        this.init(this.getClass().getName(), this.opts, arg_array, (DuccProperties)this.requestProperties, null);
    }

    public DuccReservationSubmit(Properties props) throws Exception {
        this.init(this.getClass().getName(), this.opts, props, (DuccProperties)this.requestProperties, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        String key;
        Properties properties;
        SubmitReservationDuccEvent ev = new SubmitReservationDuccEvent((DuccProperties)this.requestProperties, CliVersion.getVersion());
        SubmitReservationReplyDuccEvent reply = null;
        try {
            reply = (SubmitReservationReplyDuccEvent)this.dispatcher.dispatchAndWaitForDuccReply((DuccEvent)ev);
        }
        catch (Exception e) {
            this.message("Reservation not submitted:", e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            this.dispatcher.close();
        }
        boolean rc = this.extractReply((AbstractDuccOrchestratorEvent)reply);
        if (rc) {
            this.nodeList = reply.getProperties().getProperty(IUiOptions.UiOption.ReservationNodeList.pname());
        }
        if (this.nodeList.trim().length() == 0 && (properties = reply.getProperties()) != null && properties.containsKey(key = ReservationReplyProperties.key_message)) {
            this.info = properties.getProperty(key);
        }
        return rc;
    }

    public String[] getHosts() {
        return this.nodeList.split("\\s");
    }

    public String getHostsAsString() {
        return this.nodeList;
    }

    public static void main(String[] args) {
        try {
            DuccReservationSubmit ds = new DuccReservationSubmit(args);
            boolean rc = ds.execute();
            if (rc) {
                System.out.println("Process " + ds.getDuccId() + " submitted.");
                System.out.println("resID = " + ds.getDuccId() + " " + ds.info);
                String nodes = ds.getHostsAsString().trim();
                if (nodes.length() == 0) {
                    nodes = "none";
                }
                System.out.println("nodes: " + nodes);
                System.exit(0);
            } else {
                System.out.println("Could not submit reservation.");
                System.exit(1);
            }
        }
        catch (Exception e) {
            System.out.println("Cannot initialize: " + e.getMessage() + ".");
            System.exit(1);
        }
    }
}

