/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.cli;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.util.HashMap;
import org.apache.uima.UIMAFramework;
import org.apache.uima.aae.client.UimaASProcessStatus;
import org.apache.uima.aae.client.UimaAsBaseCallbackListener;
import org.apache.uima.adapter.jms.client.BaseUIMAAsynchronousEngine_impl;
import org.apache.uima.cas.CAS;
import org.apache.uima.collection.EntityProcessStatus;
import org.apache.uima.ducc.cli.AServicePing;
import org.apache.uima.ducc.cli.ServiceStatistics;
import org.apache.uima.ducc.cli.UimaAsServiceMonitor;
import org.apache.uima.ducc.common.IServiceStatistics;
import org.apache.uima.ducc.common.TcpStreamHandler;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccProperties;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;

public class UimaAsPing
extends AServicePing {
    int window = 3;
    int queue_threshold = 0;
    String ep;
    String endpoint;
    String broker;
    int meta_timeout;
    String broker_host;
    int broker_jmx_port;
    boolean connected;
    UimaAsServiceMonitor monitor;
    DuccLogger logger = null;
    int[] queueSizeWindow;
    int queueCursor = 0;
    String nodeIp;
    String pid;
    boolean gmfail = false;

    public UimaAsPing() {
        this.logger = null;
    }

    public UimaAsPing(DuccLogger logger) {
        this.logger = logger;
    }

    @Override
    public void init(String args, String ep) throws Exception {
        this.ep = ep;
        int ndx = ep.indexOf(":");
        ep = ep.substring(ndx + 1);
        ndx = ep.indexOf(":");
        this.endpoint = ep.substring(0, ndx).trim();
        this.broker = ep.substring(ndx + 1).trim();
        URL url = null;
        try {
            url = new URL(null, this.broker, (URLStreamHandler)new TcpStreamHandler());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid broker URL: " + this.broker);
        }
        this.broker_host = url.getHost();
        UIMAFramework.getLogger().setLevel(Level.INFO);
        if (args == null) {
            this.meta_timeout = 5000;
            this.broker_jmx_port = 1099;
            this.queue_threshold = 0;
            this.window = 3;
        } else {
            String[] as = args.split(",");
            StringWriter sw = new StringWriter();
            for (String s : as) {
                sw.write(s + "\n");
            }
            StringReader sr = new StringReader(sw.toString());
            DuccProperties props = new DuccProperties();
            try {
                props.load((Reader)sr);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.meta_timeout = props.getIntProperty("meta_timeout", 5000);
            this.broker_jmx_port = props.getIntProperty("broker_jmx_port", 1099);
            this.queue_threshold = props.getIntProperty("queue_threshold", 0);
            this.window = props.getIntProperty("window", 3);
        }
        this.queueSizeWindow = new int[this.window];
        this.logger.debug("<ctr>", null, new Object[]{"INIT: meta_timeout", this.meta_timeout, "broker_jmx_port", this.broker_jmx_port, "queue_threshold", this.queue_threshold, "window", this.window});
        this.monitor = new UimaAsServiceMonitor(this.endpoint, this.broker_host, this.broker_jmx_port);
    }

    @Override
    public void stop() {
        if (this.monitor != null) {
            this.monitor.stop();
        }
    }

    private void doLog(String methodName, String msg) {
        if (this.logger == null) {
            System.out.println(msg);
        } else {
            this.logger.info(methodName, null, new Object[]{msg});
        }
    }

    void evaluateBrokerStatistics(IServiceStatistics stats) {
        String methodName = "evaluatePing";
        try {
            this.monitor.collect();
            if (this.queue_threshold > 0) {
                this.queueSizeWindow[this.queueCursor++ % this.window] = (int)this.monitor.getQueueSize();
                int sum = 0;
                for (int i = 0; i < this.window; ++i) {
                    sum += this.queueSizeWindow[i];
                }
                stats.setHealthy((sum /= this.window) < this.queue_threshold);
                this.logger.debug(methodName, null, new Object[]{"EVAL: Q depth", this.monitor.getQueueSize(), "window", sum, "health", stats.isHealthy()});
            } else {
                stats.setHealthy(true);
            }
        }
        catch (Throwable t) {
            stats.setHealthy(false);
            this.monitor.setJmxFailure(t.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IServiceStatistics getStatistics() {
        String methodName = "getStatistics";
        ServiceStatistics statistics = new ServiceStatistics(false, false, "<NA>");
        this.nodeIp = "N/A";
        this.pid = "N/A";
        this.evaluateBrokerStatistics(statistics);
        BaseUIMAAsynchronousEngine_impl uimaAsEngine = new BaseUIMAAsynchronousEngine_impl();
        UimaCbListener listener = new UimaCbListener();
        uimaAsEngine.addStatusCallbackListener((UimaAsBaseCallbackListener)listener);
        HashMap<String, Object> appCtx = new HashMap<String, Object>();
        appCtx.put("ServerURI", this.broker);
        appCtx.put("Endpoint", this.endpoint);
        appCtx.put("GetMetaTimeout", this.meta_timeout);
        try {
            uimaAsEngine.initialize(appCtx);
            statistics.setAlive(true);
            statistics.setHealthy(statistics.isHealthy());
            listener.ok();
        }
        catch (ResourceInitializationException e) {
            listener.timeout();
            this.doLog(methodName, "Cannot issue getMeta to: " + this.endpoint + ":" + this.broker);
            statistics.setHealthy(false);
            statistics.setAlive(false);
        }
        finally {
            try {
                uimaAsEngine.stop();
            }
            catch (Throwable e) {
                this.doLog(methodName, "Exception on UIMA-AS connection stop:" + e.toString());
            }
        }
        this.monitor.setSource(this.nodeIp, this.pid, this.gmfail);
        statistics.setInfo(this.monitor.format());
        return statistics;
    }

    class UimaCbListener
    extends UimaAsBaseCallbackListener {
        public void ok() {
            UimaAsPing.this.gmfail = false;
        }

        public void timeout() {
            String methodName = "UimaAsPing:get-meta";
            UimaAsPing.this.logger.info(methodName, null, new Object[]{"Get-Meta timeout from ", UimaAsPing.this.nodeIp, "PID", UimaAsPing.this.pid});
            UimaAsPing.this.gmfail = true;
        }

        public void onBeforeMessageSend(UimaASProcessStatus status) {
        }

        public void onBeforeProcessMeta(String IP, String p) {
            String methodName = "UimaAsPing:onBeforeProcessMeta";
            UimaAsPing.this.logger.info(methodName, null, new Object[]{"Get-Meta received from ", IP, ":", p, "for", UimaAsPing.this.ep});
            UimaAsPing.this.pid = p;
            UimaAsPing.this.nodeIp = IP;
        }

        public void initializationComplete(EntityProcessStatus aStatus) {
        }

        public void entityProcessComplete(CAS aCas, EntityProcessStatus aStatus) {
        }

        public void collectionProcessComplete(EntityProcessStatus aStatus) {
        }
    }
}

