/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.bnd;

import aQute.bnd.annotation.plugin.BndPlugin;
import aQute.bnd.header.Attrs;
import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Descriptors;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Resource;
import aQute.bnd.service.AnalyzerPlugin;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.resource.metadata.FsIndexCollection;
import org.apache.uima.resource.metadata.Import;
import org.apache.uima.resource.metadata.TypePriorities;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.XMLParser;
import org.apache.uima.util.XMLizable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BndPlugin(name="UIMA")
public class UimaBndPlugin
implements AnalyzerPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Pattern XML_FILE = Pattern.compile(".*\\.xml");
    private static final Pattern QN = Pattern.compile("[_A-Za-z$][_A-Za-z0-9$]*(\\.[_A-Za-z$][_A-Za-z0-9$]*)*");
    private static final XMLParser PARSER = UIMAFramework.getXMLParser();

    public boolean analyzeJar(Analyzer analyzer) throws Exception {
        Jar jar = analyzer.getJar();
        Map resources = jar.getResources();
        int importsProcessed = 0;
        if (resources != null) {
            for (Map.Entry entry : resources.entrySet()) {
                String path = (String)entry.getKey();
                Resource resource = (Resource)entry.getValue();
                try {
                    if (!XML_FILE.matcher(path).matches()) continue;
                    importsProcessed += this.analyzeXmlFile(analyzer, path, resource);
                }
                catch (Exception e) {
                    analyzer.error("Unexpected exception in processing resource (%s): %s", new Object[]{path, e});
                }
            }
        }
        LOG.info("UIMA bnd plugin processed {} imports", (Object)importsProcessed);
        return false;
    }

    private int analyzeXmlFile(Analyzer analyzer, String path, Resource resource) throws Exception {
        XMLizable desc = this.readUimaDescriptor(resource);
        if (desc == null) {
            return 0;
        }
        LOG.debug("Found {}: {}", (Object)desc.getClass().getSimpleName(), (Object)path);
        List<Import> imports = this.getImportsFromDescriptor(desc);
        int importsProcessed = 0;
        for (Import imp : imports) {
            if (imp.getName() != null) {
                this.handleImportByName(analyzer, path, imp);
                ++importsProcessed;
                continue;
            }
            if (imp.getLocation() != null) {
                this.handleImportByLocation(imp);
                continue;
            }
            LOG.warn("Found UIMA type system import without name and location - ignoring, please fix your type system description");
        }
        return importsProcessed;
    }

    private void handleImportByLocation(Import imp) {
        LOG.warn("Found UIMA type system import by location: {} - ignoring, please only use import-by-name", (Object)imp.getLocation());
    }

    private void handleImportByName(Analyzer analyzer, String path, Import imp) {
        String tsdPackage = imp.getName();
        int lastSeparatorPosition = tsdPackage.lastIndexOf(46);
        if (lastSeparatorPosition >= 0) {
            tsdPackage = tsdPackage.substring(0, lastSeparatorPosition);
        }
        LOG.debug("Found UIMA type system import by name: {}", (Object)tsdPackage);
        Descriptors.PackageRef pack = analyzer.getPackageRef(tsdPackage);
        if (!QN.matcher(pack.getFQN()).matches()) {
            analyzer.warning("Type system import does not seem to refer to a package (%s): %s", new Object[]{path, pack});
        }
        if (!analyzer.getReferred().containsKey(pack)) {
            Attrs attrs = new Attrs();
            analyzer.getReferred().put(pack, attrs);
        }
    }

    private List<Import> getImportsFromDescriptor(XMLizable desc) {
        if (desc instanceof TypeSystemDescription) {
            TypeSystemDescription tsd = (TypeSystemDescription)desc;
            return UimaBndPlugin.asList(tsd.getImports());
        }
        if (desc instanceof TypePriorities) {
            TypePriorities prio = (TypePriorities)desc;
            return UimaBndPlugin.asList(prio.getImports());
        }
        if (desc instanceof FsIndexCollection) {
            FsIndexCollection idxc = (FsIndexCollection)desc;
            return UimaBndPlugin.asList(idxc.getImports());
        }
        if (desc instanceof AnalysisEngineDescription) {
            AnalysisEngineDescription aed = (AnalysisEngineDescription)desc;
            ArrayList<Import> imports = new ArrayList<Import>();
            imports.addAll(this.getImportsFromDescriptor(aed.getAnalysisEngineMetaData().getTypeSystem()));
            imports.addAll(this.getImportsFromDescriptor(aed.getAnalysisEngineMetaData().getTypePriorities()));
            imports.addAll(this.getImportsFromDescriptor(aed.getAnalysisEngineMetaData().getFsIndexCollection()));
            return imports;
        }
        return Collections.emptyList();
    }

    private XMLizable readUimaDescriptor(Resource resource) throws Exception {
        XMLizable xMLizable;
        block8: {
            InputStream in = resource.openInputStream();
            try {
                xMLizable = PARSER.parse(new XMLInputSource(in));
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidXMLException invalidXMLException) {
                    return null;
                }
            }
            in.close();
        }
        return xMLizable;
    }

    private static <T> List<T> asList(T[] aList) {
        if (aList == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(aList);
    }
}

