/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.resource.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UIMA_IllegalStateException;
import org.apache.uima.analysis_engine.impl.PearAnalysisEngineWrapper;
import org.apache.uima.internal.util.Class_TCCL;
import org.apache.uima.internal.util.Misc;
import org.apache.uima.internal.util.UIMAClassLoader;
import org.apache.uima.resource.CasManager;
import org.apache.uima.resource.DataResource;
import org.apache.uima.resource.ExternalResourceDependency;
import org.apache.uima.resource.ExternalResourceDescription;
import org.apache.uima.resource.ParameterizedDataResource;
import org.apache.uima.resource.RelativePathResolver;
import org.apache.uima.resource.Resource;
import org.apache.uima.resource.ResourceAccessException;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.SharedResourceObject;
import org.apache.uima.resource.impl.CasManager_impl;
import org.apache.uima.resource.impl.DataResource_impl;
import org.apache.uima.resource.impl.FileResourceSpecifier_impl;
import org.apache.uima.resource.impl.RelativePathResolver_impl;
import org.apache.uima.resource.metadata.ExternalResourceBinding;
import org.apache.uima.resource.metadata.ResourceManagerConfiguration;
import org.apache.uima.util.Level;
import org.apache.uima.util.XMLizable;

public class ResourceManager_impl
implements ResourceManager {
    private static final AtomicInteger IMPORT_URL_CACHE_WARNING_THROTTLE = new AtomicInteger();
    protected static final String LOG_RESOURCE_BUNDLE = "org.apache.uima.impl.log_messages";
    protected static final Class<Resource> EMPTY_RESOURCE_CLASS = Resource.class;
    private static final URL[] emptyURLarray = new URL[0];
    private AtomicBoolean isDestroyed = new AtomicBoolean(false);
    private final Object casManagerMonitor = new Object();
    private final RelativePathResolver mRelativePathResolver;
    protected final Map<String, Object> mResourceMap;
    protected final Map<String, ResourceRegistration> mInternalResourceRegistrationMap;
    protected final Map<String, Class<?>> mParameterizedResourceImplClassMap;
    protected final Map<String, Class<?>> mInternalParameterizedResourceImplClassMap;
    protected final Map<List<Object>, Object> mParameterizedResourceInstanceMap;
    private volatile UIMAClassLoader uimaCL = null;
    protected volatile CasManager mCasManager = null;
    private Map<String, XMLizable> importCache = Collections.synchronizedMap(new HashMap());
    private Map<String, Set<String>> importUrlsCache = Collections.synchronizedMap(new HashMap());

    public ResourceManager_impl() {
        this.mResourceMap = Collections.synchronizedMap(new HashMap());
        this.mInternalResourceRegistrationMap = new ConcurrentHashMap<String, ResourceRegistration>();
        this.mParameterizedResourceImplClassMap = new ConcurrentHashMap();
        this.mInternalParameterizedResourceImplClassMap = new ConcurrentHashMap();
        this.mParameterizedResourceInstanceMap = new ConcurrentHashMap<List<Object>, Object>();
        this.mRelativePathResolver = new RelativePathResolver_impl();
    }

    public ResourceManager_impl(ClassLoader aClassLoader) {
        this.mResourceMap = Collections.synchronizedMap(new HashMap());
        this.mInternalResourceRegistrationMap = new ConcurrentHashMap<String, ResourceRegistration>();
        this.mParameterizedResourceImplClassMap = new ConcurrentHashMap();
        this.mInternalParameterizedResourceImplClassMap = new ConcurrentHashMap();
        this.mParameterizedResourceInstanceMap = new ConcurrentHashMap<List<Object>, Object>();
        this.mRelativePathResolver = new RelativePathResolver_impl(aClassLoader);
    }

    public ResourceManager_impl(Map<String, Object> resourceMap, Map<String, ResourceRegistration> internalResourceRegistrationMap, Map<String, Class<?>> parameterizedResourceImplClassMap, Map<String, Class<?>> internalParameterizedResourceImplClassMap, Map<List<Object>, Object> parameterizedResourceInstanceMap) {
        this.mResourceMap = resourceMap;
        this.mInternalResourceRegistrationMap = internalResourceRegistrationMap;
        this.mParameterizedResourceImplClassMap = parameterizedResourceImplClassMap;
        this.mInternalParameterizedResourceImplClassMap = internalParameterizedResourceImplClassMap;
        this.mParameterizedResourceInstanceMap = parameterizedResourceInstanceMap;
        this.mRelativePathResolver = new RelativePathResolver_impl();
    }

    public ResourceManager_impl copy() {
        ResourceManager_impl rm = new ResourceManager_impl(this.mResourceMap, this.mInternalResourceRegistrationMap, this.mParameterizedResourceImplClassMap, this.mInternalParameterizedResourceImplClassMap, this.mParameterizedResourceInstanceMap);
        rm.uimaCL = this.uimaCL;
        rm.importCache = this.importCache;
        rm.importUrlsCache = this.importUrlsCache;
        return rm;
    }

    public synchronized void setExtensionClassPath(UIMAClassLoader uimaCL, boolean resolveResource) {
        this.uimaCL = uimaCL;
        if (resolveResource) {
            this.getRelativePathResolver().setPathResolverClassLoader(uimaCL);
        }
    }

    @Override
    public synchronized void setExtensionClassPath(String classpath, boolean resolveResource) throws MalformedURLException {
        this.uimaCL = new UIMAClassLoader(classpath, Class_TCCL.get_parent_cl());
        if (resolveResource) {
            this.getRelativePathResolver().setPathResolverClassLoader(this.uimaCL);
        }
    }

    @Override
    public synchronized void setExtensionClassPath(ClassLoader parent, String classpath, boolean resolveResource) throws MalformedURLException {
        this.uimaCL = new UIMAClassLoader(classpath, parent);
        if (resolveResource) {
            this.getRelativePathResolver().setPathResolverClassLoader(this.uimaCL);
        }
    }

    public synchronized void setExtensionClassLoaderImpl(ClassLoader classLoader, boolean resolveResource) {
        UIMAClassLoader uIMAClassLoader = this.uimaCL = classLoader instanceof UIMAClassLoader ? (UIMAClassLoader)classLoader : new UIMAClassLoader(emptyURLarray, classLoader);
        if (resolveResource) {
            this.getRelativePathResolver().setPathResolverClassLoader(this.uimaCL);
        }
    }

    @Override
    public ClassLoader getExtensionClassLoader() {
        return this.uimaCL;
    }

    @Override
    @Deprecated(since="3.3.0")
    public String getDataPath() {
        return this.getRelativePathResolver().getDataPath();
    }

    @Override
    @Deprecated(since="3.6.0")
    public List<String> getDataPathElements() {
        return this.getRelativePathResolver().getDataPathElements();
    }

    @Override
    public List<URL> getDataPathUrls() {
        return this.getRelativePathResolver().getDataPathUrls();
    }

    @Override
    @Deprecated(since="3.6.0")
    public void setDataPath(String aPath) throws MalformedURLException {
        this.getRelativePathResolver().setDataPath(aPath);
    }

    @Override
    public void setDataPathElements(String ... aElements) throws MalformedURLException {
        this.getRelativePathResolver().setDataPathElements(aElements);
    }

    @Override
    public void setDataPathElements(File ... aElements) throws MalformedURLException {
        this.getRelativePathResolver().setDataPathElements(aElements);
    }

    @Override
    public void setDataPathUrls(URL ... aUrls) {
        this.getRelativePathResolver().setDataPathElements(aUrls);
    }

    @Override
    public URL resolveRelativePath(String aRelativePath) throws MalformedURLException {
        return this.getRelativePathResolver().resolveRelativePath(aRelativePath);
    }

    private void checkDestroyed() {
        if (this.isDestroyed.get()) {
            throw new IllegalStateException("ResourceManager is destroyed");
        }
    }

    @Override
    public Object getResource(String aName) throws ResourceAccessException {
        this.checkDestroyed();
        Object r = this.mResourceMap.get(aName);
        if (r instanceof ParameterizedDataResource) {
            throw new ResourceAccessException("parameters_required", new Object[]{aName});
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getResource(String aName, String[] aParams) throws ResourceAccessException {
        DataResource dr;
        this.checkDestroyed();
        Object r = this.mResourceMap.get(aName);
        if (r == null) {
            return null;
        }
        if (!(r instanceof ParameterizedDataResource)) {
            throw new ResourceAccessException("parameters_not_allowed", new Object[]{aName});
        }
        ParameterizedDataResource pdr = (ParameterizedDataResource)r;
        try {
            dr = pdr.getDataResource(aParams);
        }
        catch (ResourceInitializationException e) {
            throw new ResourceAccessException(e);
        }
        ArrayList<Object> nameAndResource = new ArrayList<Object>(2);
        nameAndResource.add(aName);
        nameAndResource.add(dr);
        Object resourceInstance = this.mParameterizedResourceInstanceMap.get(nameAndResource);
        if (resourceInstance != null) {
            return resourceInstance;
        }
        Map<List<Object>, Object> map = this.mParameterizedResourceInstanceMap;
        synchronized (map) {
            resourceInstance = this.mParameterizedResourceInstanceMap.get(nameAndResource);
            if (resourceInstance != null) {
                return resourceInstance;
            }
            Class<?> sharedResourceObjectClass = this.mParameterizedResourceImplClassMap.get(aName);
            if (sharedResourceObjectClass != EMPTY_RESOURCE_CLASS) {
                try {
                    SharedResourceObject sro = (SharedResourceObject)sharedResourceObjectClass.newInstance();
                    sro.load(dr);
                    this.mParameterizedResourceInstanceMap.put(nameAndResource, sro);
                    return sro;
                }
                catch (InstantiationException e) {
                    throw new ResourceAccessException(e);
                }
                catch (IllegalAccessException e) {
                    throw new ResourceAccessException(e);
                }
                catch (ResourceInitializationException e) {
                    throw new ResourceAccessException(e);
                }
            }
            this.mParameterizedResourceInstanceMap.put(nameAndResource, dr);
            return dr;
        }
    }

    public Class<?> getResourceClass(String aName) {
        this.checkDestroyed();
        Object r = this.mResourceMap.get(aName);
        if (r == null) {
            return null;
        }
        if (r instanceof ParameterizedDataResource) {
            Class<?> customResourceClass = this.mParameterizedResourceImplClassMap.get(aName);
            if (customResourceClass == EMPTY_RESOURCE_CLASS) {
                return DataResource_impl.class;
            }
            return customResourceClass;
        }
        return r.getClass();
    }

    @Override
    public InputStream getResourceAsStream(String aKey, String[] aParams) throws ResourceAccessException {
        return this.getResourceAsStreamCommon(this.getResource(aKey, aParams));
    }

    @Override
    public InputStream getResourceAsStream(String aKey) throws ResourceAccessException {
        return this.getResourceAsStreamCommon(this.getResource(aKey));
    }

    private InputStream getResourceAsStreamCommon(Object resource) throws ResourceAccessException {
        this.checkDestroyed();
        try {
            if (resource != null && resource instanceof DataResource) {
                return ((DataResource)resource).getInputStream();
            }
            return null;
        }
        catch (IOException e) {
            throw new ResourceAccessException(e);
        }
    }

    private URL getResourceAsStreamCommonUrl(Object resource) {
        if (resource != null && resource instanceof DataResource) {
            return ((DataResource)resource).getUrl();
        }
        return null;
    }

    @Override
    public URL getResourceURL(String aKey, String[] aParams) throws ResourceAccessException {
        return this.getResourceAsStreamCommonUrl(this.getResource(aKey, aParams));
    }

    @Override
    public URL getResourceURL(String aKey) throws ResourceAccessException {
        return this.getResourceAsStreamCommonUrl(this.getResource(aKey));
    }

    @Override
    public synchronized void initializeExternalResources(ResourceManagerConfiguration aConfiguration, String aQualifiedContextName, Map<String, Object> aAdditionalParams) throws ResourceInitializationException {
        ResourceRegistration registration;
        this.checkDestroyed();
        if (null == aAdditionalParams) {
            aAdditionalParams = new HashMap<String, Object>();
        }
        if (!aAdditionalParams.containsKey("RESOURCE_MANAGER")) {
            aAdditionalParams.put("RESOURCE_MANAGER", this);
        }
        ExternalResourceDescription[] resources = aConfiguration.getExternalResources();
        for (int i = 0; i < resources.length; ++i) {
            String name = resources[i].getName();
            registration = this.mInternalResourceRegistrationMap.get(name);
            if (registration == null) {
                this.registerResource(name, resources[i], aQualifiedContextName, aAdditionalParams);
                continue;
            }
            if (registration.description.equals(resources[i])) continue;
            if (aQualifiedContextName.startsWith(registration.definingContext)) {
                UIMAFramework.getLogger().logrb(Level.CONFIG, ResourceManager_impl.class.getName(), "initializeExternalResources", LOG_RESOURCE_BUNDLE, "UIMA_overridden_resource__CONFIG", new Object[]{name, aQualifiedContextName, registration.definingContext});
                continue;
            }
            UIMAFramework.getLogger().logrb(Level.WARNING, ResourceManager_impl.class.getName(), "initializeExternalResources", LOG_RESOURCE_BUNDLE, "UIMA_duplicate_resource_name__WARNING", new Object[]{name, registration.definingContext, aQualifiedContextName});
        }
        ExternalResourceBinding[] bindings = aConfiguration.getExternalResourceBindings();
        for (int i = 0; i < bindings.length; ++i) {
            registration = this.mInternalResourceRegistrationMap.get(bindings[i].getResourceName());
            if (registration == null) {
                throw new ResourceInitializationException("unknown_resource_name", new Object[]{bindings[i].getResourceName(), bindings[i].getSourceUrlString()});
            }
            this.mResourceMap.put(aQualifiedContextName + bindings[i].getKey(), registration.resource);
            Class<?> impl = this.mInternalParameterizedResourceImplClassMap.get(bindings[i].getResourceName());
            this.mParameterizedResourceImplClassMap.put(aQualifiedContextName + bindings[i].getKey(), impl == null ? EMPTY_RESOURCE_CLASS : impl);
        }
    }

    @Override
    public synchronized void resolveAndValidateResourceDependencies(ExternalResourceDependency[] aDependencies, String aQualifiedContextName) throws ResourceInitializationException {
        this.checkDestroyed();
        for (int i = 0; i < aDependencies.length; ++i) {
            String qname = aQualifiedContextName + aDependencies[i].getKey();
            Object resourceImpl = this.mResourceMap.get(qname);
            if (resourceImpl == null) {
                String relativeUrl = aDependencies[i].getKey();
                URL absUrl = this.getRelativePathResolver().resolveRelativePath(relativeUrl);
                if (absUrl != null) {
                    FileResourceSpecifier_impl spec = new FileResourceSpecifier_impl();
                    spec.setFileUrl(absUrl.toString());
                    resourceImpl = UIMAFramework.produceResource(spec, null);
                    this.mResourceMap.put(qname, resourceImpl);
                }
            }
            if (resourceImpl == null) {
                if (aDependencies[i].isOptional()) continue;
                throw new ResourceInitializationException("resource_dependency_not_satisfied", new Object[]{aDependencies[i].getKey(), aDependencies[i].getSourceUrlString()});
            }
            try {
                Class<?> resourceClass;
                Class theInterface;
                String name = aDependencies[i].getInterfaceName();
                if (name == null || name.length() <= 0 || (theInterface = this.loadUserClass(name)).isAssignableFrom(resourceClass = this.getResourceClass(qname))) continue;
                throw new ResourceInitializationException("resource_does_not_implement_interface", new Object[]{qname, aDependencies[i].getInterfaceName(), aDependencies[i].getSourceUrlString()});
            }
            catch (ClassNotFoundException e) {
                throw new ResourceInitializationException("class_not_found", new Object[]{aDependencies[i].getInterfaceName(), aDependencies[i].getSourceUrlString()});
            }
        }
    }

    private void registerResource(String aName, ExternalResourceDescription aResourceDescription, String aDefiningContext, Map<String, Object> aResourceInitParams) throws ResourceInitializationException {
        HashMap<String, Object> initParams = aResourceInitParams == null ? new HashMap<String, Object>() : new HashMap<String, Object>(aResourceInitParams);
        initParams.put("RELATIVE_PATH_RESOLVER", this.getRelativePathResolver());
        boolean verificationMode = initParams.containsKey("VERIFICATION_MODE");
        Resource r = UIMAFramework.produceResource(aResourceDescription.getResourceSpecifier(), initParams);
        String implementationName = aResourceDescription.getImplementationName();
        Class implClass = null;
        Object implInstance = r;
        if (implementationName != null && implementationName.length() > 0) {
            try {
                implClass = this.loadUserClass(implementationName);
            }
            catch (ClassNotFoundException e) {
                throw new ResourceInitializationException("class_not_found", new Object[]{implementationName, aResourceDescription.getSourceUrlString()}, e);
            }
            if (!SharedResourceObject.class.isAssignableFrom(implClass)) {
                throw new ResourceInitializationException("not_a_shared_resource_object", new Object[]{implementationName, aResourceDescription.getSourceUrlString()});
            }
        }
        if (r instanceof DataResource) {
            if (implClass != null) {
                try {
                    SharedResourceObject sro = (SharedResourceObject)implClass.newInstance();
                    if (!verificationMode) {
                        sro.load((DataResource)r);
                    }
                    implInstance = sro;
                }
                catch (InstantiationException e) {
                    throw new ResourceInitializationException("could_not_instantiate", new Object[]{implClass.getName(), aResourceDescription.getSourceUrlString()}, e);
                }
                catch (IllegalAccessException e) {
                    throw new ResourceInitializationException("could_not_instantiate", new Object[]{implClass.getName(), aResourceDescription.getSourceUrlString()}, e);
                }
            }
        } else if (r instanceof ParameterizedDataResource) {
            this.mInternalParameterizedResourceImplClassMap.put(aName, null == implClass ? EMPTY_RESOURCE_CLASS : implClass);
        } else if (implClass != null) {
            throw new ResourceInitializationException("not_a_data_resource", new Object[]{implClass.getName(), aName, r.getClass().getName(), aResourceDescription.getSourceUrlString()});
        }
        ResourceRegistration registration = new ResourceRegistration(implInstance, aResourceDescription, aDefiningContext);
        this.mInternalResourceRegistrationMap.put(aName, registration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CasManager getCasManager() {
        if (this.mCasManager != null) {
            return this.mCasManager;
        }
        Object object = this.casManagerMonitor;
        synchronized (object) {
            if (this.mCasManager == null) {
                this.mCasManager = new CasManager_impl(this);
            }
            return this.mCasManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCasManager(CasManager aCasManager) {
        Object object = this.casManagerMonitor;
        synchronized (object) {
            if (this.mCasManager != null) {
                throw new UIMA_IllegalStateException("cannot_set_cas_manager", new Object[0]);
            }
            this.mCasManager = aCasManager;
        }
    }

    protected RelativePathResolver getRelativePathResolver() {
        return this.mRelativePathResolver;
    }

    @Override
    @Deprecated(since="3.3.0")
    public Map<String, XMLizable> getImportCache() {
        return this.importCache;
    }

    @Deprecated(since="3.3.0")
    public Map<String, Set<String>> getImportUrlsCache() {
        Misc.decreasingWithTrace(IMPORT_URL_CACHE_WARNING_THROTTLE, "ResourceManager_impl.getImportUrlsCache() should not be called. It is no longer filled during import resolving. The method will be removed in a future UIMA version.", UIMAFramework.getLogger());
        return this.importUrlsCache;
    }

    @Override
    public <N> Class<N> loadUserClass(String name) throws ClassNotFoundException {
        return Class_TCCL.forName(name, this, true);
    }

    public static Class<?> loadUserClass(String name, ResourceManager rm) throws ClassNotFoundException {
        return Class_TCCL.forName(name, rm, true);
    }

    public static Class<?> loadUserClassOrThrow(String name, ResourceManager rm, ResourceSpecifier aSpecifier) throws ResourceInitializationException {
        try {
            return Class_TCCL.forName(name, rm, true);
        }
        catch (ClassNotFoundException e) {
            throw new ResourceInitializationException("class_not_found", new Object[]{name, aSpecifier.getSourceUrlString()}, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Map<ResourceManager, Map<PearAnalysisEngineWrapper.StringPair, ResourceManager>> cachedResourceManagers;
        boolean alreadyDestroyed = this.isDestroyed.getAndSet(true);
        if (alreadyDestroyed) {
            return;
        }
        for (ResourceRegistration rr : this.mInternalResourceRegistrationMap.values()) {
            if (!(rr.resource instanceof Resource)) continue;
            ((Resource)rr.resource).destroy();
        }
        for (Object r : this.mParameterizedResourceInstanceMap.values()) {
            if (!(r instanceof Resource)) continue;
            ((Resource)r).destroy();
        }
        if (this.uimaCL != null) {
            try {
                this.uimaCL.close();
            }
            catch (IOException e) {
                UIMAFramework.getLogger().logrb(Level.WARNING, ResourceManager_impl.class.getName(), "destroy", LOG_RESOURCE_BUNDLE, "UIMA_Classloader_close_exception", e);
            }
        }
        Map<ResourceManager, Map<PearAnalysisEngineWrapper.StringPair, ResourceManager>> map = cachedResourceManagers = PearAnalysisEngineWrapper.getCachedResourceManagers();
        synchronized (map) {
            Map<PearAnalysisEngineWrapper.StringPair, ResourceManager> c1 = cachedResourceManagers.get(this);
            if (c1 != null) {
                for (ResourceManager rm : c1.values()) {
                    rm.destroy();
                }
            }
        }
    }

    @Override
    public List<Object> getExternalResources() {
        ArrayList<Object> rs = new ArrayList<Object>();
        for (ResourceRegistration resourceRegistration : this.mInternalResourceRegistrationMap.values()) {
            if (resourceRegistration instanceof ParameterizedDataResource) continue;
            rs.add(resourceRegistration.resource);
        }
        for (Object object : this.mParameterizedResourceInstanceMap.values()) {
            rs.add(object);
        }
        return rs;
    }

    protected static class ResourceRegistration {
        Object resource;
        ExternalResourceDescription description;
        String definingContext;

        public ResourceRegistration(Object aResource, ExternalResourceDescription aDescription, String aDefiningContext) {
            this.resource = aResource;
            this.description = aDescription;
            this.definingContext = aDefiningContext;
        }
    }
}

