/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.jcasgen.maven;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.uima.UIMAFramework;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.metadata.Import;
import org.apache.uima.resource.metadata.TypeDescription;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.resource.metadata.impl.Import_impl;
import org.apache.uima.resource.metadata.impl.TypeSystemDescription_impl;
import org.apache.uima.tools.jcasgen.IError;
import org.apache.uima.tools.jcasgen.IProgressMonitor;
import org.apache.uima.tools.jcasgen.Jg;
import org.apache.uima.util.InvalidXMLException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.IOUtil;
import org.sonatype.plexus.build.incremental.BuildContext;
import org.xml.sax.SAXException;

@Mojo(name="generate", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class JCasGenMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Component
    private BuildContext buildContext;
    @Parameter(required=true)
    private String[] typeSystemIncludes;
    @Parameter(required=false)
    private String[] typeSystemExcludes;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/jcasgen", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="false", required=true)
    private boolean limitToProject;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        File typeSystemFile;
        String descriptorLocation;
        List elements;
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
            this.buildContext.refresh(this.outputDirectory);
        }
        this.project.addCompileSourceRoot(this.outputDirectory.getPath());
        StringBuilder classpathBuilder = new StringBuilder();
        for (String element : this.project.getCompileSourceRoots()) {
            if (classpathBuilder.length() > 0) {
                classpathBuilder.append(File.pathSeparatorChar);
            }
            classpathBuilder.append(element);
            this.getLog().debug((CharSequence)("JCasGen: Adding source root to classpath '" + element + "'"));
        }
        for (String element : this.project.getResources()) {
            if (classpathBuilder.length() > 0) {
                classpathBuilder.append(File.pathSeparatorChar);
            }
            classpathBuilder.append(element.getDirectory());
            this.getLog().debug((CharSequence)("JCasGen: Adding resource root to classpath '" + element.getDirectory() + "'"));
        }
        try {
            elements = this.project.getCompileClasspathElements();
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        for (String element : elements) {
            if (classpathBuilder.length() > 0) {
                classpathBuilder.append(File.pathSeparatorChar);
            }
            classpathBuilder.append(element);
            this.getLog().debug((CharSequence)("JCasGen: Adding dependency to classpath '" + element + "'"));
        }
        String classpath = classpathBuilder.toString();
        DirectoryScanner ds = new DirectoryScanner();
        ds.setIncludes(this.typeSystemIncludes);
        ds.setExcludes(this.typeSystemExcludes);
        ds.setBasedir(this.project.getBasedir());
        ds.setCaseSensitive(true);
        this.getLog().debug((CharSequence)("JCasGen: Scanning for descriptors in '" + String.valueOf(ds.getBasedir()) + "'"));
        ds.scan();
        TypeSystemDescription_impl typeSystem = new TypeSystemDescription_impl();
        ArrayList<Import_impl> imports = new ArrayList<Import_impl>();
        boolean contextDelta = false;
        String[] stringArray = ds.getIncludedFiles();
        int n = stringArray.length;
        for (int i = 0; i < n; contextDelta |= this.buildContext.hasDelta(new File(ds.getBasedir(), descriptorLocation)), ++i) {
            URL url;
            descriptorLocation = stringArray[i];
            File descriptorFile = new File(ds.getBasedir(), descriptorLocation);
            this.getLog().info((CharSequence)("JCasGen: Found descriptor '" + descriptorFile.getAbsolutePath() + "'"));
            Import_impl imp = new Import_impl();
            try {
                url = descriptorFile.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            imp.setLocation(url.toString());
            imports.add(imp);
        }
        Import[] importArray = new Import[imports.size()];
        typeSystem.setImports(imports.toArray(importArray));
        FileOutputStream typeSystemOs = null;
        try {
            typeSystemFile = new File(this.project.getBuild().getDirectory(), "jcasgen/typesystem.xml");
            this.getLog().debug((CharSequence)("JCasGen: Writing master descriptor to in '" + String.valueOf(typeSystemFile) + "'"));
            typeSystemFile.getParentFile().mkdirs();
            typeSystemOs = new FileOutputStream(typeSystemFile);
            typeSystem.toXML((OutputStream)typeSystemOs);
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException(e.getMessage(), e.getCause());
                catch (SAXException e2) {
                    throw new MojoExecutionException(e2.getMessage(), e2.getCause());
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(typeSystemOs);
                throw throwable;
            }
        }
        IOUtil.close((OutputStream)typeSystemOs);
        if (!contextDelta && !this.hasDelta((TypeSystemDescription)typeSystem, classpath)) {
            this.getLog().info((CharSequence)"JCasGen: Skipped, since no type system changes were detected");
            return;
        }
        ArrayList<String> args = new ArrayList<String>();
        if (this.limitToProject) {
            File limitToDirectory = this.project.getBasedir().getAbsoluteFile();
            this.getLog().info((CharSequence)("JCasGen: Limiting generation to descriptors in '" + String.valueOf(limitToDirectory) + "'"));
            args.addAll(Arrays.asList("-limitToDirectory", limitToDirectory.toString()));
        }
        args.addAll(Arrays.asList("-jcasgeninput", typeSystemFile.getAbsolutePath(), "-jcasgenoutput", this.outputDirectory.getAbsolutePath(), "-jcasgenclasspath", classpath));
        Jg jCasGen = new Jg();
        try {
            jCasGen.main0(args.toArray(new String[args.size()]), null, (IProgressMonitor)new JCasGenProgressMonitor(), (IError)new JCasGenErrors());
        }
        catch (JCasGenException e) {
            throw new MojoExecutionException(e.getMessage(), e.getCause());
        }
        this.buildContext.refresh(this.outputDirectory);
    }

    private boolean hasDelta(TypeSystemDescription typeSystemDescription, String classpath) {
        try {
            ResourceManager resourceManager = UIMAFramework.newDefaultResourceManager();
            resourceManager.setExtensionClassPath(classpath, true);
            typeSystemDescription.resolveImports(resourceManager);
        }
        catch (InvalidXMLException e) {
            return false;
        }
        catch (MalformedURLException e) {
            return false;
        }
        File buildOutputDirectory = new File(this.project.getBuild().getOutputDirectory());
        HashMap<File, File> targetToSource = new HashMap<File, File>();
        for (Resource resource : this.project.getResources()) {
            File resourceDir = new File(resource.getDirectory());
            if (!resourceDir.exists()) continue;
            List<String> includes = resource.getIncludes();
            if (includes.isEmpty()) {
                includes = Arrays.asList("**");
            }
            List excludes = resource.getExcludes();
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(resourceDir);
            scanner.setIncludes(includes.toArray(new String[includes.size()]));
            scanner.setExcludes(excludes.toArray(new String[excludes.size()]));
            scanner.scan();
            String targetPath = resource.getTargetPath();
            for (String filePath : scanner.getIncludedFiles()) {
                File sourceFile = new File(resourceDir, filePath);
                File baseDirectory = targetPath != null ? new File(buildOutputDirectory, targetPath) : buildOutputDirectory;
                File targetFile = new File(baseDirectory, filePath);
                targetToSource.put(targetFile, sourceFile);
            }
        }
        for (TypeDescription type : typeSystemDescription.getTypes()) {
            File targetFile;
            URL typeSystemURL = type.getSourceUrl();
            if (typeSystemURL == null) continue;
            try {
                targetFile = new File(typeSystemURL.toURI());
            }
            catch (URISyntaxException e) {
                continue;
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            File sourceFile = (File)targetToSource.get(targetFile);
            if (sourceFile == null) continue;
            if (this.buildContext.hasDelta(sourceFile)) {
                this.getLog().info((CharSequence)("Type system file " + String.valueOf(sourceFile) + " has changed"));
                return true;
            }
            if (!targetFile.getAbsolutePath().startsWith(this.project.getBasedir().getAbsolutePath()) || !this.buildContext.hasDelta(targetFile)) continue;
            this.getLog().info((CharSequence)("Type system file " + String.valueOf(sourceFile) + " has changed"));
            return true;
        }
        return false;
    }

    private class JCasGenProgressMonitor
    implements IProgressMonitor {
        public void done() {
        }

        public void beginTask(String name, int totalWorked) {
        }

        public void subTask(String message) {
            JCasGenMojo.this.getLog().info((CharSequence)("JCasGen: " + message));
        }

        public void worked(int work) {
        }
    }

    private class JCasGenErrors
    implements IError {
        public void newError(int severity, String message, Exception exception) {
            String fullMessage = "JCasGen: " + message;
            if (severity == 0) {
                JCasGenMojo.this.getLog().info((CharSequence)fullMessage, (Throwable)exception);
            } else if (severity == 1) {
                JCasGenMojo.this.getLog().warn((CharSequence)fullMessage, (Throwable)exception);
            } else {
                if (severity == 2) {
                    String m = fullMessage;
                    if (exception != null) {
                        m = m + "\nException: " + exception.getMessage();
                    }
                    throw new JCasGenException(m, exception);
                }
                throw new UnsupportedOperationException("Unknown severity level: " + severity);
            }
        }
    }

    private static class JCasGenException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public JCasGenException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

