/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vinci.transport.document;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.vinci.debug.Debug;
import org.apache.vinci.transport.Attributes;
import org.apache.vinci.transport.FrameComponent;
import org.apache.vinci.transport.FrameLeaf;
import org.apache.vinci.transport.ServiceException;
import org.apache.vinci.transport.Transportable;
import org.apache.vinci.transport.VinciFrame;
import org.apache.vinci.transport.document.AFrame;
import org.apache.vinci.transport.document.AFrameLeaf;
import org.apache.vinci.transport.util.TransportableConverter;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XMLToVinci {
    private XMLToVinci() {
    }

    public static Transportable xmlToTransportable(Reader r, Transportable empty) throws ServiceException {
        TransportableConverter.convert((Transportable)XMLToVinci.xmlToAFrame(r), empty);
        return empty;
    }

    public static VinciFrame xmlToVinciFrame(Reader r) throws ServiceException {
        XMLReader xr;
        try {
            xr = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
        }
        catch (SAXException e) {
            throw new ServiceException("Error creating SAX Parser: " + e);
        }
        catch (ParserConfigurationException e) {
            throw new ServiceException("Error creating SAX Parser: " + e);
        }
        try {
            xr.setFeature("http://xml.org/sax/features/namespaces", false);
            VinciFrameHandler handler = new VinciFrameHandler();
            xr.setContentHandler(handler);
            xr.setErrorHandler(handler);
            xr.parse(new InputSource(r));
            return (VinciFrame)handler.top.component;
        }
        catch (IOException e) {
            Debug.reportException(e);
            throw new ServiceException("Reader IO error: " + e);
        }
        catch (SAXException e) {
            Debug.reportException(e);
            throw new ServiceException("XML Parse error: " + e);
        }
    }

    public static AFrame xmlToAFrame(Reader r) throws ServiceException {
        XMLReader xr;
        try {
            xr = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
        }
        catch (SAXException e) {
            throw new ServiceException("Error creating SAX Parser: " + e);
        }
        catch (ParserConfigurationException e) {
            throw new ServiceException("Error creating SAX Parser: " + e);
        }
        try {
            xr.setFeature("http://xml.org/sax/features/namespaces", false);
            AFrameHandler handler = new AFrameHandler();
            xr.setContentHandler(handler);
            xr.setErrorHandler(handler);
            xr.parse(new InputSource(r));
            return (AFrame)handler.top.component;
        }
        catch (IOException e) {
            Debug.reportException(e);
            throw new ServiceException("Reader IO error: " + e);
        }
        catch (SAXException e) {
            Debug.reportException(e);
            throw new ServiceException("XML Parse error: " + e);
        }
    }

    private static class AFrameHandler
    extends VinciFrameHandler {
        AFrameHandler() {
        }

        public void startElement(String uri, String name, String qName, org.xml.sax.Attributes a) {
            AStackEntry entry = new AStackEntry();
            entry.ename_or_pcdata = qName;
            if (a.getLength() > 0) {
                Attributes frame_attributes = new Attributes();
                for (int i = 0; i < a.getLength(); ++i) {
                    frame_attributes.fadd(a.getQName(i), a.getValue(i));
                }
                entry.attributes = frame_attributes;
            }
            entry.sub_entries = new ArrayList(2);
            if (this.top == null) {
                this.top = entry;
            } else {
                this.top.sub_entries.add(entry);
                entry.parent = this.top;
                this.top = entry;
            }
        }

        public void endElement(String uri, String name, String qName) {
            if (this.top.sub_entries.size() == 0) {
                AFrame c = new AFrame();
                this.top.component = c;
            } else {
                StackEntry child = (StackEntry)this.top.sub_entries.get(0);
                if (this.top.sub_entries.size() == 1 && child.sub_entries == null) {
                    AFrameLeaf l = new AFrameLeaf(child.ename_or_pcdata);
                    this.top.component = l;
                } else {
                    AFrame c = new AFrame();
                    this.top.component = c;
                    for (int i = 0; i < this.top.sub_entries.size(); ++i) {
                        child = (StackEntry)this.top.sub_entries.get(i);
                        if (child.component != null) {
                            c.add(child.ename_or_pcdata, child.component);
                        } else {
                            c.fadd("", child.ename_or_pcdata);
                        }
                        child.sub_entries = null;
                    }
                }
            }
            Attributes a = ((AStackEntry)this.top).attributes;
            if (a != null) {
                this.top.component.setAttributes(a);
            }
            if (this.top.parent != null) {
                this.top = this.top.parent;
            }
        }
    }

    private static class VinciFrameHandler
    extends DefaultHandler {
        protected StackEntry top = null;

        private VinciFrameHandler() {
        }

        public void startElement(String uri, String name, String qName, org.xml.sax.Attributes atts) {
            StackEntry entry = new StackEntry();
            entry.ename_or_pcdata = qName;
            entry.sub_entries = new ArrayList(2);
            if (this.top == null) {
                this.top = entry;
            } else {
                this.top.sub_entries.add(entry);
                entry.parent = this.top;
                this.top = entry;
            }
        }

        public void endElement(String uri, String name, String qName) {
            if (this.top.sub_entries.size() == 0) {
                this.top.component = new VinciFrame();
            } else {
                StackEntry child = (StackEntry)this.top.sub_entries.get(0);
                if (this.top.sub_entries.size() == 1 && child.sub_entries == null) {
                    this.top.component = new FrameLeaf(child.ename_or_pcdata);
                } else {
                    VinciFrame c = new VinciFrame();
                    this.top.component = c;
                    for (int i = 0; i < this.top.sub_entries.size(); ++i) {
                        child = (StackEntry)this.top.sub_entries.get(i);
                        if (child.component != null) {
                            c.add(child.ename_or_pcdata, child.component);
                        } else {
                            c.fadd("", child.ename_or_pcdata);
                        }
                        child.sub_entries = null;
                    }
                }
            }
            if (this.top.parent != null) {
                this.top = this.top.parent;
            }
        }

        public void characters(char[] ch, int start, int length) {
            StackEntry entry;
            if (this.top.sub_entries.size() != 0) {
                entry = (StackEntry)this.top.sub_entries.get(this.top.sub_entries.size() - 1);
                if (entry.sub_entries == null) {
                    entry.ename_or_pcdata = entry.ename_or_pcdata + new String(ch, start, length);
                    return;
                }
            }
            entry = new StackEntry();
            this.top.sub_entries.add(entry);
            entry.ename_or_pcdata = new String(ch, start, length);
        }
    }

    private static class AStackEntry
    extends StackEntry {
        Attributes attributes = null;

        private AStackEntry() {
        }
    }

    private static class StackEntry {
        List sub_entries = null;
        StackEntry parent = null;
        String ename_or_pcdata;
        FrameComponent component = null;

        private StackEntry() {
        }
    }
}

