/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.pear.tools;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.uima.UIMAFramework;
import org.apache.uima.pear.tools.PackageCreator;
import org.apache.uima.pear.tools.PackageCreatorException;
import org.apache.uima.util.Level;

@Mojo(name="package", defaultPhase=LifecyclePhase.PACKAGE)
public class PearPackagingMojo
extends AbstractMojo {
    @Parameter(defaultValue="${basedir}", property="basedir", required=true)
    private String mainComponentDir = null;
    @Parameter(defaultValue="${pear.classpath}", property="pear.classpath")
    private String classpath = null;
    @Parameter(defaultValue="${pear.mainComponentDesc}", property="pear.mainComponentDesc", required=true)
    private String mainComponentDesc = null;
    @Parameter(defaultValue="${pear.componentId}", property="pear.componentId", required=true)
    private String componentId = null;
    @Parameter(defaultValue="${basedir}/target", required=true)
    private String targetDir = null;
    @Parameter(defaultValue="$main_root/resources")
    private String datapath = null;
    @Parameter
    private Properties props = null;
    @Component
    private MavenProject project;
    private File pearPackagingDir;
    private ArrayList<String> classpathsInOrder;
    private Set<String> classpathsDefined;
    private Log log;

    public void execute() throws MojoExecutionException {
        this.pearPackagingDir = new File(this.targetDir, "pearPackaging");
        Level level = this.getCurrentUIMALogLevel();
        UIMAFramework.getLogger().setLevel(Level.WARNING);
        File finalPearFileName = new File(this.targetDir, this.componentId + ".pear");
        this.log = this.getLog();
        this.log.info((CharSequence)("Start building PEAR package for component " + this.componentId));
        this.log.debug((CharSequence)"UIMA PEAR INFORMATION ");
        this.log.debug((CharSequence)"======================");
        this.log.debug((CharSequence)("main component dir:   " + this.mainComponentDir));
        this.log.debug((CharSequence)("main component desc:  " + this.mainComponentDesc));
        this.log.debug((CharSequence)("component id:         " + this.componentId));
        this.log.debug((CharSequence)("classpath:            " + this.classpath));
        this.log.debug((CharSequence)("datapath:             " + this.datapath));
        this.log.debug((CharSequence)("target dir:           " + this.targetDir));
        this.log.debug((CharSequence)("pear packaging dir:   " + this.pearPackagingDir.getAbsolutePath()));
        this.log.debug((CharSequence)("final PEAR file:      " + finalPearFileName.getAbsolutePath()));
        if (!this.project.getPackaging().equals("jar")) {
            throw new MojoExecutionException("Wrong packaging type, only 'jar' packaging is supported");
        }
        try {
            FileFilter jarFilter;
            File[] jars;
            File libDir;
            this.copyPearData();
            String jarFileName = this.project.getBuild().getFinalName() + ".jar";
            File finalJarFile = new File(this.project.getBuild().getDirectory(), jarFileName);
            if (!finalJarFile.exists()) {
                String errorMessage = "Jar package " + finalJarFile.getAbsolutePath() + " not found";
                this.log.debug((CharSequence)errorMessage);
                throw new IOException(errorMessage);
            }
            File target = new File(this.pearPackagingDir, "lib");
            File targetFile = new File(target, jarFileName);
            FileUtils.copyFile((File)finalJarFile, (File)targetFile);
            this.classpathsInOrder = new ArrayList();
            this.classpathsDefined = new HashSet<String>();
            String pathToLib = String.format("$main_root/%s", "lib");
            this.log.debug((CharSequence)("pear pathToLib = " + pathToLib));
            String mainJar = String.format("%s/%s.jar", pathToLib, this.project.getBuild().getFinalName());
            this.maybeAddClasspath(mainJar);
            if (this.classpath != null && !this.classpath.equals("")) {
                String[] userClasspath;
                if (this.classpath.indexOf(58) != -1) {
                    throw new MojoExecutionException("classpath: " + this.classpath + " must use semicolons as separators.");
                }
                for (String ucp : userClasspath = this.classpath.split(";")) {
                    this.maybeAddClasspath(ucp);
                }
            }
            if ((libDir = new File(this.pearPackagingDir, "lib")).isDirectory() && null != (jars = libDir.listFiles(jarFilter = new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isFile() && pathname.getAbsolutePath().toLowerCase().endsWith(".jar");
                }
            }))) {
                for (File jar : jars) {
                    this.maybeAddClasspath(String.format("%s/%s", pathToLib, jar.getName()));
                }
            }
            StringBuffer buffer = new StringBuffer();
            for (String cp : this.classpathsInOrder) {
                buffer.append(cp).append(";");
            }
            this.classpath = buffer.substring(0, buffer.length() - 1);
            this.createPear();
            this.log.info((CharSequence)("PEAR package for component " + this.componentId + " successfully created at: " + finalPearFileName.getAbsolutePath()));
            UIMAFramework.getLogger().setLevel(level);
        }
        catch (PackageCreatorException e) {
            this.log.debug((CharSequence)e.getMessage());
            throw new MojoExecutionException(e.getMessage());
        }
        catch (IOException e) {
            this.log.debug((CharSequence)e.getMessage());
            throw new MojoExecutionException(e.getMessage());
        }
    }

    private void maybeAddClasspath(String acp) {
        this.log.debug((CharSequence)("pear maybe add classpath: " + acp));
        if (!this.classpathsDefined.contains(acp)) {
            this.classpathsInOrder.add(acp);
            this.classpathsDefined.add(acp);
        } else {
            this.log.debug((CharSequence)"pear maybe add classpath: duplicate found");
        }
    }

    private Level getCurrentUIMALogLevel() {
        if (UIMAFramework.getLogger().isLoggable(Level.ALL)) {
            return Level.ALL;
        }
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            return Level.FINEST;
        }
        if (UIMAFramework.getLogger().isLoggable(Level.FINER)) {
            return Level.FINER;
        }
        if (UIMAFramework.getLogger().isLoggable(Level.FINE)) {
            return Level.FINE;
        }
        if (UIMAFramework.getLogger().isLoggable(Level.CONFIG)) {
            return Level.CONFIG;
        }
        if (UIMAFramework.getLogger().isLoggable(Level.INFO)) {
            return Level.INFO;
        }
        if (UIMAFramework.getLogger().isLoggable(Level.WARNING)) {
            return Level.WARNING;
        }
        if (UIMAFramework.getLogger().isLoggable(Level.SEVERE)) {
            return Level.SEVERE;
        }
        return Level.OFF;
    }

    private void copyDirIfAvailable(String directory) throws IOException {
        File dirToCopy = new File(this.mainComponentDir, directory);
        if (dirToCopy.exists()) {
            File target = new File(this.pearPackagingDir, directory);
            FileUtils.copyDirectory((File)dirToCopy, (File)target);
            this.removeDotDirectories(target);
        }
    }

    private void removeDotDirectories(File dir) throws IOException {
        ArrayList subdirs = org.apache.uima.util.FileUtils.getSubDirs((File)dir);
        for (int i = 0; i < subdirs.size(); ++i) {
            File current = (File)subdirs.get(i);
            if (current.getName().startsWith(".")) {
                org.apache.uima.util.FileUtils.deleteRecursive((File)current);
                continue;
            }
            this.removeDotDirectories(current);
        }
    }

    private void copyPearData() throws IOException {
        String[] dirsToCopy = new String[]{"conf", "data", "desc", "doc", "lib", "metadata", "resources", "bin"};
        for (int i = 0; i < dirsToCopy.length; ++i) {
            this.copyDirIfAvailable(dirsToCopy[i]);
        }
    }

    private void createPear() throws PackageCreatorException {
        PackageCreator.generatePearPackage((String)this.componentId, (String)this.mainComponentDesc, (String)this.classpath, (String)this.datapath, (String)this.pearPackagingDir.getAbsolutePath(), (String)this.targetDir, (Properties)this.props);
    }
}

