/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.web.javascript;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.extensibility.ServiceDeclaration;
import org.apache.tuscany.sca.extensibility.ServiceDiscovery;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.MonitorFactory;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.monitor.impl.ProblemImpl;
import org.apache.tuscany.sca.web.javascript.JavascriptProxyFactory;
import org.apache.tuscany.sca.web.javascript.JavascriptProxyFactoryExtensionPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultJavascriptProxyFactoryExtensionPoint
implements JavascriptProxyFactoryExtensionPoint {
    private final Map<QName, JavascriptProxyFactory> factoriesByQName = new HashMap<QName, JavascriptProxyFactory>();
    private final Map<Class<?>, JavascriptProxyFactory> factoriesByType = new HashMap();
    private Monitor monitor = null;
    private boolean loaded = false;

    public DefaultJavascriptProxyFactoryExtensionPoint(ExtensionPointRegistry extensionPoints) {
        UtilityExtensionPoint utilities = (UtilityExtensionPoint)extensionPoints.getExtensionPoint(UtilityExtensionPoint.class);
        MonitorFactory monitorFactory = (MonitorFactory)utilities.getUtility(MonitorFactory.class);
        if (monitorFactory != null) {
            this.monitor = monitorFactory.createMonitor();
        }
    }

    private void error(String message, Object model, Exception ex) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "web-javascript-validation-messages", Problem.Severity.ERROR, model, message, ex);
            this.monitor.problem((Problem)problem);
        }
    }

    @Override
    public void addProxyFactory(JavascriptProxyFactory javascriptProxyfactory) {
        if (javascriptProxyfactory.getModelType() != null) {
            this.factoriesByType.put(javascriptProxyfactory.getModelType(), javascriptProxyfactory);
        }
        if (javascriptProxyfactory.getQName() != null) {
            this.factoriesByQName.put(javascriptProxyfactory.getQName(), javascriptProxyfactory);
        }
    }

    @Override
    public void removeProxyFactory(JavascriptProxyFactory javascriptProxyfactory) {
        if (javascriptProxyfactory.getModelType() != null) {
            this.factoriesByType.remove(javascriptProxyfactory.getModelType());
        }
        if (javascriptProxyfactory.getQName() != null) {
            this.factoriesByQName.remove(javascriptProxyfactory.getQName());
        }
    }

    @Override
    public JavascriptProxyFactory getProxyFactory(QName bindingName) {
        this.loadFactories();
        return this.factoriesByQName.get(bindingName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public JavascriptProxyFactory getProxyFactory(Class<?> bindingType) {
        Class<?>[] classes;
        this.loadFactories();
        for (Class<?> c : classes = bindingType.getInterfaces()) {
            JavascriptProxyFactory proxyFactory = this.factoriesByType.get(c);
            if (proxyFactory == null) continue;
            return proxyFactory;
        }
        JavascriptProxyFactory factory = null;
        if (bindingType.isInterface()) {
            try {
                Class factoryClass = ServiceDiscovery.getInstance().loadFirstServiceClass(bindingType);
                if (factoryClass == null) return factory;
                try {
                    Constructor constructor = factoryClass.getConstructor(new Class[0]);
                    factory = (JavascriptProxyFactory)constructor.newInstance(new Object[0]);
                }
                catch (NoSuchMethodException e) {
                    Constructor constructor = factoryClass.getConstructor(ModelFactoryExtensionPoint.class);
                    factory = (JavascriptProxyFactory)constructor.newInstance(this);
                }
                this.addProxyFactory(factory);
                return factory;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        try {
            factory = (JavascriptProxyFactory)ServiceDiscovery.getInstance().newFactoryClassInstance(bindingType);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        this.addProxyFactory(factory);
        return factory;
    }

    private static QName getQName(String qname) {
        if (qname == null) {
            return null;
        }
        if ((qname = qname.trim()).startsWith("{")) {
            int h = qname.indexOf(125);
            if (h != -1) {
                return new QName(qname.substring(1, h), qname.substring(h + 1));
            }
        } else {
            int h = qname.indexOf(35);
            if (h != -1) {
                return new QName(qname.substring(0, h), qname.substring(h + 1));
            }
        }
        throw new IllegalArgumentException("Invalid qname: " + qname);
    }

    private synchronized void loadFactories() {
        if (this.loaded) {
            return;
        }
        Set factoryDeclarations = null;
        try {
            factoryDeclarations = ServiceDiscovery.getInstance().getServiceDeclarations(JavascriptProxyFactory.class);
        }
        catch (IOException e) {
            IllegalStateException ie = new IllegalStateException(e);
            this.error("IllegalStateException", factoryDeclarations, ie);
            throw ie;
        }
        for (ServiceDeclaration processorDeclaration : factoryDeclarations) {
            Map attributes = processorDeclaration.getAttributes();
            QName artifactType = DefaultJavascriptProxyFactoryExtensionPoint.getQName((String)attributes.get("qname"));
            String modelTypeName = (String)attributes.get("model");
            JavascriptProxyFactory proxyFactory = null;
            try {
                proxyFactory = (JavascriptProxyFactory)processorDeclaration.loadClass().newInstance();
            }
            catch (Exception e) {
                IllegalStateException ie = new IllegalStateException(e);
                this.error("IllegalStateException", proxyFactory, ie);
                throw ie;
            }
            this.addProxyFactory(proxyFactory);
        }
        this.loaded = true;
    }
}

