/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.tuscany.sca.contribution.java.impl;

import org.apache.tuscany.sca.assembly.impl.ExtensibleImpl;
import org.apache.tuscany.sca.contribution.java.JavaExport;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;

/**
 * Implementation of a Java Import model
 *
 * @version $Rev: 767701 $ $Date: 2009-04-22 23:49:55 +0100 (Wed, 22 Apr 2009) $
 */
public class JavaExportImpl extends ExtensibleImpl implements JavaExport {
    private ModelResolver modelResolver;

    /**
     * Java package being exported
     */
    private String packageName;

    public JavaExportImpl() {
        super();
    }

    public String getPackage() {
        return this.packageName;
    }

    public void setPackage(String packageName) {
        this.packageName = packageName;
    }

    public ModelResolver getModelResolver() {
        return modelResolver;
    }

    public void setModelResolver(ModelResolver modelResolver) {
        this.modelResolver = modelResolver;
    }

}
