/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.    
 */

package org.apache.tuscany.sca.binding.atom;

import javax.xml.namespace.QName;

import org.apache.tuscany.sca.assembly.Binding;

/**
 * Atom binding model.
 * 
 * @version $Rev: 951651 $ $Date: 2010-06-05 06:17:47 +0100 (Sat, 05 Jun 2010) $
 */
public interface AtomBinding extends Binding {
    QName TYPE = new QName(SCA11_TUSCANY_NS, "binding.atom");
    
    /**
     * Returns the title of the Atom collection.
     * @return
     */
    String getTitle();
    
    /**
     * Sets the title of the Atom collection.
     * @param title
     */
    void setTitle(String title);

    /**
     * Returns the description of the Atom collection.
     * 
     * @return The description of the Atom collection
     */
    String getDescription();

    /**
     * Sets the description of the Atom collection.
     * 
     * @param description The description of the Atom collection
     */
    void setDescription(String description);
}
