/*
 * Decompiled with CFR 0.152.
 */
package org.oasisopen.sca.client.impl;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URL;
import java.util.Properties;
import org.oasisopen.sca.NoSuchDomainException;
import org.oasisopen.sca.ServiceRuntimeException;
import org.oasisopen.sca.client.SCAClientFactory;
import org.oasisopen.sca.client.SCAClientFactoryFinder;

public class SCAClientFactoryFinderImpl
implements SCAClientFactoryFinder {
    private static final String SCA_CLIENT_FACTORY_PROVIDER_KEY = SCAClientFactory.class.getName();
    private static final String SCA_CLIENT_FACTORY_PROVIDER_META_INF_SERVICE = "META-INF/services/" + SCA_CLIENT_FACTORY_PROVIDER_KEY;

    @Override
    public SCAClientFactory find(Properties properties, ClassLoader classLoader, URI domainURI) throws NoSuchDomainException, ServiceRuntimeException {
        if (classLoader == null) {
            classLoader = SCAClientFactoryFinderImpl.getThreadContextClassLoader();
        }
        String factoryImplClassName = SCAClientFactoryFinderImpl.discoverProviderFactoryImplClass(properties, classLoader);
        Class<? extends SCAClientFactory> factoryImplClass = SCAClientFactoryFinderImpl.loadProviderFactoryClass(factoryImplClassName, classLoader);
        SCAClientFactory factory = SCAClientFactoryFinderImpl.instantiateSCAClientFactoryClass(factoryImplClass, domainURI);
        return factory;
    }

    private static ClassLoader getThreadContextClassLoader() {
        ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
        return threadClassLoader;
    }

    private static String discoverProviderFactoryImplClass(Properties properties, ClassLoader classLoader) throws ServiceRuntimeException {
        String providerClassName = SCAClientFactoryFinderImpl.checkPropertiesForSPIClassName(properties);
        if (providerClassName != null) {
            return providerClassName;
        }
        providerClassName = SCAClientFactoryFinderImpl.checkPropertiesForSPIClassName(System.getProperties());
        if (providerClassName != null) {
            return providerClassName;
        }
        providerClassName = SCAClientFactoryFinderImpl.checkMETAINFServicesForSPIClassName(classLoader);
        if (providerClassName == null) {
            throw new ServiceRuntimeException("Failed to find implementation for SCAClientFactory");
        }
        return providerClassName;
    }

    private static String checkPropertiesForSPIClassName(Properties properties) {
        if (properties == null) {
            return null;
        }
        String providerClassName = properties.getProperty(SCA_CLIENT_FACTORY_PROVIDER_KEY);
        if (providerClassName != null && providerClassName.length() > 0) {
            return providerClassName;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String checkMETAINFServicesForSPIClassName(ClassLoader cl) {
        URL url = cl.getResource(SCA_CLIENT_FACTORY_PROVIDER_META_INF_SERVICE);
        if (url == null) {
            return null;
        }
        InputStream in = null;
        try {
            String string;
            in = url.openStream();
            BufferedReader reader = null;
            try {
                String line;
                reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
                while ((line = SCAClientFactoryFinderImpl.readNextLine(reader)) != null) {
                    if (line.startsWith("#") || line.length() <= 0) continue;
                    string = line;
                }
            }
            catch (Throwable throwable) {
                try {
                    SCAClientFactoryFinderImpl.closeStream(reader);
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new ServiceRuntimeException("Failed to discover SCAClientFactory provider", ex);
                }
            }
            {
                SCAClientFactoryFinderImpl.closeStream(reader);
                return string;
            }
            String string2 = null;
            SCAClientFactoryFinderImpl.closeStream(reader);
            return string2;
        }
        finally {
            SCAClientFactoryFinderImpl.closeStream(in);
        }
    }

    private static String readNextLine(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        if (line != null) {
            line = line.trim();
        }
        return line;
    }

    private static Class<? extends SCAClientFactory> loadProviderFactoryClass(String factoryImplClassName, ClassLoader classLoader) throws ServiceRuntimeException {
        try {
            Class<?> providerClass = classLoader.loadClass(factoryImplClassName);
            Class<SCAClientFactory> providerFactoryClass = providerClass.asSubclass(SCAClientFactory.class);
            return providerFactoryClass;
        }
        catch (ClassNotFoundException ex) {
            throw new ServiceRuntimeException("Failed to load SCAClientFactory implementation class " + factoryImplClassName, ex);
        }
        catch (ClassCastException ex) {
            throw new ServiceRuntimeException("Loaded SCAClientFactory implementation class " + factoryImplClassName + " is not a subclass of " + SCAClientFactory.class.getName(), ex);
        }
    }

    private static SCAClientFactory instantiateSCAClientFactoryClass(Class<? extends SCAClientFactory> factoryImplClass, URI domainURI) throws NoSuchDomainException, ServiceRuntimeException {
        try {
            Constructor<? extends SCAClientFactory> URIConstructor = factoryImplClass.getConstructor(domainURI.getClass());
            SCAClientFactory provider = URIConstructor.newInstance(domainURI);
            return provider;
        }
        catch (Throwable ex) {
            throw new ServiceRuntimeException("Failed to instantiate SCAClientFactory implementation class " + factoryImplClass, ex);
        }
    }

    private static void closeStream(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException ex) {
                throw new ServiceRuntimeException("Failed to close stream", ex);
            }
        }
    }
}

