/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.shell.jline;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import jline.ArgumentCompletor;
import jline.Completor;
import jline.ConsoleReader;
import jline.FileNameCompletor;
import jline.NullCompletor;
import jline.SimpleCompletor;
import org.apache.tuscany.sca.shell.Shell;
import org.apache.tuscany.sca.shell.jline.CompositeURICompletor;
import org.apache.tuscany.sca.shell.jline.ICURICompletor;
import org.apache.tuscany.sca.shell.jline.InstallCompletor;
import org.apache.tuscany.sca.shell.jline.ServiceCompletor;
import org.apache.tuscany.sca.shell.jline.ServiceOperationCompletor;

public class TShellCompletor
extends ArgumentCompletor {
    Map<String, Completor[]> completors;
    final Completor commandCompletor = new SimpleCompletor(Shell.COMMANDS);
    final ArgumentCompletor.ArgumentDelimiter delim = new ArgumentCompletor.WhitespaceArgumentDelimiter();
    final Shell shell;
    static String lastArg;
    static List<String> allArgs;

    public TShellCompletor(Shell shell) {
        super((Completor)null);
        this.shell = shell;
        this.completors = new HashMap<String, Completor[]>();
        this.completors.put("help", new Completor[]{this.commandCompletor, this.commandCompletor, new NullCompletor()});
        this.completors.put("install", new Completor[]{this.commandCompletor, new InstallCompletor(shell)});
        this.completors.put("installed", new Completor[]{this.commandCompletor, new ICURICompletor(shell), new NullCompletor()});
        this.completors.put("invoke", new Completor[]{this.commandCompletor, new ServiceCompletor(shell), new ServiceOperationCompletor(shell), new NullCompletor()});
        this.completors.put("load", new Completor[]{this.commandCompletor, new FileNameCompletor(), new NullCompletor()});
        this.completors.put("remove", new Completor[]{this.commandCompletor, new ICURICompletor(shell), new NullCompletor()});
        this.completors.put("run", new Completor[]{this.commandCompletor, new FileNameCompletor(), new NullCompletor()});
        this.completors.put("save", new Completor[]{this.commandCompletor, new FileNameCompletor(), new NullCompletor()});
        this.completors.put("start", new Completor[]{this.commandCompletor, new ICURICompletor(shell), new CompositeURICompletor(shell), new NullCompletor()});
        this.completors.put("started", new Completor[]{this.commandCompletor, new ICURICompletor(shell), new CompositeURICompletor(shell), new NullCompletor()});
        this.completors.put("stop", new Completor[]{this.commandCompletor, new ICURICompletor(shell), new CompositeURICompletor(shell), new NullCompletor()});
    }

    @Override
    public int complete(String buffer, int cursor, List candidates) {
        ArgumentCompletor.ArgumentList list = this.delim.delimit(buffer, cursor);
        int argpos = list.getArgumentPosition();
        int argIndex = list.getCursorArgumentIndex();
        if (argIndex < 0) {
            return -1;
        }
        if (argIndex > 0 && (lastArg = list.getArguments()[argIndex - 1]) != null) {
            lastArg = lastArg.trim();
        }
        allArgs = Arrays.asList(list.getArguments());
        Completor[] completors = this.getCompletors(buffer);
        Completor comp = argIndex >= completors.length ? completors[completors.length - 1] : completors[argIndex];
        for (int i = 0; this.getStrict() && i < argIndex; ++i) {
            Completor sub = completors[i >= completors.length ? completors.length - 1 : i];
            String[] args = list.getArguments();
            String arg = args == null || i >= args.length ? "" : args[i];
            LinkedList subCandidates = new LinkedList();
            if (sub.complete(arg, arg.length(), subCandidates) == -1) {
                return -1;
            }
            if (subCandidates.size() != 0) continue;
            return -1;
        }
        int ret = comp.complete(list.getCursorArgument(), argpos, candidates);
        if (ret == -1) {
            return -1;
        }
        int pos = ret + (list.getBufferPosition() - argpos);
        if (cursor != buffer.length() && this.delim.isDelimiter(buffer, cursor)) {
            for (int i = 0; i < candidates.size(); ++i) {
                String val = candidates.get(i).toString();
                while (val.length() > 0 && this.delim.isDelimiter(val, val.length() - 1)) {
                    val = val.substring(0, val.length() - 1);
                }
                candidates.set(i, val);
            }
        }
        ConsoleReader.debug("Completing " + buffer + "(pos=" + cursor + ") " + "with: " + candidates + ": offset=" + pos);
        return pos;
    }

    protected Completor[] getCompletors(String buffer) {
        Completor[] completorArray;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < buffer.length() && !Character.isWhitespace(buffer.charAt(i)); ++i) {
            sb.append(buffer.charAt(i));
        }
        String command = sb.toString();
        Completor[] comps = this.completors.get(command);
        if (comps == null) {
            Completor[] completorArray2 = new Completor[1];
            completorArray = completorArray2;
            completorArray2[0] = this.commandCompletor;
        } else {
            completorArray = comps;
        }
        return completorArray;
    }
}

