/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.shell.jline;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jline.SimpleCompletor;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.impl.NodeImpl;
import org.apache.tuscany.sca.runtime.EndpointRegistry;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.shell.Shell;
import org.apache.tuscany.sca.shell.jline.TShellCompletor;

public class ServiceOperationCompletor
extends SimpleCompletor {
    private Shell shell;
    private static final List<String> EXCLUDED_OPS = Arrays.asList("equals", "getClass", "getInvocationHandler", "getProxyClass", "hashCode", "isProxyClass", "newProxyInstance", "notify", "notifyAll", "toString", "wait", "CGLIB$SET_STATIC_CALLBACKS", "CGLIB$SET_THREAD_CALLBACKS", "CGLIB$findMethodProxy", "getCallback", "getCallbacks", "newInstance", "setCallback", "setCallbacks");

    public ServiceOperationCompletor(Shell shell) {
        super("");
        this.shell = shell;
    }

    @Override
    public int complete(String buffer, int cursor, List clist) {
        int i;
        String service = TShellCompletor.lastArg;
        EndpointRegistry reg = ((NodeImpl)this.shell.getNode()).getEndpointRegistry();
        List<Endpoint> endpoints = reg.findEndpoint(service);
        if (endpoints.size() < 1) {
            return -1;
        }
        String serviceName = null;
        if (service.contains("/") && (i = service.indexOf("/")) < service.length() - 1) {
            serviceName = service.substring(i + 1);
        }
        Object proxy = ((RuntimeComponent)endpoints.get(0).getComponent()).getServiceReference(null, serviceName).getService();
        Method[] ms = proxy.getClass().getMethods();
        ArrayList<String> ops = new ArrayList<String>();
        for (Method m : ms) {
            if (EXCLUDED_OPS.contains(m.getName())) continue;
            ops.add(m.getName());
        }
        this.setCandidateStrings(ops.toArray(new String[ops.size()]));
        return super.complete(buffer, cursor, clist);
    }
}

