/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.shell.jline;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.LinkedList;
import jline.ConsoleReader;
import org.apache.tuscany.sca.shell.Shell;
import org.apache.tuscany.sca.shell.jline.TShellCompletor;

public class JLine {
    public static String readLine(Object r) throws IOException {
        return ((ConsoleReader)r).readLine();
    }

    public static Object createJLineReader(final Shell shell) throws IOException {
        ConsoleReader reader = new ConsoleReader();
        JLine.fixCtrlC(reader);
        reader.addTriggeredAction('\u0003', new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                shell.bye();
                System.exit(0);
            }
        });
        reader.setBellEnabled(false);
        LinkedList completors = new LinkedList();
        reader.addCompletor(new TShellCompletor(shell));
        return reader;
    }

    private static void fixCtrlC(ConsoleReader reader) {
        try {
            Field f = ConsoleReader.class.getDeclaredField("keybindings");
            f.setAccessible(true);
            short[] keybindings = (short[])f.get(reader);
            if (keybindings[3] == -48) {
                keybindings[3] = 3;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

