/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.runtime;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.runtime.DomainRegistryFactory;
import org.apache.tuscany.sca.runtime.DomainRegistryFactoryExtensionPoint;
import org.apache.tuscany.sca.runtime.EndpointListener;
import org.apache.tuscany.sca.runtime.EndpointRegistry;
import org.apache.tuscany.sca.runtime.RuntimeProperties;
import org.oasisopen.sca.ServiceRuntimeException;

public class ExtensibleDomainRegistryFactory
implements DomainRegistryFactory {
    private final DomainRegistryFactoryExtensionPoint factories;
    private String[] allSchemes;
    private String defaultScheme = "vm";

    public ExtensibleDomainRegistryFactory(ExtensionPointRegistry registry) {
        this.factories = registry.getExtensionPoint(DomainRegistryFactoryExtensionPoint.class);
        RuntimeProperties ps = registry.getExtensionPoint(UtilityExtensionPoint.class).getUtility(RuntimeProperties.class);
        if (ps.getProperties().containsKey("defaultScheme")) {
            this.defaultScheme = ps.getProperties().getProperty("defaultScheme");
        }
    }

    public ExtensibleDomainRegistryFactory(DomainRegistryFactoryExtensionPoint factories) {
        this.factories = factories;
    }

    public static ExtensibleDomainRegistryFactory getInstance(ExtensionPointRegistry registry) {
        UtilityExtensionPoint utilities = registry.getExtensionPoint(UtilityExtensionPoint.class);
        return utilities.getUtility(ExtensibleDomainRegistryFactory.class);
    }

    @Override
    public void addListener(EndpointListener listener) {
        for (DomainRegistryFactory factory : this.factories.getDomainRegistryFactories()) {
            factory.addListener(listener);
        }
    }

    @Override
    public Collection<EndpointRegistry> getEndpointRegistries() {
        ArrayList<EndpointRegistry> registries = new ArrayList<EndpointRegistry>();
        for (DomainRegistryFactory factory : this.factories.getDomainRegistryFactories()) {
            registries.addAll(factory.getEndpointRegistries());
        }
        return registries;
    }

    @Override
    public EndpointRegistry getEndpointRegistry(String endpointRegistryURI, String domainURI) {
        String scheme;
        if (endpointRegistryURI == null && (endpointRegistryURI = this.factories.getDomainRegistryMapping().get(domainURI)) == null) {
            endpointRegistryURI = domainURI;
        }
        String string = scheme = endpointRegistryURI == null ? null : URI.create(endpointRegistryURI).getScheme();
        if (scheme == null) {
            for (DomainRegistryFactory factory : this.factories.getDomainRegistryFactories()) {
                for (EndpointRegistry endpointRegistry : factory.getEndpointRegistries()) {
                    if (!endpointRegistry.getDomainURI().equals(domainURI)) continue;
                    return endpointRegistry;
                }
            }
            scheme = this.defaultScheme;
            endpointRegistryURI = scheme + ":" + endpointRegistryURI;
        } else {
            scheme = scheme.toLowerCase();
        }
        for (DomainRegistryFactory factory : this.factories.getDomainRegistryFactories()) {
            EndpointRegistry endpointRegistry;
            String[] schemes = factory.getSupportedSchemes();
            if (schemes == null || !Arrays.asList(schemes).contains(scheme) || (endpointRegistry = factory.getEndpointRegistry(endpointRegistryURI, domainURI)) == null) continue;
            return endpointRegistry;
        }
        throw new ServiceRuntimeException("No EndpointRegistry can support " + endpointRegistryURI);
    }

    @Override
    public void removeListener(EndpointListener listener) {
        for (DomainRegistryFactory factory : this.factories.getDomainRegistryFactories()) {
            factory.removeListener(listener);
        }
    }

    @Override
    public synchronized String[] getSupportedSchemes() {
        if (this.allSchemes == null) {
            HashSet<String> supportedSchemes = new HashSet<String>();
            for (DomainRegistryFactory factory : this.factories.getDomainRegistryFactories()) {
                String[] schemes = factory.getSupportedSchemes();
                if (schemes == null) continue;
                supportedSchemes.addAll(Arrays.asList(schemes));
            }
            this.allSchemes = supportedSchemes.toArray(new String[supportedSchemes.size()]);
        }
        return this.allSchemes;
    }
}

