/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.runtime;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.LifeCycleListener;
import org.apache.tuscany.sca.extensibility.ServiceDeclaration;
import org.apache.tuscany.sca.runtime.RuntimeWireProcessor;
import org.apache.tuscany.sca.runtime.RuntimeWireProcessorExtensionPoint;

public class DefaultWireProcessorExtensionPoint
implements RuntimeWireProcessorExtensionPoint,
LifeCycleListener {
    private ExtensionPointRegistry registry;
    private boolean loaded;
    private final List<RuntimeWireProcessor> processors = new ArrayList<RuntimeWireProcessor>();

    public DefaultWireProcessorExtensionPoint(ExtensionPointRegistry registry) {
        this.registry = registry;
    }

    @Override
    public void addWireProcessor(RuntimeWireProcessor processor) {
        this.processors.add(processor);
        if (processor instanceof LifeCycleListener) {
            ((LifeCycleListener)((Object)processor)).start();
        }
    }

    @Override
    public void removeWireProcessor(RuntimeWireProcessor processor) {
        boolean found = this.processors.remove(processor);
        if (found && processor instanceof LifeCycleListener) {
            ((LifeCycleListener)((Object)processor)).stop();
        }
    }

    @Override
    public List<RuntimeWireProcessor> getWireProcessors() {
        this.loadWireProcessors();
        return this.processors;
    }

    private synchronized void loadWireProcessors() {
        if (this.loaded) {
            return;
        }
        try {
            Collection<ServiceDeclaration> sds = this.registry.getServiceDiscovery().getServiceDeclarations(RuntimeWireProcessor.class, true);
            for (ServiceDeclaration sd : sds) {
                Class<?> type = sd.loadClass();
                Constructor<?> constructor = null;
                RuntimeWireProcessor processor = null;
                try {
                    constructor = type.getConstructor(ExtensionPointRegistry.class);
                    processor = (RuntimeWireProcessor)constructor.newInstance(this.registry);
                }
                catch (NoSuchMethodException e) {
                    constructor = type.getConstructor(new Class[0]);
                    processor = (RuntimeWireProcessor)constructor.newInstance(new Object[0]);
                }
                if (processor == null) continue;
                this.addWireProcessor(processor);
            }
            this.loaded = true;
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        for (RuntimeWireProcessor processor : this.processors) {
            if (!(processor instanceof LifeCycleListener)) continue;
            ((LifeCycleListener)((Object)processor)).stop();
        }
        this.processors.clear();
    }
}

