/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.assembly.EndpointReference;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.LifeCycleListener;
import org.apache.tuscany.sca.runtime.EndpointListener;
import org.apache.tuscany.sca.runtime.EndpointRegistry;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;
import org.apache.tuscany.sca.runtime.RuntimeEndpointReference;

public abstract class BaseEndpointRegistry
implements EndpointRegistry,
LifeCycleListener {
    protected static final Logger logger = Logger.getLogger(BaseEndpointRegistry.class.getName());
    protected String domainRegistryURI;
    protected String domainURI;
    protected List<EndpointReference> endpointreferences = new CopyOnWriteArrayList<EndpointReference>();
    protected List<EndpointListener> listeners = new CopyOnWriteArrayList<EndpointListener>();
    protected ExtensionPointRegistry registry;
    protected Map<String, String> attributes;

    public BaseEndpointRegistry(ExtensionPointRegistry registry, Map<String, String> attributes, String domainRegistryURI, String domainURI) {
        this.registry = registry;
        this.domainURI = domainURI;
        this.domainRegistryURI = domainRegistryURI;
        this.attributes = attributes;
    }

    @Override
    public abstract void addEndpoint(Endpoint var1);

    @Override
    public void addEndpointReference(EndpointReference endpointReference) {
        this.endpointreferences.add(endpointReference);
        ((RuntimeEndpointReference)endpointReference).bind(this.registry, this);
        logger.fine("Add endpoint reference - " + endpointReference);
    }

    @Override
    public void addListener(EndpointListener listener) {
        this.listeners.add(listener);
    }

    protected void endpointAdded(Endpoint endpoint) {
        ((RuntimeEndpoint)endpoint).bind(this.registry, this);
        for (EndpointListener listener : this.listeners) {
            listener.endpointAdded(endpoint);
        }
    }

    protected void endpointRemoved(Endpoint endpoint) {
        ((RuntimeEndpoint)endpoint).bind(this.registry, this);
        for (EndpointListener listener : this.listeners) {
            listener.endpointRemoved(endpoint);
        }
    }

    protected void endpointUpdated(Endpoint oldEp, Endpoint newEp) {
        ((RuntimeEndpoint)newEp).bind(this.registry, this);
        for (EndpointListener listener : this.listeners) {
            listener.endpointUpdated(oldEp, newEp);
        }
    }

    @Override
    public List<Endpoint> findEndpoint(EndpointReference endpointReference) {
        logger.fine("Find endpoint for reference - " + endpointReference);
        if (endpointReference.getReference() != null) {
            Endpoint targetEndpoint = endpointReference.getTargetEndpoint();
            String uri = targetEndpoint.getURI();
            if (uri.indexOf(35) == -1) {
                uri = uri + "#service()";
            }
            return this.findEndpoint(uri);
        }
        return new ArrayList<Endpoint>();
    }

    @Override
    public abstract List<Endpoint> findEndpoint(String var1);

    public List<EndpointReference> findEndpointReference(Endpoint endpoint) {
        return this.endpointreferences;
    }

    @Override
    public List<EndpointReference> findEndpointReferences(String uri) {
        ArrayList<EndpointReference> theRefs = new ArrayList<EndpointReference>();
        if (uri == null) {
            return theRefs;
        }
        for (EndpointReference ref : this.endpointreferences) {
            if (!uri.equals(ref.getURI())) continue;
            theRefs.add(ref);
        }
        return theRefs;
    }

    @Override
    public abstract Endpoint getEndpoint(String var1);

    @Override
    public List<EndpointReference> getEndpointReferences() {
        return this.endpointreferences;
    }

    @Override
    public abstract Collection<Endpoint> getEndpoints();

    public List<EndpointListener> getListeners() {
        return this.listeners;
    }

    @Override
    public abstract void removeEndpoint(Endpoint var1);

    @Override
    public void removeEndpointReference(EndpointReference endpointReference) {
        this.endpointreferences.remove(endpointReference);
        logger.fine("Remove endpoint reference - " + endpointReference);
    }

    @Override
    public void removeListener(EndpointListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public String getDomainURI() {
        return this.domainURI;
    }
}

