/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.LifeCycleListener;
import org.apache.tuscany.sca.runtime.DomainRegistryFactory;
import org.apache.tuscany.sca.runtime.EndpointListener;
import org.apache.tuscany.sca.runtime.EndpointRegistry;

public abstract class BaseDomainRegistryFactory
implements DomainRegistryFactory,
LifeCycleListener {
    protected ExtensionPointRegistry registry;
    protected Map<Object, EndpointRegistry> endpointRegistries = new ConcurrentHashMap<Object, EndpointRegistry>();
    protected List<EndpointListener> listeners = new ArrayList<EndpointListener>();

    public BaseDomainRegistryFactory(ExtensionPointRegistry registry) {
        this.registry = registry;
    }

    @Override
    public void start() {
    }

    @Override
    public synchronized EndpointRegistry getEndpointRegistry(String endpointRegistryURI, String domainURI) {
        Object key;
        EndpointRegistry endpointRegistry;
        if (endpointRegistryURI == null) {
            endpointRegistryURI = domainURI;
        }
        if ((endpointRegistry = this.endpointRegistries.get(key = this.getKey(endpointRegistryURI, domainURI))) != null) {
            return endpointRegistry;
        }
        endpointRegistry = this.createEndpointRegistry(endpointRegistryURI, domainURI);
        if (endpointRegistry instanceof LifeCycleListener) {
            ((LifeCycleListener)((Object)endpointRegistry)).start();
        }
        for (EndpointListener listener : this.listeners) {
            endpointRegistry.addListener(listener);
        }
        this.endpointRegistries.put(key, endpointRegistry);
        return endpointRegistry;
    }

    protected Object getKey(String endpointRegistryURI, String domainURI) {
        return endpointRegistryURI + "," + domainURI;
    }

    protected abstract EndpointRegistry createEndpointRegistry(String var1, String var2);

    @Override
    public void stop() {
        for (EndpointRegistry endpointRegistry : this.endpointRegistries.values()) {
            if (!(endpointRegistry instanceof LifeCycleListener)) continue;
            ((LifeCycleListener)((Object)endpointRegistry)).stop();
        }
        this.endpointRegistries.clear();
        this.listeners.clear();
    }

    @Override
    public synchronized Collection<EndpointRegistry> getEndpointRegistries() {
        return new ArrayList<EndpointRegistry>(this.endpointRegistries.values());
    }

    @Override
    public synchronized void addListener(EndpointListener listener) {
        this.listeners.add(listener);
        for (EndpointRegistry registry : this.endpointRegistries.values()) {
            registry.addListener(listener);
        }
    }

    public synchronized List<EndpointListener> getListeners() {
        return this.listeners;
    }

    @Override
    public synchronized void removeListener(EndpointListener listener) {
        this.listeners.remove(listener);
        for (EndpointRegistry registry : this.endpointRegistries.values()) {
            registry.removeListener(listener);
        }
    }
}

