/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.policy.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.definitions.Definitions;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.policy.PolicyExpression;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.policy.PolicySubject;

public class PolicyHelper {
    public PolicySet getPolicySet(PolicySubject subject, QName policySetName) {
        for (PolicySet ps : subject.getPolicySets()) {
            if (!ps.getName().equals(policySetName)) continue;
            return ps;
        }
        return null;
    }

    public Intent getIntent(Definitions subject, QName intentName) {
        for (Intent i : subject.getIntents()) {
            if (!i.getName().equals(intentName)) continue;
            return i;
        }
        return null;
    }

    public PolicySet getPolicySet(Definitions subject, QName policySetName) {
        for (PolicySet ps : subject.getPolicySets()) {
            if (!ps.getName().equals(policySetName)) continue;
            return ps;
        }
        return null;
    }

    public Intent getIntent(PolicySubject subject, QName intentName) {
        for (Intent i : subject.getRequiredIntents()) {
            if (!i.getName().equals(intentName)) continue;
            return i;
        }
        return null;
    }

    public Collection<PolicyExpression> getPolicyExpressions(PolicySubject subject, QName policyName) {
        ArrayList<PolicyExpression> policies = new ArrayList<PolicyExpression>();
        for (PolicySet ps : subject.getPolicySets()) {
            for (PolicyExpression exp : ps.getPolicies()) {
                if (!exp.getName().equals(policyName)) continue;
                policies.add(exp);
            }
        }
        return policies;
    }

    public Collection<Object> getPolicies(PolicySubject subject, QName policyName) {
        ArrayList<Object> policies = new ArrayList<Object>();
        for (PolicySet ps : subject.getPolicySets()) {
            for (PolicyExpression exp : ps.getPolicies()) {
                if (!exp.getName().equals(policyName)) continue;
                policies.add(exp.getPolicy());
            }
        }
        return policies;
    }

    public static PolicySet getPolicySet(Binding wsBinding, QName intentName) {
        PolicySet returnPolicySet = null;
        if (wsBinding instanceof PolicySubject) {
            PolicySubject policiedBinding = (PolicySubject)((Object)wsBinding);
            block0: for (PolicySet policySet : policiedBinding.getPolicySets()) {
                for (Intent intent : policySet.getProvidedIntents()) {
                    if (!intent.getName().equals(intentName)) continue;
                    returnPolicySet = policySet;
                    continue block0;
                }
            }
        }
        return returnPolicySet;
    }

    public static boolean isIntentRequired(Binding wsBinding, QName intent) {
        if (wsBinding instanceof PolicySubject) {
            List<Intent> intents = ((PolicySubject)((Object)wsBinding)).getRequiredIntents();
            for (Intent i : intents) {
                if (!intent.equals(i.getName())) continue;
                return true;
            }
        }
        return PolicyHelper.getPolicySet(wsBinding, intent) != null;
    }
}

