/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.policy.security.jaas;

import java.util.ArrayList;
import java.util.List;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.PhasedInterceptor;
import org.apache.tuscany.sca.policy.PolicyExpression;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.policy.security.jaas.JaasAuthenticationInterceptor;
import org.apache.tuscany.sca.policy.security.jaas.JaasAuthenticationPolicy;
import org.apache.tuscany.sca.provider.BasePolicyProvider;
import org.apache.tuscany.sca.runtime.RuntimeComponent;

public class JaasAuthenticationImplementationPolicyProvider
extends BasePolicyProvider<JaasAuthenticationPolicy> {
    private RuntimeComponent component;
    private Implementation implementation;

    public JaasAuthenticationImplementationPolicyProvider(RuntimeComponent component) {
        super(JaasAuthenticationPolicy.class, component);
        this.component = component;
        this.implementation = component.getImplementation();
    }

    private List<JaasAuthenticationPolicy> findPolicies(Operation op) {
        ArrayList<JaasAuthenticationPolicy> polices = new ArrayList<JaasAuthenticationPolicy>();
        List<PolicySet> policySets = this.component.getPolicySets();
        for (PolicySet ps : policySets) {
            for (PolicyExpression p : ps.getPolicies()) {
                if (!JaasAuthenticationPolicy.class.isInstance(p)) continue;
                polices.add((JaasAuthenticationPolicy)((Object)p));
            }
        }
        return polices;
    }

    @Override
    public PhasedInterceptor createInterceptor(Operation operation) {
        List<JaasAuthenticationPolicy> policies = this.findPolicies(operation);
        if (policies == null || policies.isEmpty()) {
            return null;
        }
        return new JaasAuthenticationInterceptor(this.findPolicies(operation));
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }
}

