/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.policy.identity;

import java.util.ArrayList;
import java.util.List;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.PhasedInterceptor;
import org.apache.tuscany.sca.policy.PolicyExpression;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.policy.identity.SecurityIdentityImplementationPolicyInterceptor;
import org.apache.tuscany.sca.policy.identity.SecurityIdentityPolicy;
import org.apache.tuscany.sca.provider.BasePolicyProvider;
import org.apache.tuscany.sca.runtime.RuntimeComponent;

public class SecurityIdentityImplementationPolicyProvider
extends BasePolicyProvider<SecurityIdentityPolicy> {
    private RuntimeComponent component;
    private Implementation implementation;

    public SecurityIdentityImplementationPolicyProvider(RuntimeComponent component) {
        super(SecurityIdentityPolicy.class, component);
        this.component = component;
        this.implementation = component.getImplementation();
    }

    private List<SecurityIdentityPolicy> findPolicies(Operation op) {
        ArrayList<SecurityIdentityPolicy> polices = new ArrayList<SecurityIdentityPolicy>();
        List<PolicySet> policySets = this.component.getPolicySets();
        for (PolicySet ps : policySets) {
            for (PolicyExpression p : ps.getPolicies()) {
                if (!SecurityIdentityPolicy.class.isInstance(p)) continue;
                polices.add((SecurityIdentityPolicy)((Object)p));
            }
        }
        return polices;
    }

    @Override
    public PhasedInterceptor createInterceptor(Operation operation) {
        List<SecurityIdentityPolicy> policies = this.findPolicies(operation);
        if (policies == null || policies.isEmpty()) {
            return null;
        }
        return new SecurityIdentityImplementationPolicyInterceptor(this.findPolicies(operation));
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }
}

